/*
 * Decompiled with CFR 0.152.
 */
package healpix.essentials;

import healpix.essentials.HealpixUtils;
import healpix.essentials.Moc;
import healpix.essentials.RangeSet;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import nom.tam.fits.BasicHDU;
import nom.tam.fits.BinaryTable;
import nom.tam.fits.BinaryTableHDU;
import nom.tam.fits.Fits;
import nom.tam.fits.FitsFactory;
import nom.tam.fits.Header;

public class MocFitsIO {
    public static Moc mocFromFits(InputStream inp) throws Exception {
        int i;
        Object[] tmp2;
        FitsFactory.setUseHierarch((boolean)true);
        FitsFactory.setUseAsciiTables((boolean)false);
        FitsFactory.setLongStringsEnabled((boolean)true);
        BasicHDU bhdu = new Fits(inp).getHDU(1);
        Header head = bhdu.getHeader();
        Object tmp = ((BinaryTable)bhdu.getData()).getFlattenedColumn(0);
        long[] data = null;
        if (tmp instanceof long[]) {
            data = (long[])tmp;
        } else if (tmp instanceof int[]) {
            tmp2 = (int[])tmp;
            data = new long[tmp2.length];
            for (i = 0; i < tmp2.length; ++i) {
                data[i] = tmp2[i];
            }
        } else if (tmp instanceof short[]) {
            tmp2 = (short[])tmp;
            data = new long[tmp2.length];
            for (i = 0; i < tmp2.length; ++i) {
                data[i] = tmp2[i];
            }
        } else {
            HealpixUtils.check(false, "unsupported data format");
        }
        RangeSet ru = new RangeSet();
        for (i = 0; i < data.length; ++i) {
            ru.append(data[i]);
        }
        return Moc.fromUniqRS(ru);
    }

    public static Moc mocFromFits(String filename) throws Exception {
        FileInputStream inp = new FileInputStream(filename);
        Moc moc = MocFitsIO.mocFromFits(inp);
        inp.close();
        return moc;
    }

    public static void mocToFits(Moc moc, OutputStream out) throws Exception {
        Object[] dtmp;
        FitsFactory.setUseHierarch((boolean)true);
        FitsFactory.setUseAsciiTables((boolean)false);
        FitsFactory.setLongStringsEnabled((boolean)true);
        Fits f = new Fits();
        Object[] table = new Object[1];
        long[] data = moc.toUniq();
        long maxval = 0L;
        if (data.length > 0) {
            maxval = data[data.length - 1];
        }
        if (maxval <= 32767L) {
            dtmp = new short[data.length];
            for (int i = 0; i < data.length; ++i) {
                dtmp[i] = (short)data[i];
            }
            table[0] = dtmp;
        } else if (maxval <= Integer.MAX_VALUE) {
            dtmp = new int[data.length];
            for (int i = 0; i < data.length; ++i) {
                dtmp[i] = (int)data[i];
            }
            table[0] = dtmp;
        } else {
            table[0] = data;
        }
        f.addHDU(Fits.makeHDU((Object)table));
        BinaryTableHDU bhdu = (BinaryTableHDU)f.getHDU(1);
        bhdu.setColumnName(0, "PIXEL", "");
        bhdu.addValue("PIXTYPE", "HEALPIX", "HEALPix magic value");
        bhdu.addValue("ORDERING", "NUNIQ", "NUNIQ coding method");
        bhdu.addValue("COORDSYS", "C", "mandated by MOC standard");
        bhdu.addValue("MOCORDER", moc.maxOrder(), "MOC resolution (best order)");
        f.write((DataOutput)new DataOutputStream(out));
        out.flush();
    }

    public static void mocToFits(Moc moc, String filename) throws Exception {
        FileOutputStream out = new FileOutputStream(filename);
        MocFitsIO.mocToFits(moc, out);
        out.close();
    }
}

