/*
 * Decompiled with CFR 0.152.
 */
package healpix.essentials;

import healpix.essentials.HealpixMapDouble;
import healpix.essentials.HealpixMapFloat;
import healpix.essentials.HealpixUtils;
import healpix.essentials.Scheme;
import java.io.DataOutput;
import java.io.FileOutputStream;
import java.io.OutputStream;
import nom.tam.fits.BasicHDU;
import nom.tam.fits.BinaryTable;
import nom.tam.fits.BinaryTableHDU;
import nom.tam.fits.Fits;
import nom.tam.fits.FitsFactory;
import nom.tam.fits.Header;
import nom.tam.util.BufferedDataOutputStream;

public class FitsUtil {
    private static String getKey(Header head, String key) throws Exception {
        String upkey = key.toUpperCase();
        if (head.containsKey(upkey)) {
            return head.findCard(upkey).getValue().trim();
        }
        if (head.containsKey("HIERARCH." + key)) {
            return head.findCard("HIERARCH." + key).getValue().trim();
        }
        HealpixUtils.check(false, "key not found: " + key);
        return null;
    }

    private static Scheme getScheme(Header head) throws Exception {
        String fscheme = FitsUtil.getKey(head, "Ordering");
        HealpixUtils.check(fscheme.equals("RING") || fscheme.equals("NESTED"), "unsupported ordering scheme");
        return fscheme.equals("RING") ? Scheme.RING : Scheme.NESTED;
    }

    public static HealpixMapFloat getFloatMap(String filename, int hdu, int col) throws Exception {
        FitsFactory.setUseHierarch((boolean)true);
        FitsFactory.setUseAsciiTables((boolean)false);
        FitsFactory.setLongStringsEnabled((boolean)true);
        BasicHDU bhdu = new Fits(filename).getHDU(hdu - 1);
        Header head = bhdu.getHeader();
        Scheme scheme = FitsUtil.getScheme(head);
        int nside = Integer.parseInt(FitsUtil.getKey(head, "Nside"));
        Object tmp = ((BinaryTable)bhdu.getData()).getFlattenedColumn(col - 1);
        float[] data = null;
        if (tmp instanceof float[]) {
            data = (float[])tmp;
        } else if (tmp instanceof double[]) {
            double[] tmp2 = (double[])tmp;
            data = new float[tmp2.length];
            for (int i = 0; i < tmp2.length; ++i) {
                data[i] = (float)tmp2[i];
            }
        } else {
            HealpixUtils.check(false, "unsupported data format");
        }
        HealpixUtils.check(nside * nside * 12 == data.length, "inconsistent Nside and column length");
        return new HealpixMapFloat(data, scheme);
    }

    public static HealpixMapDouble getDoubleMap(String filename, int hdu, int col) throws Exception {
        FitsFactory.setUseHierarch((boolean)true);
        FitsFactory.setUseAsciiTables((boolean)false);
        FitsFactory.setLongStringsEnabled((boolean)true);
        BasicHDU bhdu = new Fits(filename).getHDU(hdu - 1);
        Header head = bhdu.getHeader();
        Scheme scheme = FitsUtil.getScheme(head);
        int nside = Integer.parseInt(FitsUtil.getKey(head, "Nside"));
        Object tmp = ((BinaryTable)bhdu.getData()).getFlattenedColumn(col - 1);
        double[] data = null;
        if (tmp instanceof double[]) {
            data = (double[])tmp;
        } else if (tmp instanceof float[]) {
            float[] tmp2 = (float[])tmp;
            data = new double[tmp2.length];
            for (int i = 0; i < tmp2.length; ++i) {
                data[i] = tmp2[i];
            }
        } else {
            HealpixUtils.check(false, "unsupported data format");
        }
        HealpixUtils.check(nside * nside * 12 == data.length, "inconsistent Nside and column length");
        return new HealpixMapDouble(data, scheme);
    }

    public static void writeFloatMap(HealpixMapFloat map, String filename) throws Exception {
        FitsFactory.setUseHierarch((boolean)true);
        FitsFactory.setUseAsciiTables((boolean)false);
        Fits f = new Fits();
        Object[] table = new Object[]{map.getData()};
        f.addHDU(Fits.makeHDU((Object)table));
        BinaryTableHDU bhdu = (BinaryTableHDU)f.getHDU(1);
        bhdu.setColumnName(0, "data", "values");
        bhdu.addValue("PIXTYPE", "HEALPIX", "This is a HEALPix map");
        bhdu.addValue("NSIDE", map.getNside(), "HEALPix NSIDE parameter");
        bhdu.addValue("ORDERING", map.getScheme().toString().toUpperCase(), "HEALPix ordering scheme");
        FileOutputStream fos = new FileOutputStream(filename);
        BufferedDataOutputStream s = new BufferedDataOutputStream((OutputStream)fos);
        f.write((DataOutput)s);
        s.flush();
        s.close();
    }

    public static void writeDoubleMap(HealpixMapDouble map, String filename) throws Exception {
        FitsFactory.setUseHierarch((boolean)true);
        FitsFactory.setUseAsciiTables((boolean)false);
        Fits f = new Fits();
        Object[] table = new Object[]{map.getData()};
        f.addHDU(Fits.makeHDU((Object)table));
        BinaryTableHDU bhdu = (BinaryTableHDU)f.getHDU(1);
        bhdu.setColumnName(0, "data", "values");
        bhdu.addValue("PIXTYPE", "HEALPIX", "This is a HEALPix map");
        bhdu.addValue("NSIDE", map.getNside(), "HEALPix NSIDE parameter");
        bhdu.addValue("ORDERING", map.getScheme().toString().toUpperCase(), "HEALPix ordering scheme");
        FileOutputStream fos = new FileOutputStream(filename);
        BufferedDataOutputStream s = new BufferedDataOutputStream((OutputStream)fos);
        f.write((DataOutput)s);
        s.flush();
        s.close();
    }
}

