/*
 * Decompiled with CFR 0.152.
 */
package healpix.essentials;

import healpix.essentials.CircleFinder;
import healpix.essentials.FastMath;
import healpix.essentials.Fxyf;
import healpix.essentials.HealpixProc;
import healpix.essentials.HealpixTables;
import healpix.essentials.HealpixUtils;
import healpix.essentials.Hploc;
import healpix.essentials.Pointing;
import healpix.essentials.RangeSet;
import healpix.essentials.Scheme;
import healpix.essentials.Vec3;
import healpix.essentials.Zphi;
import java.util.Arrays;

public class HealpixBase
extends HealpixTables {
    public static final int order_max = 29;
    public static final long ns_max = 0x20000000L;
    protected int order;
    protected long nside;
    protected long nl2;
    protected long nl3;
    protected long nl4;
    protected long npface;
    protected long npix;
    protected long ncap;
    protected double fact1;
    protected double fact2;
    protected Scheme scheme;

    private static long spread_bits(int v) {
        return (long)utab[v & 0xFF] | (long)utab[v >>> 8 & 0xFF] << 16 | (long)utab[v >>> 16 & 0xFF] << 32 | (long)utab[v >>> 24 & 0xFF] << 48;
    }

    private static int compress_bits(long v) {
        long raw = v & 0x5555555555555555L;
        raw |= raw >>> 15;
        int raw1 = (int)(raw & 0xFFFFL);
        int raw2 = (int)(raw >>> 32 & 0xFFFFL);
        return ctab[raw1 & 0xFF] | ctab[raw1 >>> 8] << 4 | ctab[raw2 & 0xFF] << 16 | ctab[raw2 >>> 8] << 20;
    }

    private Xyf nest2xyf(long ipix) {
        long pix = ipix & this.npface - 1L;
        return new Xyf(HealpixBase.compress_bits(pix), HealpixBase.compress_bits(pix >>> 1), (int)(ipix >>> 2 * this.order));
    }

    private long xyf2nest(int ix, int iy, int face_num) {
        return ((long)face_num << 2 * this.order) + HealpixBase.spread_bits(ix) + (HealpixBase.spread_bits(iy) << 1);
    }

    private long xyf2ring(int ix, int iy, int face_num) {
        long jr = (long)jrll[face_num] * this.nside - (long)ix - (long)iy - 1L;
        RingInfoSmall ris = this.get_ring_info_small(jr);
        long nr = ris.ringpix >>> 2;
        long kshift = ris.shifted ? 0L : 1L;
        long jp = ((long)jpll[face_num] * nr + (long)ix - (long)iy + 1L + kshift) / 2L;
        if (jp > this.nl4) {
            jp -= this.nl4;
        } else if (jp < 1L) {
            jp += this.nl4;
        }
        return ris.startpix + jp - 1L;
    }

    protected Xyf ring2xyf(long pix) {
        long ip;
        long nr;
        long kshift;
        long iphi;
        long iring;
        Xyf ret = new Xyf();
        if (pix < this.ncap) {
            iring = 1 + HealpixUtils.isqrt(1L + 2L * pix) >>> 1;
            iphi = pix + 1L - 2L * iring * (iring - 1L);
            kshift = 0L;
            nr = iring;
            ret.face = (int)((iphi - 1L) / nr);
        } else if (pix < this.npix - this.ncap) {
            ip = pix - this.ncap;
            long tmp = this.order >= 0 ? ip >>> this.order + 2 : ip / this.nl4;
            iring = tmp + this.nside;
            iphi = ip - tmp * this.nl4 + 1L;
            kshift = iring + this.nside & 1L;
            nr = this.nside;
            long ire = iring - this.nside + 1L;
            long irm = this.nl2 + 2L - ire;
            long ifm = iphi - (ire >>> 1) + this.nside - 1L;
            long ifp = iphi - (irm >>> 1) + this.nside - 1L;
            if (this.order >= 0) {
                ifm >>>= this.order;
                ifp >>>= this.order;
            } else {
                ifm /= this.nside;
                ifp /= this.nside;
            }
            ret.face = (int)(ifp == ifm ? ifp | 4L : (ifp < ifm ? ifp : ifm + 8L));
        } else {
            ip = this.npix - pix;
            iring = 1 + HealpixUtils.isqrt(2L * ip - 1L) >>> 1;
            iphi = 4L * iring + 1L - (ip - 2L * iring * (iring - 1L));
            kshift = 0L;
            nr = iring;
            iring = 2L * this.nl2 - iring;
            ret.face = 8 + (int)((iphi - 1L) / nr);
        }
        long irt = iring - (long)jrll[ret.face] * this.nside + 1L;
        long ipt = 2L * iphi - (long)jpll[ret.face] * nr - kshift - 1L;
        if (ipt >= this.nl2) {
            ipt -= 8L * this.nside;
        }
        ret.ix = (int)(ipt - irt >>> 1);
        ret.iy = (int)(-ipt - irt >>> 1);
        return ret;
    }

    protected Xyf pix2xyf(long pix) {
        return this.scheme == Scheme.RING ? this.ring2xyf(pix) : this.nest2xyf(pix);
    }

    protected long xyf2pix(int ix, int iy, int face_num) {
        return this.scheme == Scheme.RING ? this.xyf2ring(ix, iy, face_num) : this.xyf2nest(ix, iy, face_num);
    }

    protected long xyf2pix(Xyf xyf) {
        return this.scheme == Scheme.RING ? this.xyf2ring(xyf.ix, xyf.iy, xyf.face) : this.xyf2nest(xyf.ix, xyf.iy, xyf.face);
    }

    public static int nside2order(long nside) throws Exception {
        HealpixUtils.check(nside > 0L, "nside must be positive");
        return (nside & nside - 1L) != 0L ? -1 : HealpixUtils.ilog2(nside);
    }

    public static long npix2Nside(long npix) throws Exception {
        HealpixUtils.check(npix > 0L, "npix must be positive");
        long nside = HealpixUtils.isqrt(npix / 12L);
        HealpixUtils.check(12L * nside * nside == npix, "npix is not 12*nside*nside");
        HealpixUtils.check(nside <= 0x20000000L, "nside is too large");
        return nside;
    }

    public static long nside2Npix(long nside) throws Exception {
        HealpixUtils.check(nside > 0L, "nside must be positive");
        HealpixUtils.check(nside <= 0x20000000L, "nside is too large");
        return 12L * nside * nside;
    }

    public static long order2Npix(int order) throws Exception {
        HealpixUtils.check(order >= 0, "order must be nonnegative");
        HealpixUtils.check(order <= 29, "order is too large");
        return 12L * (1L << 2 * order);
    }

    public void setNside(long nside_in) throws Exception {
        if (this.nside == nside_in) {
            return;
        }
        this.nside = nside_in;
        HealpixUtils.check(this.nside <= 0x20000000L && this.nside > 0L, "Nside must be between 1 and 536870912");
        this.order = HealpixBase.nside2order(this.nside);
        if (this.scheme == Scheme.NESTED && this.order < 0) {
            throw new Exception("Nside must be a power of 2 for NESTED scheme");
        }
        this.nl2 = 2L * this.nside;
        this.nl3 = 3L * this.nside;
        this.nl4 = 4L * this.nside;
        this.npface = this.nside * this.nside;
        this.ncap = 2L * this.nside * (this.nside - 1L);
        this.npix = 12L * this.npface;
        this.fact2 = 4.0 / (double)this.npix;
        this.fact1 = (double)(this.nside << 1) * this.fact2;
    }

    public void setNsideAndScheme(long nside_in, Scheme scheme_in) throws Exception {
        if (this.scheme == scheme_in && this.nside == nside_in) {
            return;
        }
        HealpixUtils.check((nside_in & nside_in - 1L) == 0L || scheme_in == Scheme.RING, "Nside must be a power of 2 for NESTED scheme");
        this.scheme = scheme_in;
        this.setNside(nside_in);
    }

    public HealpixBase() {
        try {
            this.nside = 0L;
            this.setNsideAndScheme(1L, Scheme.NESTED);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public HealpixBase(long nside_in, Scheme scheme_in) throws Exception {
        this.nside = nside_in - 1L;
        this.setNsideAndScheme(nside_in, scheme_in);
    }

    public Scheme getScheme() {
        return this.scheme;
    }

    public int getNside() {
        return (int)this.nside;
    }

    public long getNpix() {
        return this.npix;
    }

    public void setScheme(Scheme scheme_in) throws Exception {
        if (scheme_in == Scheme.NESTED && this.order < 0) {
            throw new Exception("Nside must be a power of 2 for NESTED scheme");
        }
        this.scheme = scheme_in;
    }

    public int getOrder() {
        return this.order;
    }

    public long ang2pix(Pointing ptg) throws Exception {
        return this.loc2pix(new Hploc(ptg));
    }

    public Pointing pix2ang(long pix) throws Exception {
        return this.pix2loc(pix).toPointing();
    }

    public long vec2pix(Vec3 vec) throws Exception {
        return this.loc2pix(new Hploc(vec));
    }

    public Vec3 pix2vec(long pix) throws Exception {
        return this.pix2loc(pix).toVec3();
    }

    public long ring2nest(long ipring) throws Exception {
        Xyf xyf = this.ring2xyf(ipring);
        return this.xyf2nest(xyf.ix, xyf.iy, xyf.face);
    }

    public long nest2ring(long ipnest) throws Exception {
        Xyf xyf = this.nest2xyf(ipnest);
        return this.xyf2ring(xyf.ix, xyf.iy, xyf.face);
    }

    protected long loc2pix(Hploc loc) {
        double z = loc.z;
        double phi = loc.phi;
        double za = Math.abs(z);
        double tt = HealpixUtils.fmodulo(phi * 0.6366197723675814, 4.0);
        if (this.scheme == Scheme.RING) {
            if (za <= 0.6666666666666666) {
                double temp1 = (double)this.nside * (0.5 + tt);
                double temp2 = (double)this.nside * z * 0.75;
                long jp = (long)(temp1 - temp2);
                long jm = (long)(temp1 + temp2);
                long ir = this.nside + 1L + jp - jm;
                long kshift = 1L - (ir & 1L);
                long t1 = jp + jm - this.nside + kshift + 1L + this.nl4 + this.nl4;
                long ip = this.order > 0 ? t1 >>> 1 & this.nl4 - 1L : (t1 >>> 1) % this.nl4;
                return this.ncap + (ir - 1L) * this.nl4 + ip;
            }
            double tp = tt - (double)((long)tt);
            double tmp = za < 0.99 || !loc.have_sth ? (double)this.nside * Math.sqrt(3.0 * (1.0 - za)) : (double)this.nside * loc.sth / Math.sqrt((1.0 + za) / 3.0);
            long jp = (long)(tp * tmp);
            long jm = (long)((1.0 - tp) * tmp);
            long ir = jp + jm + 1L;
            long ip = (long)(tt * (double)ir);
            assert (ip >= 0L && ip < 4L * ir);
            return z > 0.0 ? 2L * ir * (ir - 1L) + ip : this.npix - 2L * ir * (ir + 1L) + ip;
        }
        if (za <= 0.6666666666666666) {
            double temp1 = (double)this.nside * (0.5 + tt);
            double temp2 = (double)this.nside * (z * 0.75);
            long jp = (long)(temp1 - temp2);
            long ifp = jp >>> this.order;
            long jm = (long)(temp1 + temp2);
            long ifm = jm >>> this.order;
            long face_num = ifp == ifm ? ifp | 4L : (ifp < ifm ? ifp : ifm + 8L);
            long ix = jm & this.nside - 1L;
            long iy = this.nside - (jp & this.nside - 1L) - 1L;
            return this.xyf2nest((int)ix, (int)iy, (int)face_num);
        }
        int ntt = Math.min(3, (int)tt);
        double tp = tt - (double)ntt;
        double tmp = za < 0.99 || !loc.have_sth ? (double)this.nside * Math.sqrt(3.0 * (1.0 - za)) : (double)this.nside * loc.sth / Math.sqrt((1.0 + za) / 3.0);
        long jp = (long)(tp * tmp);
        long jm = (long)((1.0 - tp) * tmp);
        if (jp >= this.nside) {
            jp = this.nside - 1L;
        }
        if (jm >= this.nside) {
            jm = this.nside - 1L;
        }
        return z >= 0.0 ? this.xyf2nest((int)(this.nside - jm - 1L), (int)(this.nside - jp - 1L), ntt) : this.xyf2nest((int)jp, (int)jm, ntt + 8);
    }

    public long zphi2pix(Zphi zphi) {
        return this.loc2pix(new Hploc(zphi));
    }

    protected Hploc pix2loc(long pix) {
        Hploc loc = new Hploc();
        if (this.scheme == Scheme.RING) {
            if (pix < this.ncap) {
                long iring = 1 + HealpixUtils.isqrt(1L + 2L * pix) >>> 1;
                long iphi = pix + 1L - 2L * iring * (iring - 1L);
                double tmp = (double)(iring * iring) * this.fact2;
                loc.z = 1.0 - tmp;
                if (loc.z > 0.99) {
                    loc.sth = Math.sqrt(tmp * (2.0 - tmp));
                    loc.have_sth = true;
                }
                loc.phi = ((double)iphi - 0.5) * 1.5707963267948966 / (double)iring;
            } else if (pix < this.npix - this.ncap) {
                long ip = pix - this.ncap;
                long tmp = this.order >= 0 ? ip >>> this.order + 2 : ip / this.nl4;
                long iring = tmp + this.nside;
                long iphi = ip - this.nl4 * tmp + 1L;
                double fodd = (iring + this.nside & 1L) != 0L ? 1.0 : 0.5;
                loc.z = (double)(this.nl2 - iring) * this.fact1;
                loc.phi = ((double)iphi - fodd) * Math.PI * 0.75 * this.fact1;
            } else {
                long ip = this.npix - pix;
                long iring = 1 + HealpixUtils.isqrt(2L * ip - 1L) >>> 1;
                long iphi = 4L * iring + 1L - (ip - 2L * iring * (iring - 1L));
                double tmp = (double)(iring * iring) * this.fact2;
                loc.z = tmp - 1.0;
                if (loc.z < -0.99) {
                    loc.sth = Math.sqrt(tmp * (2.0 - tmp));
                    loc.have_sth = true;
                }
                loc.phi = ((double)iphi - 0.5) * 1.5707963267948966 / (double)iring;
            }
        } else {
            double tmp;
            long nr;
            Xyf xyf = this.nest2xyf(pix);
            long jr = ((long)jrll[xyf.face] << this.order) - (long)xyf.ix - (long)xyf.iy - 1L;
            if (jr < this.nside) {
                nr = jr;
                tmp = (double)(nr * nr) * this.fact2;
                loc.z = 1.0 - tmp;
                if (loc.z > 0.99) {
                    loc.sth = Math.sqrt(tmp * (2.0 - tmp));
                    loc.have_sth = true;
                }
            } else if (jr > this.nl3) {
                nr = this.nl4 - jr;
                tmp = (double)(nr * nr) * this.fact2;
                loc.z = tmp - 1.0;
                if (loc.z < -0.99) {
                    loc.sth = Math.sqrt(tmp * (2.0 - tmp));
                    loc.have_sth = true;
                }
            } else {
                nr = this.nside;
                loc.z = (double)(this.nl2 - jr) * this.fact1;
            }
            long tmp2 = (long)jpll[xyf.face] * nr + (long)xyf.ix - (long)xyf.iy;
            assert (tmp2 < 8L * nr);
            if (tmp2 < 0L) {
                tmp2 += 8L * nr;
            }
            loc.phi = nr == this.nside ? 1.1780972450961724 * (double)tmp2 * this.fact1 : 0.7853981633974483 * (double)tmp2 / (double)nr;
        }
        return loc;
    }

    public Zphi pix2zphi(long pix) {
        return this.pix2loc(pix).toZphi();
    }

    public long[] neighbours(long ipix) throws Exception {
        long[] result = new long[8];
        Xyf xyf = this.scheme == Scheme.NESTED ? this.nest2xyf(ipix) : this.ring2xyf(ipix);
        int ix = xyf.ix;
        int iy = xyf.iy;
        int face_num = xyf.face;
        long nsm1 = this.nside - 1L;
        if (ix > 0 && (long)ix < nsm1 && iy > 0 && (long)iy < nsm1) {
            if (this.scheme == Scheme.RING) {
                for (int m = 0; m < 8; ++m) {
                    result[m] = this.xyf2ring(ix + xoffset[m], iy + yoffset[m], face_num);
                }
            } else {
                long fpix = (long)face_num << 2 * this.order;
                long px0 = HealpixBase.spread_bits(ix);
                long py0 = HealpixBase.spread_bits(iy) << 1;
                long pxp = HealpixBase.spread_bits(ix + 1);
                long pyp = HealpixBase.spread_bits(iy + 1) << 1;
                long pxm = HealpixBase.spread_bits(ix - 1);
                long pym = HealpixBase.spread_bits(iy - 1) << 1;
                result[0] = fpix + pxm + py0;
                result[1] = fpix + pxm + pyp;
                result[2] = fpix + px0 + pyp;
                result[3] = fpix + pxp + pyp;
                result[4] = fpix + pxp + py0;
                result[5] = fpix + pxp + pym;
                result[6] = fpix + px0 + pym;
                result[7] = fpix + pxm + pym;
            }
        } else {
            for (int i = 0; i < 8; ++i) {
                int x = ix + xoffset[i];
                int y = iy + yoffset[i];
                int nbnum = 4;
                if (x < 0) {
                    x = (int)((long)x + this.nside);
                    --nbnum;
                } else if ((long)x >= this.nside) {
                    x = (int)((long)x - this.nside);
                    ++nbnum;
                }
                if (y < 0) {
                    y = (int)((long)y + this.nside);
                    nbnum -= 3;
                } else if ((long)y >= this.nside) {
                    y = (int)((long)y - this.nside);
                    nbnum += 3;
                }
                short f = facearray[nbnum][face_num];
                if (f >= 0) {
                    byte bits = swaparray[nbnum][face_num >>> 2];
                    if ((bits & 1) > 0) {
                        x = (int)(this.nside - (long)x - 1L);
                    }
                    if ((bits & 2) > 0) {
                        y = (int)(this.nside - (long)y - 1L);
                    }
                    if ((bits & 4) > 0) {
                        int tint = x;
                        x = y;
                        y = tint;
                    }
                    result[i] = this.scheme == Scheme.NESTED ? this.xyf2nest(x, y, f) : this.xyf2ring(x, y, f);
                    continue;
                }
                result[i] = -1L;
            }
        }
        return result;
    }

    public double maxPixrad() {
        Vec3 va = new Vec3(new Zphi(0.6666666666666666, Math.PI / (double)this.nl4));
        double t1 = 1.0 - 1.0 / (double)this.nside;
        t1 *= t1;
        Vec3 vb = new Vec3(new Zphi(1.0 - t1 / 3.0, 0.0));
        return va.angle(vb);
    }

    private RingInfoSmall get_ring_info_small(long ring) {
        RingInfoSmall ret = new RingInfoSmall();
        if (ring < this.nside) {
            ret.shifted = true;
            ret.ringpix = 4L * ring;
            ret.startpix = 2L * ring * (ring - 1L);
        } else if (ring < this.nl3) {
            ret.shifted = (ring - this.nside & 1L) == 0L;
            ret.ringpix = this.nl4;
            ret.startpix = this.ncap + (ring - this.nside) * this.nl4;
        } else {
            ret.shifted = true;
            long nr = this.nl4 - ring;
            ret.ringpix = 4L * nr;
            ret.startpix = this.npix - 2L * nr * (nr + 1L);
        }
        return ret;
    }

    private long ringAbove(double z) {
        double az = Math.abs(z);
        if (az > 0.6666666666666666) {
            long iring = (long)((double)this.nside * Math.sqrt(3.0 * (1.0 - az)));
            return z > 0.0 ? iring : this.nl4 - iring - 1L;
        }
        return (long)((double)this.nside * (2.0 - 1.5 * z));
    }

    public double ring2z(long ring) {
        if (ring < this.nside) {
            return 1.0 - (double)(ring * ring) * this.fact2;
        }
        if (ring <= this.nl3) {
            return (double)(this.nl2 - ring) * this.fact1;
        }
        ring = this.nl4 - ring;
        return (double)(ring * ring) * this.fact2 - 1.0;
    }

    public double ring2theta(long ring) {
        if (ring < this.nside) {
            double tmp = (double)(ring * ring) * this.fact2;
            return FastMath.atan2(Math.sqrt(tmp * (2.0 - tmp)), 1.0 - tmp);
        }
        if (ring <= this.nl3) {
            double cth = (double)(this.nl2 - ring) * this.fact1;
            return FastMath.atan2(Math.sqrt(1.0 - cth * cth), cth);
        }
        ring = this.nl4 - ring;
        double tmp = (double)(ring * ring) * this.fact2;
        return FastMath.atan2(Math.sqrt(tmp * (2.0 - tmp)), tmp - 1.0);
    }

    private RangeSet queryStripInternal(double theta1, double theta2, boolean inclusive) throws Exception {
        RangeSet pixset = new RangeSet(1);
        if (this.scheme == Scheme.RING) {
            long ring1 = Math.max(1L, 1L + this.ringAbove(FastMath.cos(theta1)));
            long ring2 = Math.min(4L * this.nside - 1L, this.ringAbove(FastMath.cos(theta2)));
            if (inclusive) {
                ring1 = Math.max(1L, ring1 - 1L);
                ring2 = Math.min(4L * this.nside - 1L, ring2 + 1L);
            }
            RingInfoSmall ris1 = this.get_ring_info_small(ring1);
            RingInfoSmall ris2 = this.get_ring_info_small(ring2);
            long pix1 = ris1.startpix;
            long pix2 = ris2.startpix + ris2.ringpix;
            if (pix1 < pix2) {
                pixset.append(pix1, pix2);
            }
        } else {
            HealpixUtils.check(false, "queryStrip not yet implemented for NESTED");
        }
        return pixset;
    }

    public RangeSet queryStrip(double theta1, double theta2, boolean inclusive) throws Exception {
        if (theta1 < theta2) {
            return this.queryStripInternal(theta1, theta2, inclusive);
        }
        RangeSet res = this.queryStripInternal(0.0, theta2, inclusive);
        return res.union(this.queryStripInternal(theta1, Math.PI, inclusive));
    }

    private boolean checkPixelRing(HealpixBase b2, long pix, long nr, long ipix1, int fct, Zphi czphi, double cosrp2, long cpix) {
        if (pix >= nr) {
            pix -= nr;
        }
        if (pix < 0L) {
            pix += nr;
        }
        if ((pix += ipix1) == cpix) {
            return false;
        }
        Xyf xyf = this.pix2xyf(pix);
        for (int i = 0; i < fct - 1; ++i) {
            int ox = fct * xyf.ix;
            int oy = fct * xyf.iy;
            Xyf xyf2 = new Xyf(ox, oy, xyf.face);
            xyf2.ix = ox + i;
            xyf2.iy = oy;
            if (HealpixUtils.cosdist_zphi(czphi, b2.pix2zphi(b2.xyf2pix(xyf2))) > cosrp2) {
                return false;
            }
            xyf2.ix = ox + fct - 1;
            xyf2.iy = oy + i;
            if (HealpixUtils.cosdist_zphi(czphi, b2.pix2zphi(b2.xyf2pix(xyf2))) > cosrp2) {
                return false;
            }
            xyf2.ix = ox + fct - 1 - i;
            xyf2.iy = oy + fct - 1;
            if (HealpixUtils.cosdist_zphi(czphi, b2.pix2zphi(b2.xyf2pix(xyf2))) > cosrp2) {
                return false;
            }
            xyf2.ix = ox;
            xyf2.iy = oy + fct - 1 - i;
            if (!(HealpixUtils.cosdist_zphi(czphi, b2.pix2zphi(b2.xyf2pix(xyf2))) > cosrp2)) continue;
            return false;
        }
        return true;
    }

    private RangeSet queryDiscInternal(Pointing ptg, double radius, int fact) throws Exception {
        boolean inclusive = fact != 0;
        RangeSet pixset = new RangeSet();
        if (this.scheme == Scheme.RING) {
            double rbig;
            double rsmall;
            int fct = 1;
            if (inclusive) {
                HealpixUtils.check(0x20000000L / this.nside >= (long)fact, "invalid oversampling factor");
                fct = fact;
            }
            HealpixBase b2 = null;
            if (fct > 1) {
                b2 = new HealpixBase((long)fct * this.nside, Scheme.RING);
                rsmall = radius + b2.maxPixrad();
                rbig = radius + this.maxPixrad();
            } else {
                rbig = inclusive ? radius + this.maxPixrad() : radius;
                rsmall = rbig;
            }
            if (rsmall >= Math.PI) {
                pixset.append(0L, this.npix);
                return pixset;
            }
            rbig = Math.min(Math.PI, rbig);
            double cosrsmall = FastMath.cos(rsmall);
            double cosrbig = FastMath.cos(rbig);
            double z0 = FastMath.cos(ptg.theta);
            double xa = 1.0 / Math.sqrt((1.0 - z0) * (1.0 + z0));
            Zphi czphi = new Zphi(z0, ptg.phi);
            long cpix = this.zphi2pix(czphi);
            double rlat1 = ptg.theta - rsmall;
            double zmax = FastMath.cos(rlat1);
            long irmin = this.ringAbove(zmax) + 1L;
            if (rlat1 <= 0.0 && irmin > 1L) {
                RingInfoSmall info = this.get_ring_info_small(irmin - 1L);
                pixset.append(0L, info.startpix + info.ringpix);
            }
            if (fct > 1 && rlat1 > 0.0) {
                irmin = Math.max(1L, irmin - 1L);
            }
            double rlat2 = ptg.theta + rsmall;
            double zmin = FastMath.cos(rlat2);
            long irmax = this.ringAbove(zmin);
            if (fct > 1 && rlat2 < Math.PI) {
                irmax = Math.min(this.nl4 - 1L, irmax + 1L);
            }
            for (long iz = irmin; iz <= irmax; ++iz) {
                long ip_lo;
                double z = this.ring2z(iz);
                double x = (cosrbig - z * z0) * xa;
                double ysq = 1.0 - z * z - x * x;
                double dphi = -1.0;
                dphi = ysq <= 0.0 ? (fct == 1 ? 0.0 : 3.1415926535897922) : FastMath.atan2(Math.sqrt(ysq), x);
                if (!(dphi > 0.0)) continue;
                RingInfoSmall info = this.get_ring_info_small(iz);
                long ipix1 = info.startpix;
                long nr = info.ringpix;
                long ipix2 = ipix1 + nr - 1L;
                double shift = info.shifted ? 0.5 : 0.0;
                long ip_hi = (long)Math.floor((double)nr * 0.15915494309189535 * (ptg.phi + dphi) - shift);
                if (fct > 1) {
                    for (ip_lo = (long)Math.floor((double)nr * 0.15915494309189535 * (ptg.phi - dphi) - shift) + 1L; ip_lo <= ip_hi && this.checkPixelRing(b2, ip_lo, nr, ipix1, fct, czphi, cosrsmall, cpix); ++ip_lo) {
                    }
                    while (ip_hi > ip_lo && this.checkPixelRing(b2, ip_hi, nr, ipix1, fct, czphi, cosrsmall, cpix)) {
                        --ip_hi;
                    }
                }
                if (ip_lo > ip_hi) continue;
                if (ip_hi >= nr) {
                    ip_lo -= nr;
                    ip_hi -= nr;
                }
                if (ip_lo < 0L) {
                    pixset.append(ipix1, ipix1 + ip_hi + 1L);
                    pixset.append(ipix1 + ip_lo + nr, ipix2 + 1L);
                    continue;
                }
                pixset.append(ipix1 + ip_lo, ipix1 + ip_hi + 1L);
            }
            if (rlat2 >= Math.PI && irmax + 1L < this.nl4) {
                RingInfoSmall info = this.get_ring_info_small(irmax + 1L);
                pixset.append(info.startpix, this.npix);
            }
        } else {
            if (radius >= Math.PI) {
                pixset.append(0L, this.npix);
                return pixset;
            }
            int oplus = 0;
            if (inclusive) {
                HealpixUtils.check(0x20000000L >= (long)fact, "invalid oversampling factor");
                HealpixUtils.check((fact & fact - 1) == 0, "oversampling factor must be a power of 2");
                oplus = HealpixUtils.ilog2(fact);
            }
            int omax = Math.min(29, this.order + oplus);
            Vec3 vptg = new Vec3(ptg);
            double[] crpdr = new double[omax + 1];
            double[] crmdr = new double[omax + 1];
            double cosrad = FastMath.cos(radius);
            double sinrad = FastMath.sin(radius);
            for (int o = 0; o <= omax; ++o) {
                double dr = HealpixProc.mpr[o];
                double cdr = HealpixProc.cmpr[o];
                double sdr = HealpixProc.smpr[o];
                crpdr[o] = radius + dr > Math.PI ? -1.0 : cosrad * cdr - sinrad * sdr;
                crmdr[o] = radius - dr < 0.0 ? 1.0 : cosrad * cdr + sinrad * sdr;
            }
            pstack stk = new pstack(12 + 3 * omax);
            for (int i = 0; i < 12; ++i) {
                stk.push(11 - i, 0);
            }
            while (stk.size() > 0) {
                long pix = stk.ptop();
                int o = stk.otop();
                stk.pop();
                Zphi pos = HealpixProc.bn[o].pix2zphi(pix);
                double cangdist = HealpixUtils.cosdist_zphi(vptg.z, ptg.phi, pos.z, pos.phi);
                if (!(cangdist > crpdr[o])) continue;
                int zone = cangdist < cosrad ? 1 : (cangdist <= crmdr[o] ? 2 : 3);
                this.check_pixel(o, omax, zone, pixset, pix, stk, inclusive);
            }
        }
        return pixset;
    }

    public RangeSet queryDisc(Pointing ptg, double radius) throws Exception {
        return this.queryDiscInternal(ptg, radius, 0);
    }

    public RangeSet queryDiscInclusive(Pointing ptg, double radius, int fact) throws Exception {
        return this.queryDiscInternal(ptg, radius, fact);
    }

    private RangeSet queryMultiDisc(Vec3[] norm, double[] rad, int fact) throws Exception {
        boolean inclusive = fact != 0;
        int nv = norm.length;
        HealpixUtils.check(nv == rad.length, "inconsistent input arrays");
        RangeSet res = new RangeSet();
        if (this.scheme == Scheme.RING) {
            double rpbig;
            double rpsmall;
            int fct = 1;
            if (inclusive) {
                HealpixUtils.check(0x20000000L / this.nside >= (long)fact, "invalid oversampling factor");
                fct = fact;
            }
            HealpixBase b2 = null;
            if (fct > 1) {
                b2 = new HealpixBase((long)fct * this.nside, Scheme.RING);
                rpsmall = b2.maxPixrad();
                rpbig = this.maxPixrad();
            } else {
                rpbig = inclusive ? this.maxPixrad() : 0.0;
                rpsmall = rpbig;
            }
            long irmin = 1L;
            long irmax = this.nl4 - 1L;
            int nd = 0;
            double[] z0 = new double[nv];
            double[] xa = new double[nv];
            double[] cosrsmall = new double[nv];
            double[] cosrbig = new double[nv];
            Pointing[] ptg = new Pointing[nv];
            long[] cpix = new long[nv];
            Zphi[] czphi = new Zphi[nv];
            for (int i = 0; i < nv; ++i) {
                long irmax_t;
                long irmin_t;
                double cth;
                double rsmall = rad[i] + rpsmall;
                if (!(rsmall < Math.PI)) continue;
                double rbig = Math.min(Math.PI, rad[i] + rpbig);
                Pointing pnt = new Pointing(norm[i]);
                cosrsmall[nd] = FastMath.cos(rsmall);
                cosrbig[nd] = FastMath.cos(rbig);
                z0[nd] = cth = FastMath.cos(pnt.theta);
                if (fct > 1) {
                    cpix[nd] = this.zphi2pix(new Zphi(cth, pnt.phi));
                }
                if (fct > 1) {
                    czphi[nd] = new Zphi(cth, pnt.phi);
                }
                xa[nd] = 1.0 / Math.sqrt((1.0 - cth) * (1.0 + cth));
                ptg[nd] = pnt;
                double rlat1 = pnt.theta - rsmall;
                double zmax = FastMath.cos(rlat1);
                long l = irmin_t = rlat1 <= 0.0 ? 1L : this.ringAbove(zmax) + 1L;
                if (fct > 1 && rlat1 > 0.0) {
                    irmin_t = Math.max(1L, irmin_t - 1L);
                }
                double rlat2 = pnt.theta + rsmall;
                double zmin = FastMath.cos(rlat2);
                long l2 = irmax_t = rlat2 >= Math.PI ? this.nl4 - 1L : this.ringAbove(zmin);
                if (fct > 1 && rlat2 < Math.PI) {
                    irmax_t = Math.min(this.nl4 - 1L, irmax_t + 1L);
                }
                if (irmax_t < irmax) {
                    irmax = irmax_t;
                }
                if (irmin_t > irmin) {
                    irmin = irmin_t;
                }
                ++nd;
            }
            for (long iz = irmin; iz <= irmax; ++iz) {
                double z = this.ring2z(iz);
                RingInfoSmall ris = this.get_ring_info_small(iz);
                long ipix1 = ris.startpix;
                long nr = ris.ringpix;
                long ipix2 = ipix1 + nr - 1L;
                double shift = ris.shifted ? 0.5 : 0.0;
                RangeSet rstmp = new RangeSet();
                rstmp.append(ipix1, ipix2 + 1L);
                for (int j = 0; j < nd && rstmp.nranges() > 0; ++j) {
                    long ip_lo;
                    double x = (cosrbig[j] - z * z0[j]) * xa[j];
                    double ysq = 1.0 - z * z - x * x;
                    double dphi = ysq <= 0.0 ? 3.1415926535897922 : FastMath.atan2(Math.sqrt(ysq), x);
                    long ip_hi = (long)Math.floor((double)nr * 0.15915494309189535 * (ptg[j].phi + dphi) - shift);
                    if (fct > 1) {
                        for (ip_lo = (long)Math.floor((double)nr * 0.15915494309189535 * (ptg[j].phi - dphi) - shift) + 1L; ip_lo <= ip_hi && this.checkPixelRing(b2, ip_lo, nr, ipix1, fct, czphi[j], cosrsmall[j], cpix[j]); ++ip_lo) {
                        }
                        while (ip_hi > ip_lo && this.checkPixelRing(b2, ip_hi, nr, ipix1, fct, czphi[j], cosrsmall[j], cpix[j])) {
                            --ip_hi;
                        }
                    }
                    if (ip_hi >= nr) {
                        ip_lo -= nr;
                        ip_hi -= nr;
                    }
                    if (ip_lo < 0L) {
                        if (ip_hi + 1L > ip_lo + nr - 1L) continue;
                        rstmp.remove(ipix1 + ip_hi + 1L, ipix1 + ip_lo + nr);
                        continue;
                    }
                    rstmp.intersect(ipix1 + ip_lo, ipix1 + ip_hi + 1L);
                }
                res.append(rstmp);
            }
        } else {
            int oplus = 0;
            if (inclusive) {
                HealpixUtils.check(1L << 29 - this.order >= (long)fact, "invalid oversampling factor");
                HealpixUtils.check((fact & fact - 1) == 0, "oversampling factor must be a power of 2");
                oplus = HealpixUtils.ilog2(fact);
            }
            int omax = this.order + oplus;
            double[][][] crlimit = new double[omax + 1][nv][3];
            for (int o = 0; o <= omax; ++o) {
                double dr = HealpixProc.bn[o].maxPixrad();
                for (int i = 0; i < nv; ++i) {
                    crlimit[o][i][0] = rad[i] + dr > Math.PI ? -1.0 : FastMath.cos(rad[i] + dr);
                    crlimit[o][i][1] = o == 0 ? FastMath.cos(rad[i]) : crlimit[0][i][1];
                    crlimit[o][i][2] = rad[i] - dr < 0.0 ? 1.0 : FastMath.cos(rad[i] - dr);
                }
            }
            pstack stk = new pstack(12 + 3 * omax);
            for (int i = 0; i < 12; ++i) {
                stk.push(11 - i, 0);
            }
            while (stk.size() > 0) {
                long pix = stk.ptop();
                int o = stk.otop();
                stk.pop();
                Vec3 pv = HealpixProc.bn[o].pix2vec(pix);
                int zone = 3;
                for (int i = 0; i < nv && zone > 0; ++i) {
                    double crad = pv.dot(norm[i]);
                    for (int iz = 0; iz < zone; ++iz) {
                        if (!(crad < crlimit[o][i][iz])) continue;
                        zone = iz;
                    }
                }
                if (zone <= 0) continue;
                this.check_pixel(o, omax, zone, res, pix, stk, inclusive);
            }
        }
        return res;
    }

    private RangeSet queryPolygonInternal(Pointing[] vertex, int fact) throws Exception {
        boolean inclusive = fact != 0;
        int nv = vertex.length;
        int ncirc = inclusive ? nv + 1 : nv;
        HealpixUtils.check(nv >= 3, "not enough vertices in polygon");
        Vec3[] vv = new Vec3[nv];
        for (int i = 0; i < nv; ++i) {
            vv[i] = new Vec3(vertex[i]);
        }
        Vec3[] normal = new Vec3[ncirc];
        int flip = 0;
        for (int i = 0; i < nv; ++i) {
            normal[i] = vv[i].cross(vv[(i + 1) % nv]).norm();
            double hnd = normal[i].dot(vv[(i + 2) % nv]);
            HealpixUtils.check(Math.abs(hnd) > 1.0E-10, "degenerate corner");
            if (i == 0) {
                flip = hnd < 0.0 ? -1 : 1;
            } else {
                HealpixUtils.check((double)flip * hnd > 0.0, "polygon is not convex");
            }
            normal[i].scale(flip);
        }
        double[] rad = new double[ncirc];
        Arrays.fill(rad, 1.5707963267948966);
        if (inclusive) {
            CircleFinder cf = new CircleFinder(vv);
            normal[nv] = cf.getCenter();
            rad[nv] = FastMath.acos(cf.getCosrad());
        }
        return this.queryMultiDisc(normal, rad, fact);
    }

    public RangeSet queryPolygon(Pointing[] vertex) throws Exception {
        return this.queryPolygonInternal(vertex, 0);
    }

    public RangeSet queryPolygonInclusive(Pointing[] vertex, int fact) throws Exception {
        return this.queryPolygonInternal(vertex, fact);
    }

    private void check_pixel(int o, int omax, int zone, RangeSet pixset, long pix, pstack stk, boolean inclusive) {
        if (zone == 0) {
            return;
        }
        if (o < this.order) {
            if (zone >= 3) {
                int sdist = 2 * (this.order - o);
                pixset.append(pix << sdist, pix + 1L << sdist);
            } else {
                for (int i = 0; i < 4; ++i) {
                    stk.push(4L * pix + 3L - (long)i, o + 1);
                }
            }
        } else if (o > this.order) {
            if (zone >= 2) {
                pixset.append(pix >>> 2 * (o - this.order));
                stk.popToMark();
            } else if (o < omax) {
                for (int i = 0; i < 4; ++i) {
                    stk.push(4L * pix + 3L - (long)i, o + 1);
                }
            } else {
                pixset.append(pix >>> 2 * (o - this.order));
                stk.popToMark();
            }
        } else if (zone >= 2) {
            pixset.append(pix);
        } else if (inclusive) {
            if (this.order < omax) {
                stk.mark();
                for (int i = 0; i < 4; ++i) {
                    stk.push(4L * pix + 3L - (long)i, o + 1);
                }
            } else {
                pixset.append(pix);
            }
        }
    }

    public long pix2ring(long pix) {
        if (this.scheme == Scheme.RING) {
            if (pix < this.ncap) {
                return 1 + HealpixUtils.isqrt(1L + 2L * pix) >>> 1;
            }
            if (pix < this.npix - this.ncap) {
                return (pix - this.ncap) / this.nl4 + this.nside;
            }
            return this.nl4 - (long)(1 + HealpixUtils.isqrt(2L * (this.npix - pix) - 1L) >>> 1);
        }
        Xyf xyf = this.nest2xyf(pix);
        return ((long)jrll[xyf.face] << this.order) - (long)xyf.ix - (long)xyf.iy - 1L;
    }

    public Vec3[] boundaries(long pix, int step) throws Exception {
        HealpixUtils.check(step > 0, "step must be positive");
        Vec3[] points = new Vec3[4 * step];
        Xyf xyf = this.pix2xyf(pix);
        double dc = 0.5 / (double)this.nside;
        double xc = ((double)xyf.ix + 0.5) / (double)this.nside;
        double yc = ((double)xyf.iy + 0.5) / (double)this.nside;
        double d = 1.0 / (double)((long)step * this.nside);
        for (int i = 0; i < step; ++i) {
            points[i] = new Fxyf(xc + dc - (double)i * d, yc + dc, xyf.face).toVec3();
            points[i + step] = new Fxyf(xc - dc, yc + dc - (double)i * d, xyf.face).toVec3();
            points[i + 2 * step] = new Fxyf(xc - dc + (double)i * d, yc - dc, xyf.face).toVec3();
            points[i + 3 * step] = new Fxyf(xc + dc, yc - dc + (double)i * d, xyf.face).toVec3();
        }
        return points;
    }

    private final class pstack {
        private long[] p;
        private int[] o;
        private int s;
        private int m;

        public pstack(int sz) {
            this.p = new long[sz];
            this.o = new int[sz];
            this.m = 0;
            this.s = 0;
        }

        public void push(long p_, int o_) {
            this.p[this.s] = p_;
            this.o[this.s] = o_;
            ++this.s;
        }

        public void pop() {
            --this.s;
        }

        public void popToMark() {
            this.s = this.m;
        }

        public int size() {
            return this.s;
        }

        public void mark() {
            this.m = this.s;
        }

        public int otop() {
            return this.o[this.s - 1];
        }

        public long ptop() {
            return this.p[this.s - 1];
        }
    }

    private final class RingInfoSmall {
        long startpix;
        long ringpix;
        boolean shifted;

        private RingInfoSmall() {
        }
    }

    protected final class Xyf {
        public int ix;
        public int iy;
        public int face;

        public Xyf() {
        }

        public Xyf(int x, int y, int f) {
            this.ix = x;
            this.iy = y;
            this.face = f;
        }
    }
}

