/*
 * Decompiled with CFR 0.152.
 */
package healpix.essentials;

import healpix.essentials.Compressor;
import healpix.essentials.HealpixUtils;
import java.util.NoSuchElementException;

public class RangeSet {
    private static final ValueIterator EMPTY_ITER = new ValueIterator(){

        @Override
        public boolean hasNext() {
            return false;
        }

        @Override
        public long next() {
            throw new NoSuchElementException();
        }
    };
    protected long[] r;
    protected int sz;

    public RangeSet() {
        this(4);
    }

    public RangeSet(int cap) {
        if (cap < 0) {
            throw new IllegalArgumentException("capacity must be positive");
        }
        this.r = new long[cap << 1];
        this.sz = 0;
    }

    public RangeSet(long[] data) {
        this.sz = data.length;
        this.r = new long[this.sz];
        System.arraycopy(data, 0, this.r, 0, this.sz);
        this.checkConsistency();
    }

    public RangeSet(RangeSet other) {
        this.sz = other.sz;
        this.r = new long[this.sz];
        System.arraycopy(other.r, 0, this.r, 0, this.sz);
    }

    public void checkConsistency() {
        if ((this.sz & 1) != 0) {
            throw new IllegalArgumentException("invalid number of entries");
        }
        for (int i = 1; i < this.sz; ++i) {
            if (this.r[i] > this.r[i - 1]) continue;
            throw new IllegalArgumentException("inconsistent entries");
        }
    }

    private void resize(int newsize) {
        if (newsize < this.sz) {
            throw new IllegalArgumentException("requested array size too small");
        }
        if (newsize == this.r.length) {
            return;
        }
        long[] rnew = new long[newsize];
        System.arraycopy(this.r, 0, rnew, 0, this.sz);
        this.r = rnew;
    }

    public void ensureCapacity(int cap) {
        if (this.r.length < cap) {
            this.resize(Math.max(2 * this.r.length, cap));
        }
    }

    public void trimSize() {
        this.resize(this.sz);
    }

    public void trimIfTooLarge() {
        if (this.r.length - this.sz >= this.sz) {
            this.resize(this.sz);
        }
    }

    private int iiv(long val) {
        int count = this.sz;
        int first = 0;
        while (count > 0) {
            int step = count >>> 1;
            int it = first + step;
            if (this.r[it] <= val) {
                first = ++it;
                count -= step + 1;
                continue;
            }
            count = step;
        }
        return first - 1;
    }

    public void append(long val) {
        this.append(val, val + 1L);
    }

    public void append(long a, long b) {
        if (a >= b) {
            return;
        }
        if (this.sz > 0 && a <= this.r[this.sz - 1]) {
            if (a < this.r[this.sz - 2]) {
                throw new IllegalArgumentException("bad append operation");
            }
            if (b > this.r[this.sz - 1]) {
                this.r[this.sz - 1] = b;
            }
            return;
        }
        this.ensureCapacity(this.sz + 2);
        this.r[this.sz] = a;
        this.r[this.sz + 1] = b;
        this.sz += 2;
    }

    public void append(RangeSet other) {
        for (int i = 0; i < other.sz; i += 2) {
            this.append(other.r[i], other.r[i + 1]);
        }
    }

    public int nranges() {
        return this.sz >>> 1;
    }

    public boolean isEmpty() {
        return this.sz == 0;
    }

    public long ivbegin(int iv) {
        return this.r[2 * iv];
    }

    public long ivend(int iv) {
        return this.r[2 * iv + 1];
    }

    public void clear() {
        this.sz = 0;
    }

    private void pushv(long v) {
        this.ensureCapacity(this.sz + 1);
        this.r[this.sz++] = v;
    }

    private static int strategy(int sza, int szb) {
        int shi;
        double fct1 = 1.0;
        double fct2 = 1.0;
        double cost1 = 1.0 * (double)(sza + szb);
        int slo = sza < szb ? sza : szb;
        double cost2 = 1.0 * (double)slo * Math.max(1.0, (double)HealpixUtils.ilog2(shi = sza < szb ? szb : sza));
        return cost1 <= cost2 ? 1 : (slo == sza ? 2 : 3);
    }

    private static boolean generalAllOrNothing1(RangeSet a, RangeSet b, boolean flip_a, boolean flip_b) {
        boolean runb;
        boolean state_a = flip_a;
        boolean state_b = flip_b;
        boolean state_res = state_a || state_b;
        int ia = 0;
        int ea = a.sz;
        int ib = 0;
        int eb = b.sz;
        boolean runa = ia != ea;
        boolean bl = runb = ib != eb;
        while (runa || runb) {
            boolean adv_b;
            long va = runa ? a.r[ia] : 0L;
            long vb = runb ? b.r[ib] : 0L;
            boolean adv_a = runa && (!runb || va <= vb);
            boolean bl2 = adv_b = runb && (!runa || vb <= va);
            if (adv_a) {
                state_a = !state_a;
                boolean bl3 = runa = ++ia != ea;
            }
            if (adv_b) {
                state_b = !state_b;
                runb = ++ib != eb;
            }
            if ((state_a || state_b) == state_res) continue;
            return false;
        }
        return true;
    }

    private static boolean generalAllOrNothing2(RangeSet a, RangeSet b, boolean flip_a, boolean flip_b) {
        int iva;
        int n = iva = flip_a ? 0 : -1;
        while (iva < a.sz) {
            if (iva == -1) {
                if (!flip_b || b.r[0] < a.r[0]) {
                    return false;
                }
            } else if (iva == a.sz - 1) {
                if (!flip_b || b.r[b.sz - 1] > a.r[a.sz - 1]) {
                    return false;
                }
            } else {
                int ivb = b.iiv(a.r[iva]);
                if (ivb != b.sz - 1 && b.r[ivb + 1] < a.r[iva + 1]) {
                    return false;
                }
                if (flip_b == ((ivb & 1) == 0)) {
                    return false;
                }
            }
            iva += 2;
        }
        return true;
    }

    private static boolean generalAllOrNothing(RangeSet a, RangeSet b, boolean flip_a, boolean flip_b) {
        if (a.isEmpty()) {
            return flip_a ? true : b.isEmpty();
        }
        if (b.isEmpty()) {
            return flip_b ? true : a.isEmpty();
        }
        int strat = RangeSet.strategy(a.nranges(), b.nranges());
        return strat == 1 ? RangeSet.generalAllOrNothing1(a, b, flip_a, flip_b) : (strat == 2 ? RangeSet.generalAllOrNothing2(a, b, flip_a, flip_b) : RangeSet.generalAllOrNothing2(b, a, flip_b, flip_a));
    }

    private static RangeSet generalUnion1(RangeSet a, RangeSet b, boolean flip_a, boolean flip_b) {
        boolean runb;
        RangeSet res = new RangeSet();
        boolean state_a = flip_a;
        boolean state_b = flip_b;
        boolean state_res = state_a || state_b;
        int ia = 0;
        int ea = a.sz;
        int ib = 0;
        int eb = b.sz;
        boolean runa = ia != ea;
        boolean bl = runb = ib != eb;
        while (runa || runb) {
            boolean adv_b;
            long va = runa ? a.r[ia] : 0L;
            long vb = runb ? b.r[ib] : 0L;
            boolean adv_a = runa && (!runb || va <= vb);
            boolean bl2 = adv_b = runb && (!runa || vb <= va);
            if (adv_a) {
                state_a = !state_a;
                boolean bl3 = runa = ++ia != ea;
            }
            if (adv_b) {
                state_b = !state_b;
                runb = ++ib != eb;
            }
            if ((state_a || state_b) == state_res) continue;
            res.pushv(adv_a ? va : vb);
            state_res = !state_res;
        }
        return res;
    }

    private static RangeSet generalUnion2(RangeSet a, RangeSet b, boolean flip_a, boolean flip_b) {
        int iva;
        RangeSet res = new RangeSet();
        int n = iva = flip_a ? 0 : -1;
        while (iva < a.sz) {
            int ivb = iva == -1 ? -1 : b.iiv(a.r[iva]);
            boolean state_b = flip_b ^ (ivb & 1) == 0;
            if (iva > -1 && !state_b) {
                res.pushv(a.r[iva]);
            }
            while (ivb < b.sz - 1 && (iva == a.sz - 1 || b.r[ivb + 1] < a.r[iva + 1])) {
                state_b = !state_b;
                res.pushv(b.r[++ivb]);
            }
            if (iva < a.sz - 1 && !state_b) {
                res.pushv(a.r[iva + 1]);
            }
            iva += 2;
        }
        return res;
    }

    private static RangeSet generalUnion(RangeSet a, RangeSet b, boolean flip_a, boolean flip_b) {
        if (a.isEmpty()) {
            return flip_a ? new RangeSet() : new RangeSet(b);
        }
        if (b.isEmpty()) {
            return flip_b ? new RangeSet() : new RangeSet(a);
        }
        int strat = RangeSet.strategy(a.nranges(), b.nranges());
        return strat == 1 ? RangeSet.generalUnion1(a, b, flip_a, flip_b) : (strat == 2 ? RangeSet.generalUnion2(a, b, flip_a, flip_b) : RangeSet.generalUnion2(b, a, flip_b, flip_a));
    }

    public RangeSet union(RangeSet other) {
        return RangeSet.generalUnion(this, other, false, false);
    }

    public RangeSet intersection(RangeSet other) {
        return RangeSet.generalUnion(this, other, true, true);
    }

    public RangeSet difference(RangeSet other) {
        return RangeSet.generalUnion(this, other, true, false);
    }

    public boolean contains(long a) {
        return (this.iiv(a) & 1) == 0;
    }

    public boolean contains(long a, long b) {
        int res = this.iiv(a);
        if ((res & 1) != 0) {
            return false;
        }
        return b <= this.r[res + 1];
    }

    @Deprecated
    public boolean containsAll(long a, long b) {
        return this.contains(a, b);
    }

    public boolean overlaps(long a, long b) {
        int res = this.iiv(a);
        if ((res & 1) == 0) {
            return true;
        }
        if (res == this.sz - 1) {
            return false;
        }
        return this.r[res + 1] < b;
    }

    @Deprecated
    public boolean containsAny(long a, long b) {
        return this.overlaps(a, b);
    }

    public boolean contains(RangeSet other) {
        return RangeSet.generalAllOrNothing(this, other, false, true);
    }

    @Deprecated
    public boolean containsAll(RangeSet other) {
        return this.contains(other);
    }

    public boolean overlaps(RangeSet other) {
        return !RangeSet.generalAllOrNothing(this, other, true, true);
    }

    @Deprecated
    public boolean containsAny(RangeSet other) {
        return this.overlaps(other);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !(obj instanceof RangeSet)) {
            return false;
        }
        RangeSet other = (RangeSet)obj;
        if (other.sz != this.sz) {
            return false;
        }
        for (int i = 0; i < this.sz; ++i) {
            if (other.r[i] == this.r[i]) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int result = Integer.valueOf(this.sz).hashCode();
        for (int i = 0; i < this.sz; ++i) {
            result = 31 * result + Long.valueOf(this.r[this.sz]).hashCode();
        }
        return result;
    }

    public long nval() {
        long res = 0L;
        for (int i = 0; i < this.sz; i += 2) {
            res += this.r[i + 1] - this.r[i];
        }
        return res;
    }

    private void addRemove(long a, long b, int v) {
        boolean insert_a;
        int rmstart;
        boolean insert_b;
        int rmend;
        int pos1 = this.iiv(a);
        int pos2 = this.iiv(b);
        if (pos1 >= 0 && this.r[pos1] == a) {
            --pos1;
        }
        if (((rmend = pos2 - ((insert_b = (pos2 & 1) == v) ? 1 : 0)) - (rmstart = pos1 + 1 + ((insert_a = (pos1 & 1) == v) ? 1 : 0)) & 1) == 0) {
            throw new IllegalArgumentException("cannot happen: " + rmstart + " " + rmend);
        }
        if (insert_a && insert_b && pos1 + 1 > pos2) {
            this.ensureCapacity(this.sz + 2);
            System.arraycopy(this.r, pos1 + 1, this.r, pos1 + 3, this.sz - pos1 - 1);
            this.r[pos1 + 1] = a;
            this.r[pos1 + 2] = b;
            this.sz += 2;
        } else {
            if (insert_a) {
                this.r[pos1 + 1] = a;
            }
            if (insert_b) {
                this.r[pos2] = b;
            }
            if (rmstart != rmend + 1) {
                System.arraycopy(this.r, rmend + 1, this.r, rmstart, this.sz - rmend - 1);
            }
            this.sz -= rmend - rmstart + 1;
        }
    }

    public void intersect(long a, long b) {
        int pos1 = this.iiv(a);
        int pos2 = this.iiv(b);
        if (pos2 >= 0 && this.r[pos2] == b) {
            --pos2;
        }
        boolean insert_a = (pos1 & 1) == 0;
        boolean insert_b = (pos2 & 1) == 0;
        this.sz = pos2 + 1;
        if (insert_b) {
            this.r[this.sz++] = b;
        }
        if (insert_a) {
            this.r[pos1--] = a;
        }
        if (pos1 >= 0) {
            System.arraycopy(this.r, pos1 + 1, this.r, 0, this.sz - pos1 - 1);
        }
        this.sz -= pos1 + 1;
        if ((this.sz & 1) != 0) {
            throw new IllegalArgumentException("cannot happen");
        }
    }

    public void add(long a, long b) {
        if (this.sz == 0 || a >= this.r[this.sz - 1]) {
            this.append(a, b);
        } else {
            this.addRemove(a, b, 1);
        }
    }

    public void add(long a) {
        if (this.sz == 0 || a >= this.r[this.sz - 1]) {
            this.append(a, a + 1L);
        } else {
            this.addRemove(a, a + 1L, 1);
        }
    }

    public void remove(long a, long b) {
        this.addRemove(a, b, 0);
    }

    public void remove(long a) {
        this.addRemove(a, a + 1L, 0);
    }

    public long[] toArray() {
        long[] res = new long[(int)this.nval()];
        int ofs = 0;
        for (int i = 0; i < this.sz; i += 2) {
            long j = this.r[i];
            while (j < this.r[i + 1]) {
                res[ofs++] = j++;
            }
        }
        return res;
    }

    public static RangeSet fromArray(long[] v) {
        RangeSet res = new RangeSet();
        for (int i = 0; i < v.length; ++i) {
            res.append(v[i]);
        }
        return res;
    }

    public String toString() {
        StringBuilder s = new StringBuilder();
        s.append("{ ");
        for (int i = 0; i < this.sz; i += 2) {
            s.append("[").append(this.r[i]).append(";").append(this.r[i + 1]).append("[");
            if (i >= this.sz - 2) continue;
            s.append(",");
        }
        s.append(" }");
        return s.toString();
    }

    public ValueIterator valueIterator() {
        if (this.sz == 0) {
            return EMPTY_ITER;
        }
        return new ValueIterator(){
            int pos = 0;
            long value;
            {
                this.value = RangeSet.this.sz > 0 ? RangeSet.this.r[0] : 0L;
            }

            @Override
            public boolean hasNext() {
                return this.pos < RangeSet.this.sz;
            }

            @Override
            public long next() {
                if (this.pos > RangeSet.this.sz) {
                    throw new NoSuchElementException();
                }
                long ret = this.value++;
                if (this.value == RangeSet.this.r[this.pos + 1]) {
                    this.pos += 2;
                    if (this.pos < RangeSet.this.sz) {
                        this.value = RangeSet.this.r[this.pos];
                    }
                }
                return ret;
            }
        };
    }

    public byte[] toCompressed() throws Exception {
        return Compressor.interpol_encode(this.r, 0, this.sz);
    }

    public static RangeSet fromCompressed(byte[] data) throws Exception {
        return new RangeSet(Compressor.interpol_decode(data));
    }

    public static interface ValueIterator {
        public boolean hasNext();

        public long next();
    }
}

