/*
 * Decompiled with CFR 0.152.
 */
package healpix.essentials;

import healpix.essentials.HealpixTables;
import healpix.essentials.HealpixUtils;
import healpix.essentials.Hploc;
import healpix.essentials.Vec3;

public final class Fxyf
extends HealpixTables {
    public double fx;
    public double fy;
    public int face;

    public Fxyf(double x, double y, int f) {
        this.fx = x;
        this.fy = y;
        this.face = f;
    }

    protected Fxyf(Hploc loc) {
        double z = loc.z;
        double phi = loc.phi;
        double za = Math.abs(z);
        double tt = HealpixUtils.fmodulo(phi * 0.6366197723675814, 4.0);
        if (za <= 0.6666666666666666) {
            double temp1 = 0.5 + tt;
            double temp2 = z * 0.75;
            double jp = temp1 - temp2;
            long ifp = (long)jp;
            double jm = temp1 + temp2;
            long ifm = (long)jm;
            long face_num = ifp == ifm ? ifp | 4L : (ifp < ifm ? ifp : ifm + 8L);
            this.fx = HealpixUtils.fmodulo(jm, 1.0);
            this.fy = 1.0 - HealpixUtils.fmodulo(jp, 1.0);
            this.face = (int)face_num;
        } else {
            int ntt = Math.min(3, (int)tt);
            double tp = tt - (double)ntt;
            double tmp = za < 0.99 || !loc.have_sth ? Math.sqrt(3.0 * (1.0 - za)) : loc.sth / Math.sqrt((1.0 + za) / 3.0);
            double jp = tp * tmp;
            double jm = (1.0 - tp) * tmp;
            if (jp >= 1.0) {
                jp = 1.0;
            }
            if (jm >= 1.0) {
                jm = 1.0;
            }
            if (z >= 0.0) {
                this.fx = 1.0 - jm;
                this.fy = 1.0 - jp;
                this.face = ntt;
            } else {
                this.fx = jp;
                this.fy = jm;
                this.face = ntt + 8;
            }
        }
    }

    public Fxyf(Vec3 v) {
        this(new Hploc(v));
    }

    protected Hploc toHploc() {
        double tmp;
        double nr;
        Hploc loc = new Hploc();
        double jr = (double)jrll[this.face] - this.fx - this.fy;
        if (jr < 1.0) {
            nr = jr;
            tmp = nr * nr / 3.0;
            loc.z = 1.0 - tmp;
            if (loc.z > 0.99) {
                loc.sth = Math.sqrt(tmp * (2.0 - tmp));
                loc.have_sth = true;
            }
        } else if (jr > 3.0) {
            nr = 4.0 - jr;
            tmp = nr * nr / 3.0;
            loc.z = tmp - 1.0;
            if (loc.z < -0.99) {
                loc.sth = Math.sqrt(tmp * (2.0 - tmp));
                loc.have_sth = true;
            }
        } else {
            nr = 1.0;
            loc.z = (2.0 - jr) * 2.0 / 3.0;
        }
        tmp = (double)jpll[this.face] * nr + this.fx - this.fy;
        if (tmp < 0.0) {
            tmp += 8.0;
        }
        if (tmp >= 8.0) {
            tmp -= 8.0;
        }
        loc.phi = nr < 1.0E-15 ? 0.0 : 0.7853981633974483 * tmp / nr;
        return loc;
    }

    public Vec3 toVec3() {
        return this.toHploc().toVec3();
    }
}

