/*
 * Decompiled with CFR 0.152.
 */
package healpix.essentials;

import healpix.essentials.HealpixUtils;
import healpix.essentials.RangeSet;

public class Moc {
    private static final int maxorder = 29;
    private RangeSet rs;

    public Moc() {
        this.rs = new RangeSet();
    }

    public Moc(Moc other) {
        this.rs = new RangeSet(other.rs);
    }

    public Moc(RangeSet rs2, int order) {
        this.rs = new RangeSet(rs2.nranges());
        int shift = 2 * (29 - order);
        for (int i = 0; i < rs2.nranges(); ++i) {
            this.rs.append(rs2.ivbegin(i) << shift, rs2.ivend(i) << shift);
        }
    }

    private static Moc fromNewRangeSet(RangeSet rngset) {
        Moc res = new Moc();
        res.rs = rngset;
        return res;
    }

    public RangeSet getRangeSet() {
        return new RangeSet(this.rs);
    }

    public int maxOrder() {
        long combo = 0L;
        for (int i = 0; i < this.rs.nranges(); ++i) {
            combo |= this.rs.ivbegin(i) | this.rs.ivend(i);
        }
        return 29 - (Long.numberOfTrailingZeros(combo) >>> 1);
    }

    public Moc degradedToOrder(int order, boolean keepPartialCells) {
        int shift = 2 * (29 - order);
        long ofs = (1L << shift) - 1L;
        long mask = ofs ^ 0xFFFFFFFFFFFFFFFFL;
        long adda = keepPartialCells ? 0L : ofs;
        long addb = keepPartialCells ? ofs : 0L;
        RangeSet rs2 = new RangeSet();
        for (int i = 0; i < this.rs.nranges(); ++i) {
            long a = this.rs.ivbegin(i) + adda & mask;
            long b = this.rs.ivend(i) + addb & mask;
            if (b <= a) continue;
            rs2.append(a, b);
        }
        return Moc.fromNewRangeSet(rs2);
    }

    public void addPixelRange(int order, long p1, long p2) {
        int shift = 2 * (29 - order);
        this.rs.add(p1 << shift, p2 << shift);
    }

    public void addPixel(int order, long p) {
        this.addPixelRange(order, p, p + 1L);
    }

    public Moc union(Moc other) {
        return Moc.fromNewRangeSet(this.rs.union(other.rs));
    }

    public Moc intersection(Moc other) {
        return Moc.fromNewRangeSet(this.rs.intersection(other.rs));
    }

    public Moc subtraction(Moc other) {
        return Moc.fromNewRangeSet(this.rs.difference(other.rs));
    }

    public Moc complement() {
        RangeSet full = new RangeSet(new long[]{0L, 0x3000000000000000L});
        return Moc.fromNewRangeSet(full.difference(this.rs));
    }

    public boolean contains(Moc other) {
        return this.rs.contains(other.rs);
    }

    public boolean overlaps(Moc other) {
        return this.rs.overlaps(other.rs);
    }

    public RangeSet toUniqRS() {
        RangeSet r2 = new RangeSet(this.rs);
        RangeSet r3 = new RangeSet();
        RangeSet res = new RangeSet();
        for (int o = 0; o <= 29; ++o) {
            if (r2.isEmpty()) {
                return res;
            }
            int shift = 2 * (29 - o);
            long ofs = (1L << shift) - 1L;
            long ofs2 = 1L << 2 * o + 2;
            r3.clear();
            for (int iv = 0; iv < r2.nranges(); ++iv) {
                long a = r2.ivbegin(iv) + ofs >>> shift;
                long b = r2.ivend(iv) >>> shift;
                r3.append(a << shift, b << shift);
                res.append(a + ofs2, b + ofs2);
            }
            if (r3.isEmpty()) continue;
            r2 = r2.difference(r3);
        }
        return res;
    }

    public long[] toUniq() {
        return this.toUniqRS().toArray();
    }

    public static Moc fromUniqRS(RangeSet ru) {
        RangeSet r = new RangeSet();
        RangeSet rtmp = new RangeSet();
        int lastorder = 0;
        int shift = 58;
        for (int i = 0; i < ru.nranges(); ++i) {
            for (long j = ru.ivbegin(i); j < ru.ivend(i); ++j) {
                int order = HealpixUtils.uniq2order(j);
                if (order != lastorder) {
                    r = r.union(rtmp);
                    rtmp.clear();
                    lastorder = order;
                    shift = 2 * (29 - order);
                }
                long pix = j - (1L << 2 * order + 2);
                rtmp.append(pix << shift, pix + 1L << shift);
            }
        }
        r = r.union(rtmp);
        return Moc.fromNewRangeSet(r);
    }

    public static Moc fromUniq(long[] u) {
        return Moc.fromUniqRS(RangeSet.fromArray(u));
    }

    public byte[] toCompressed() throws Exception {
        return this.rs.toCompressed();
    }

    public static Moc fromCompressed(byte[] data) throws Exception {
        return Moc.fromNewRangeSet(RangeSet.fromCompressed(data));
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !(obj instanceof Moc)) {
            return false;
        }
        Moc other = (Moc)obj;
        return this.rs.equals(other.rs);
    }

    public int hashCode() {
        return this.rs.hashCode();
    }

    public int nranges() {
        return this.rs.nranges();
    }
}

