/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.distribution.ch;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.infinispan.distribution.ch.AbstractConsistentHash;
import org.infinispan.remoting.transport.Address;
import org.infinispan.util.Util;
import org.infinispan.util.hash.Hash;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public abstract class AbstractWheelConsistentHash
extends AbstractConsistentHash {
    private static Log log = LogFactory.getLog(AbstractWheelConsistentHash.class);
    protected ArrayList<Address> addresses;
    protected SortedMap<Integer, Address> positions;
    protected Map<Address, Integer> addressToHashIds;
    protected Hash hashFunction;
    static final int HASH_SPACE = 10240;

    public void setHashFunction(Hash h) {
        this.hashFunction = h;
    }

    @Override
    public void setCaches(List<Address> caches) {
        super.setCaches(caches);
        this.addresses = new ArrayList<Address>(caches);
        this.addresses.trimToSize();
        this.positions = new TreeMap<Integer, Address>();
        this.addressToHashIds = new HashMap<Address, Integer>();
        for (Address a : this.addresses) {
            int positionIndex = Math.abs(this.hashFunction.hash(a)) % 10240;
            while (this.positions.containsKey(positionIndex)) {
                ++positionIndex;
            }
            this.positions.put(positionIndex, a);
            if (this.addressToHashIds.containsKey(a)) continue;
            this.addressToHashIds.put(a, positionIndex);
        }
        this.addresses.clear();
        for (Address a : this.positions.values()) {
            this.addresses.add(a);
        }
        if (log.isTraceEnabled()) {
            log.trace("Position are: " + this.positions);
        }
    }

    @Override
    public List<Address> getBackupsForNode(Address node, int replCount) {
        return this.locate(node, replCount);
    }

    @Override
    public List<Address> getCaches() {
        return this.addresses;
    }

    @Override
    public int getHashSpace() {
        return 10240;
    }

    @Override
    public int getHashId(Address a) {
        Integer hashId = this.addressToHashIds.get(a);
        if (hashId == null) {
            return -1;
        }
        return hashId;
    }

    protected int getNormalizedHash(Object key) {
        int keyHashCode = this.hashFunction.hash(key);
        if (keyHashCode == Integer.MIN_VALUE) {
            ++keyHashCode;
        }
        return Math.abs(keyHashCode) % 10240;
    }

    @Override
    public String toString() {
        return "AbstractWheelConsistentHash{addresses=" + this.addresses + ", positions=" + this.positions + ", addressToHashIds=" + this.addressToHashIds + "} " + super.toString();
    }

    protected static abstract class Externalizer
    implements org.infinispan.marshall.Externalizer {
        protected Externalizer() {
        }

        @Override
        public void writeObject(ObjectOutput output, Object subject) throws IOException {
            AbstractWheelConsistentHash consistentHash = (AbstractWheelConsistentHash)subject;
            output.writeObject(consistentHash.hashFunction.getClass().getName());
            output.writeObject(consistentHash.addresses);
            output.writeObject(consistentHash.positions);
            output.writeObject(consistentHash.addressToHashIds);
        }

        protected abstract AbstractWheelConsistentHash instance();

        @Override
        public Object readObject(ObjectInput unmarshaller) throws IOException, ClassNotFoundException {
            AbstractWheelConsistentHash consistentHash = this.instance();
            String hashFunctionName = (String)unmarshaller.readObject();
            consistentHash.hashFunction = (Hash)Util.getInstance(hashFunctionName);
            consistentHash.addresses = (ArrayList)unmarshaller.readObject();
            consistentHash.positions = (SortedMap)unmarshaller.readObject();
            consistentHash.addressToHashIds = (Map)unmarshaller.readObject();
            return consistentHash;
        }
    }
}

