/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.interceptors;

import java.util.HashMap;
import java.util.Map;
import org.infinispan.commands.AbstractVisitor;
import org.infinispan.commands.CommandsFactory;
import org.infinispan.commands.VisitableCommand;
import org.infinispan.commands.tx.CommitCommand;
import org.infinispan.commands.tx.PrepareCommand;
import org.infinispan.commands.tx.RollbackCommand;
import org.infinispan.commands.write.ClearCommand;
import org.infinispan.commands.write.DataWriteCommand;
import org.infinispan.commands.write.PutKeyValueCommand;
import org.infinispan.commands.write.PutMapCommand;
import org.infinispan.commands.write.RemoveCommand;
import org.infinispan.commands.write.ReplaceCommand;
import org.infinispan.context.InvocationContext;
import org.infinispan.context.impl.TxInvocationContext;
import org.infinispan.distribution.DistributionManager;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.interceptors.TxInterceptor;

public class DistTxInterceptor
extends TxInterceptor {
    DistributionManager dm;
    ReplayCommandVisitor replayCommandVisitor = new ReplayCommandVisitor();
    private CommandsFactory commandsFactory;

    @Inject
    public void injectDistributionManager(DistributionManager dm, CommandsFactory commandsFactory) {
        this.dm = dm;
        this.commandsFactory = commandsFactory;
    }

    @Override
    protected VisitableCommand getCommandToReplay(VisitableCommand command) {
        try {
            return (VisitableCommand)command.acceptVisitor(null, this.replayCommandVisitor);
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Throwable th) {
            throw new RuntimeException(th);
        }
    }

    @Override
    public Object visitPrepareCommand(TxInvocationContext ctx, PrepareCommand cmd) throws Throwable {
        this.dm.getTransactionLogger().logIfNeeded(cmd);
        return super.visitPrepareCommand(ctx, cmd);
    }

    @Override
    public Object visitRollbackCommand(TxInvocationContext ctx, RollbackCommand cmd) throws Throwable {
        this.dm.getTransactionLogger().logIfNeeded(cmd);
        return super.visitRollbackCommand(ctx, cmd);
    }

    @Override
    public Object visitCommitCommand(TxInvocationContext ctx, CommitCommand cmd) throws Throwable {
        this.dm.getTransactionLogger().logIfNeeded(cmd);
        return super.visitCommitCommand(ctx, cmd);
    }

    @Override
    public Object visitPutKeyValueCommand(InvocationContext ctx, PutKeyValueCommand command) throws Throwable {
        Object o = super.visitPutKeyValueCommand(ctx, command);
        if (!ctx.isInTxScope() && command.isSuccessful()) {
            this.dm.getTransactionLogger().logIfNeeded(command);
        }
        return o;
    }

    @Override
    public Object visitRemoveCommand(InvocationContext ctx, RemoveCommand command) throws Throwable {
        Object o = super.visitRemoveCommand(ctx, command);
        if (!ctx.isInTxScope() && command.isSuccessful()) {
            this.dm.getTransactionLogger().logIfNeeded(command);
        }
        return o;
    }

    @Override
    public Object visitReplaceCommand(InvocationContext ctx, ReplaceCommand command) throws Throwable {
        Object o = super.visitReplaceCommand(ctx, command);
        if (!ctx.isInTxScope() && command.isSuccessful()) {
            this.dm.getTransactionLogger().logIfNeeded(command);
        }
        return o;
    }

    @Override
    public Object visitClearCommand(InvocationContext ctx, ClearCommand command) throws Throwable {
        Object o = super.visitClearCommand(ctx, command);
        if (!ctx.isInTxScope() && command.isSuccessful()) {
            this.dm.getTransactionLogger().logIfNeeded(command);
        }
        return o;
    }

    @Override
    public Object visitPutMapCommand(InvocationContext ctx, PutMapCommand command) throws Throwable {
        Object o = super.visitPutMapCommand(ctx, command);
        if (!ctx.isInTxScope() && command.isSuccessful()) {
            this.dm.getTransactionLogger().logIfNeeded(command);
        }
        return o;
    }

    class ReplayCommandVisitor
    extends AbstractVisitor {
        ReplayCommandVisitor() {
        }

        @Override
        public Object visitPutMapCommand(InvocationContext ignored, PutMapCommand command) {
            HashMap<Object, Object> newMap = new HashMap<Object, Object>();
            for (Map.Entry<Object, Object> entry : command.getMap().entrySet()) {
                if (!DistTxInterceptor.this.dm.isLocal(entry.getKey())) continue;
                newMap.put(entry.getKey(), entry.getValue());
            }
            if (newMap.isEmpty()) {
                return null;
            }
            if (newMap.size() == command.getMap().size()) {
                return command;
            }
            return DistTxInterceptor.this.commandsFactory.buildPutMapCommand(newMap, command.getLifespanMillis(), command.getMaxIdleTimeMillis());
        }

        @Override
        public Object visitPutKeyValueCommand(InvocationContext ignored, PutKeyValueCommand command) {
            return this.visitDataWriteCommand(command);
        }

        @Override
        public Object visitRemoveCommand(InvocationContext ignored, RemoveCommand command) {
            return this.visitDataWriteCommand(command);
        }

        @Override
        public Object visitReplaceCommand(InvocationContext ignored, ReplaceCommand command) {
            return this.visitDataWriteCommand(command);
        }

        private VisitableCommand visitDataWriteCommand(DataWriteCommand command) {
            return DistTxInterceptor.this.dm.isLocal(command.getKey()) ? command : null;
        }

        @Override
        public Object handleDefault(InvocationContext ignored, VisitableCommand command) {
            return command;
        }
    }
}

