/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.factories;

import javax.transaction.TransactionManager;
import org.infinispan.factories.AbstractNamedCacheComponentFactory;
import org.infinispan.factories.AutoInstantiableFactory;
import org.infinispan.factories.annotations.DefaultFactoryFor;
import org.infinispan.transaction.lookup.TransactionManagerLookup;
import org.infinispan.transaction.tm.BatchModeTransactionManager;
import org.infinispan.util.Util;

@DefaultFactoryFor(classes={TransactionManager.class})
public class TransactionManagerFactory
extends AbstractNamedCacheComponentFactory
implements AutoInstantiableFactory {
    @Override
    public <T> T construct(Class<T> componentType) {
        TransactionManager transactionManager = null;
        TransactionManagerLookup lookup = this.configuration.getTransactionManagerLookup();
        if (lookup == null && this.configuration.getTransactionManagerLookupClass() != null) {
            lookup = (TransactionManagerLookup)Util.getInstance(this.configuration.getTransactionManagerLookupClass());
        }
        try {
            if (lookup != null) {
                transactionManager = lookup.getTransactionManager();
            }
        }
        catch (Exception e) {
            this.log.info((Object)"failed looking up TransactionManager, will not use transactions", e);
        }
        if (transactionManager == null && this.configuration.isInvocationBatchingEnabled()) {
            this.log.info("Using a batchMode transaction manager");
            transactionManager = BatchModeTransactionManager.getInstance();
        }
        return componentType.cast(transactionManager);
    }
}

