/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.container.entries;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.infinispan.container.entries.ExpiryHelper;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.container.entries.MortalCacheValue;
import org.infinispan.container.entries.TransientMortalCacheEntry;
import org.infinispan.io.UnsignedNumeric;
import org.infinispan.marshall.Marshallable;

@Marshallable(externalizer=Externalizer.class, id=17)
public class TransientMortalCacheValue
extends MortalCacheValue {
    long maxIdle = -1L;
    long lastUsed;

    TransientMortalCacheValue(Object value, long created, long lifespan, long maxIdle, long lastUsed) {
        this(value, created, lifespan, maxIdle);
        this.lastUsed = lastUsed;
    }

    public TransientMortalCacheValue(Object value, long created, long lifespan, long maxIdle) {
        super(value, created, lifespan);
        this.maxIdle = maxIdle;
    }

    public TransientMortalCacheValue(Object value, long created) {
        super(value, created, -1L);
    }

    @Override
    public long getMaxIdle() {
        return this.maxIdle;
    }

    public void setMaxIdle(long maxIdle) {
        this.maxIdle = maxIdle;
    }

    @Override
    public long getLastUsed() {
        return this.lastUsed;
    }

    public void setLastUsed(long lastUsed) {
        this.lastUsed = lastUsed;
    }

    @Override
    public boolean isExpired() {
        return ExpiryHelper.isExpiredTransientMortal(this.maxIdle, this.lastUsed, this.lifespan, this.created);
    }

    @Override
    public InternalCacheEntry toInternalCacheEntry(Object key) {
        return new TransientMortalCacheEntry(key, this.value, this.maxIdle, this.lifespan, this.lastUsed, this.created);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TransientMortalCacheValue)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        TransientMortalCacheValue that = (TransientMortalCacheValue)o;
        if (this.lastUsed != that.lastUsed) {
            return false;
        }
        return this.maxIdle == that.maxIdle;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (int)(this.maxIdle ^ this.maxIdle >>> 32);
        result = 31 * result + (int)(this.lastUsed ^ this.lastUsed >>> 32);
        return result;
    }

    @Override
    public String toString() {
        return "TransientMortalCacheValue{maxIdle=" + this.maxIdle + ", lastUsed=" + this.lastUsed + "} " + super.toString();
    }

    @Override
    public TransientMortalCacheValue clone() {
        return (TransientMortalCacheValue)super.clone();
    }

    public static class Externalizer
    implements org.infinispan.marshall.Externalizer {
        @Override
        public void writeObject(ObjectOutput output, Object subject) throws IOException {
            TransientMortalCacheValue icv = (TransientMortalCacheValue)subject;
            output.writeObject(icv.value);
            UnsignedNumeric.writeUnsignedLong(output, icv.created);
            output.writeLong(icv.lifespan);
            UnsignedNumeric.writeUnsignedLong(output, icv.lastUsed);
            output.writeLong(icv.maxIdle);
        }

        @Override
        public Object readObject(ObjectInput input) throws IOException, ClassNotFoundException {
            Object v = input.readObject();
            long created = UnsignedNumeric.readUnsignedLong(input);
            Long lifespan = input.readLong();
            long lastUsed = UnsignedNumeric.readUnsignedLong(input);
            Long maxIdle = input.readLong();
            return new TransientMortalCacheValue(v, created, lifespan, maxIdle, lastUsed);
        }
    }
}

