/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.envers.entities;

import java.util.HashMap;
import java.util.Map;
import org.hibernate.envers.entities.IdMappingData;
import org.hibernate.envers.entities.RelationDescription;
import org.hibernate.envers.entities.RelationType;
import org.hibernate.envers.entities.mapper.ExtendedPropertyMapper;
import org.hibernate.envers.entities.mapper.PropertyMapper;
import org.hibernate.envers.entities.mapper.id.IdMapper;

public class EntityConfiguration {
    private String versionsEntityName;
    private String entityClassName;
    private IdMappingData idMappingData;
    private ExtendedPropertyMapper propertyMapper;
    private Map<String, RelationDescription> relations;
    private String parentEntityName;

    public EntityConfiguration(String versionsEntityName, String entityClassName, IdMappingData idMappingData, ExtendedPropertyMapper propertyMapper, String parentEntityName) {
        this.versionsEntityName = versionsEntityName;
        this.entityClassName = entityClassName;
        this.idMappingData = idMappingData;
        this.propertyMapper = propertyMapper;
        this.parentEntityName = parentEntityName;
        this.relations = new HashMap<String, RelationDescription>();
    }

    public void addToOneRelation(String fromPropertyName, String toEntityName, IdMapper idMapper, boolean insertable) {
        this.relations.put(fromPropertyName, new RelationDescription(fromPropertyName, RelationType.TO_ONE, toEntityName, null, idMapper, null, null, insertable));
    }

    public void addToOneNotOwningRelation(String fromPropertyName, String mappedByPropertyName, String toEntityName, IdMapper idMapper) {
        this.relations.put(fromPropertyName, new RelationDescription(fromPropertyName, RelationType.TO_ONE_NOT_OWNING, toEntityName, mappedByPropertyName, idMapper, null, null, true));
    }

    public void addToManyNotOwningRelation(String fromPropertyName, String mappedByPropertyName, String toEntityName, IdMapper idMapper, PropertyMapper fakeBidirectionalRelationMapper, PropertyMapper fakeBidirectionalRelationIndexMapper) {
        this.relations.put(fromPropertyName, new RelationDescription(fromPropertyName, RelationType.TO_MANY_NOT_OWNING, toEntityName, mappedByPropertyName, idMapper, fakeBidirectionalRelationMapper, fakeBidirectionalRelationIndexMapper, true));
    }

    public void addToManyMiddleRelation(String fromPropertyName, String toEntityName) {
        this.relations.put(fromPropertyName, new RelationDescription(fromPropertyName, RelationType.TO_MANY_MIDDLE, toEntityName, null, null, null, null, true));
    }

    public void addToManyMiddleNotOwningRelation(String fromPropertyName, String mappedByPropertyName, String toEntityName) {
        this.relations.put(fromPropertyName, new RelationDescription(fromPropertyName, RelationType.TO_MANY_MIDDLE_NOT_OWNING, toEntityName, mappedByPropertyName, null, null, null, true));
    }

    public boolean isRelation(String propertyName) {
        return this.relations.get(propertyName) != null;
    }

    public RelationDescription getRelationDescription(String propertyName) {
        return this.relations.get(propertyName);
    }

    public IdMappingData getIdMappingData() {
        return this.idMappingData;
    }

    public IdMapper getIdMapper() {
        return this.idMappingData.getIdMapper();
    }

    public ExtendedPropertyMapper getPropertyMapper() {
        return this.propertyMapper;
    }

    public String getParentEntityName() {
        return this.parentEntityName;
    }

    String getVersionsEntityName() {
        return this.versionsEntityName;
    }

    Iterable<RelationDescription> getRelationsIterator() {
        return this.relations.values();
    }

    public String getEntityClassName() {
        return this.entityClassName;
    }
}

