/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.event.internal;

import org.hibernate.HibernateException;
import org.hibernate.collection.spi.PersistentCollection;
import org.hibernate.engine.spi.CollectionEntry;
import org.hibernate.engine.spi.CollectionKey;
import org.hibernate.event.internal.AbstractVisitor;
import org.hibernate.event.spi.EventSource;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.pretty.MessageHelper;
import org.hibernate.type.CollectionType;
import org.jboss.logging.Logger;

public class EvictVisitor
extends AbstractVisitor {
    private static final CoreMessageLogger LOG = (CoreMessageLogger)Logger.getMessageLogger(CoreMessageLogger.class, (String)EvictVisitor.class.getName());

    EvictVisitor(EventSource session) {
        super(session);
    }

    @Override
    Object processCollection(Object collection, CollectionType type) throws HibernateException {
        if (collection != null) {
            this.evictCollection(collection, type);
        }
        return null;
    }

    public void evictCollection(Object value, CollectionType type) {
        Object pc;
        if (type.hasHolder()) {
            pc = this.getSession().getPersistenceContext().removeCollectionHolder(value);
        } else if (value instanceof PersistentCollection) {
            pc = value;
        } else {
            return;
        }
        PersistentCollection collection = (PersistentCollection)pc;
        if (collection.unsetSession(this.getSession())) {
            this.evictCollection(collection);
        }
    }

    private void evictCollection(PersistentCollection collection) {
        CollectionEntry ce = (CollectionEntry)this.getSession().getPersistenceContext().getCollectionEntries().remove(collection);
        if (LOG.isDebugEnabled()) {
            LOG.debugf("Evicting collection: %s", MessageHelper.collectionInfoString(ce.getLoadedPersister(), ce.getLoadedKey(), this.getSession().getFactory()));
        }
        if (ce.getLoadedPersister() != null && ce.getLoadedKey() != null) {
            this.getSession().getPersistenceContext().getCollectionsByKey().remove(new CollectionKey(ce.getLoadedPersister(), ce.getLoadedKey()));
        }
    }
}

