/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cache.infinispan;

import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import org.hibernate.cache.CacheException;
import org.infinispan.config.Configuration;
import org.infinispan.eviction.EvictionStrategy;

public class TypeOverrides {
    private final Set<String> overridden = new HashSet<String>();
    private String cacheName;
    private EvictionStrategy evictionStrategy;
    private long evictionWakeUpInterval;
    private int evictionMaxEntries;
    private long expirationLifespan;
    private long expirationMaxIdle;
    private boolean isExposeStatistics;

    public String getCacheName() {
        return this.cacheName;
    }

    public void setCacheName(String cacheName) {
        this.cacheName = cacheName;
    }

    public EvictionStrategy getEvictionStrategy() {
        return this.evictionStrategy;
    }

    public void setEvictionStrategy(String evictionStrategy) {
        this.markAsOverriden("evictionStrategy");
        this.evictionStrategy = EvictionStrategy.valueOf((String)this.uc(evictionStrategy));
    }

    public long getEvictionWakeUpInterval() {
        return this.evictionWakeUpInterval;
    }

    public void setEvictionWakeUpInterval(long evictionWakeUpInterval) {
        this.markAsOverriden("evictionWakeUpInterval");
        this.evictionWakeUpInterval = evictionWakeUpInterval;
    }

    public int getEvictionMaxEntries() {
        return this.evictionMaxEntries;
    }

    public void setEvictionMaxEntries(int evictionMaxEntries) {
        this.markAsOverriden("evictionMaxEntries");
        this.evictionMaxEntries = evictionMaxEntries;
    }

    public long getExpirationLifespan() {
        return this.expirationLifespan;
    }

    public void setExpirationLifespan(long expirationLifespan) {
        this.markAsOverriden("expirationLifespan");
        this.expirationLifespan = expirationLifespan;
    }

    public long getExpirationMaxIdle() {
        return this.expirationMaxIdle;
    }

    public void setExpirationMaxIdle(long expirationMaxIdle) {
        this.markAsOverriden("expirationMaxIdle");
        this.expirationMaxIdle = expirationMaxIdle;
    }

    public boolean isExposeStatistics() {
        return this.isExposeStatistics;
    }

    public void setExposeStatistics(boolean isExposeStatistics) {
        this.markAsOverriden("isExposeStatistics");
        this.isExposeStatistics = isExposeStatistics;
    }

    public Configuration createInfinispanConfiguration() {
        Configuration cacheCfg = new Configuration();
        if (this.overridden.contains("evictionStrategy")) {
            cacheCfg.fluent().eviction().strategy(this.evictionStrategy);
        }
        if (this.overridden.contains("evictionWakeUpInterval")) {
            cacheCfg.fluent().expiration().wakeUpInterval(Long.valueOf(this.evictionWakeUpInterval));
        }
        if (this.overridden.contains("evictionMaxEntries")) {
            cacheCfg.fluent().eviction().maxEntries(Integer.valueOf(this.evictionMaxEntries));
        }
        if (this.overridden.contains("expirationLifespan")) {
            cacheCfg.fluent().expiration().lifespan(Long.valueOf(this.expirationLifespan));
        }
        if (this.overridden.contains("expirationMaxIdle")) {
            cacheCfg.fluent().expiration().maxIdle(Long.valueOf(this.expirationMaxIdle));
        }
        if (this.overridden.contains("isExposeStatistics") && this.isExposeStatistics) {
            cacheCfg.fluent().jmxStatistics();
        }
        return cacheCfg;
    }

    public void validateInfinispanConfiguration(Configuration configuration) throws CacheException {
    }

    public String toString() {
        return this.getClass().getSimpleName() + '{' + "cache=" + this.cacheName + ", strategy=" + this.evictionStrategy + ", wakeUpInterval=" + this.evictionWakeUpInterval + ", maxEntries=" + this.evictionMaxEntries + ", lifespan=" + this.expirationLifespan + ", maxIdle=" + this.expirationMaxIdle + '}';
    }

    private String uc(String s) {
        return s == null ? null : s.toUpperCase(Locale.ENGLISH);
    }

    private void markAsOverriden(String fieldName) {
        this.overridden.add(fieldName);
    }
}

