/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.configuration.cache;

import org.infinispan.commons.hash.Hash;
import org.infinispan.configuration.cache.GroupsConfiguration;
import org.infinispan.configuration.cache.StateTransferConfiguration;
import org.infinispan.distribution.ch.ConsistentHash;

public class HashConfiguration {
    private final ConsistentHash consistentHash;
    private final Hash hash;
    private final int numOwners;
    private final int numVirtualNodes;
    private final GroupsConfiguration groupsConfiguration;
    private final StateTransferConfiguration stateTransferConfiguration;
    final boolean activated;

    HashConfiguration(ConsistentHash consistentHash, Hash hash, int numOwners, int numVirtualNodes, GroupsConfiguration groupsConfiguration, StateTransferConfiguration stateTransferConfiguration, boolean activated) {
        this.consistentHash = consistentHash;
        this.hash = hash;
        this.numOwners = numOwners;
        this.numVirtualNodes = numVirtualNodes;
        this.groupsConfiguration = groupsConfiguration;
        this.stateTransferConfiguration = stateTransferConfiguration;
        this.activated = activated;
    }

    public ConsistentHash consistentHash() {
        return this.consistentHash;
    }

    public Hash hash() {
        return this.hash;
    }

    public int numOwners() {
        return this.numOwners;
    }

    public int numVirtualNodes() {
        return this.numVirtualNodes;
    }

    public boolean rehashEnabled() {
        return this.stateTransferConfiguration.fetchInMemoryState();
    }

    @Deprecated
    public long rehashRpcTimeout() {
        return this.stateTransferConfiguration.timeout();
    }

    @Deprecated
    public long rehashWait() {
        return this.stateTransferConfiguration.timeout();
    }

    public GroupsConfiguration groups() {
        return this.groupsConfiguration;
    }

    public String toString() {
        return "HashConfiguration{activated=" + this.activated + ", consistentHash=" + this.consistentHash + ", hash=" + this.hash + ", numOwners=" + this.numOwners + ", numVirtualNodes=" + this.numVirtualNodes + ", groupsConfiguration=" + this.groupsConfiguration + ", stateTransferConfiguration=" + this.stateTransferConfiguration + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HashConfiguration that = (HashConfiguration)o;
        if (this.activated != that.activated) {
            return false;
        }
        if (this.numOwners != that.numOwners) {
            return false;
        }
        if (this.numVirtualNodes != that.numVirtualNodes) {
            return false;
        }
        if (this.consistentHash != null ? !this.consistentHash.equals(that.consistentHash) : that.consistentHash != null) {
            return false;
        }
        if (this.groupsConfiguration != null ? !this.groupsConfiguration.equals(that.groupsConfiguration) : that.groupsConfiguration != null) {
            return false;
        }
        if (this.hash != null ? !this.hash.equals(that.hash) : that.hash != null) {
            return false;
        }
        return !(this.stateTransferConfiguration != null ? !this.stateTransferConfiguration.equals(that.stateTransferConfiguration) : that.stateTransferConfiguration != null);
    }

    public int hashCode() {
        int result = this.consistentHash != null ? this.consistentHash.hashCode() : 0;
        result = 31 * result + (this.hash != null ? this.hash.hashCode() : 0);
        result = 31 * result + this.numOwners;
        result = 31 * result + this.numVirtualNodes;
        result = 31 * result + (this.groupsConfiguration != null ? this.groupsConfiguration.hashCode() : 0);
        result = 31 * result + (this.stateTransferConfiguration != null ? this.stateTransferConfiguration.hashCode() : 0);
        result = 31 * result + (this.activated ? 1 : 0);
        return result;
    }
}

