/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.container.versioning;

import org.infinispan.Cache;
import org.infinispan.container.versioning.IncrementableEntryVersion;
import org.infinispan.container.versioning.SimpleClusteredVersion;
import org.infinispan.container.versioning.VersionGenerator;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.annotations.Start;
import org.infinispan.notifications.Listener;
import org.infinispan.notifications.cachemanagerlistener.annotation.ViewChanged;
import org.infinispan.notifications.cachemanagerlistener.event.ViewChangedEvent;
import org.infinispan.remoting.transport.Transport;

public class SimpleClusteredVersionGenerator
implements VersionGenerator {
    private volatile int viewId;
    private Cache cache;
    private Transport transport;

    @Inject
    public void init(Cache cache, Transport transport) {
        this.cache = cache;
        this.transport = transport;
    }

    @Start(priority=11)
    public void start() {
        if (this.transport != null) {
            this.viewId = this.transport.getViewId();
            this.cache.getCacheManager().addListener(new ViewIdUpdater());
        }
    }

    @Override
    public IncrementableEntryVersion generateNew() {
        return new SimpleClusteredVersion(this.viewId, 1L);
    }

    @Override
    public IncrementableEntryVersion increment(IncrementableEntryVersion initialVersion) {
        if (initialVersion instanceof SimpleClusteredVersion) {
            SimpleClusteredVersion old = (SimpleClusteredVersion)initialVersion;
            return new SimpleClusteredVersion(this.viewId, old.version + 1L);
        }
        throw new IllegalArgumentException("I only know how to deal with SimpleClusteredVersions, not " + initialVersion.getClass().getName());
    }

    @Listener
    public class ViewIdUpdater {
        @ViewChanged
        public void handleViewChange(ViewChangedEvent e) {
            SimpleClusteredVersionGenerator.this.viewId = e.getViewId();
        }
    }
}

