/*
 * Decompiled with CFR 0.152.
 */
package org.logicalcobwebs.proxool;

import java.sql.SQLException;
import java.sql.Statement;
import java.util.Comparator;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.TreeMap;
import org.logicalcobwebs.logging.Log;
import org.logicalcobwebs.logging.LogFactory;
import org.logicalcobwebs.proxool.ConnectionPool;
import org.logicalcobwebs.proxool.FatalSqlExceptionHelper;
import org.logicalcobwebs.proxool.HouseKeeperController;
import org.logicalcobwebs.proxool.ProxyConnectionIF;

abstract class AbstractProxyStatement {
    private static final Log LOG = LogFactory.getLog(class$org$logicalcobwebs$proxool$ProxyStatement == null ? (class$org$logicalcobwebs$proxool$ProxyStatement = AbstractProxyStatement.class$("org.logicalcobwebs.proxool.ProxyStatement")) : class$org$logicalcobwebs$proxool$ProxyStatement);
    private Statement statement;
    private ConnectionPool connectionPool;
    private ProxyConnectionIF proxyConnection;
    private Map parameters;
    private String sqlStatement;
    private StringBuffer sqlLog = new StringBuffer();
    static /* synthetic */ Class class$org$logicalcobwebs$proxool$ProxyStatement;

    public AbstractProxyStatement(Statement statement, ConnectionPool connectionPool, ProxyConnectionIF proxyConnection, String sqlStatement) {
        this.statement = statement;
        this.connectionPool = connectionPool;
        this.proxyConnection = proxyConnection;
        this.sqlStatement = sqlStatement;
    }

    protected boolean testException(Throwable t) {
        if (FatalSqlExceptionHelper.testException(this.connectionPool.getDefinition(), t)) {
            try {
                this.statement.close();
                this.connectionPool.throwConnection(this.proxyConnection, "Fatal SQL Exception has been detected");
                HouseKeeperController.sweepNow(this.connectionPool.getDefinition().getAlias());
                LOG.warn("Connection has been thrown away because fatal exception was detected", t);
            }
            catch (SQLException e2) {
                LOG.error("Problem trying to throw away suspect connection", e2);
            }
            return true;
        }
        return false;
    }

    public Statement getDelegateStatement() {
        return this.statement;
    }

    protected ConnectionPool getConnectionPool() {
        return this.connectionPool;
    }

    protected Statement getStatement() {
        return this.statement;
    }

    public void close() throws SQLException {
        this.statement.close();
        this.proxyConnection.registerClosedStatement(this.statement);
    }

    public boolean equals(Object obj) {
        return this.statement.hashCode() == obj.hashCode();
    }

    protected void putParameter(int index, Object value) {
        if (this.parameters == null) {
            this.parameters = new TreeMap(new Comparator(){

                public int compare(Object o1, Object o2) {
                    int c = 0;
                    if (o1 instanceof Integer && o2 instanceof Integer) {
                        c = ((Integer)o1).compareTo((Integer)o2);
                    }
                    return c;
                }
            });
        }
        Integer key = new Integer(index);
        if (value == null) {
            this.parameters.put(key, "NULL");
        } else if (value instanceof String) {
            this.parameters.put(key, "'" + value + "'");
        } else if (value instanceof Number) {
            this.parameters.put(key, value);
        } else {
            String className = value.getClass().getName();
            StringTokenizer st = new StringTokenizer(className, ".");
            while (st.hasMoreTokens()) {
                className = st.nextToken();
            }
            this.parameters.put(key, className);
        }
    }

    protected void trace(long startTime, Exception exception) throws SQLException {
        if (this.isTrace()) {
            if (this.connectionPool.getLog().isDebugEnabled() && this.connectionPool.getDefinition().isTrace()) {
                this.connectionPool.getLog().debug(this.sqlLog.toString() + " (" + (System.currentTimeMillis() - startTime) + " milliseconds" + (exception != null ? ", threw a " + exception.getClass().getName() + ": " + exception.getMessage() + ")" : ")"));
            }
            this.connectionPool.onExecute(this.sqlLog.toString(), System.currentTimeMillis() - startTime, exception);
        }
        if (this.parameters != null) {
            this.parameters.clear();
        }
        this.sqlStatement = null;
        this.sqlLog.setLength(0);
    }

    protected void appendToSqlLog() {
        if (this.sqlStatement != null && this.sqlStatement.length() > 0 && this.isTrace()) {
            int parameterIndex = 0;
            StringTokenizer st = new StringTokenizer(this.sqlStatement, "?");
            while (st.hasMoreTokens()) {
                if (parameterIndex > 0) {
                    if (this.parameters != null) {
                        Object value = this.parameters.get(new Integer(parameterIndex));
                        if (value != null) {
                            this.sqlLog.append(value);
                        } else {
                            this.sqlLog.append("?");
                        }
                    } else {
                        this.sqlLog.append("?");
                    }
                }
                ++parameterIndex;
                this.sqlLog.append(st.nextToken());
            }
            this.sqlLog.append("; ");
        }
        if (this.parameters != null) {
            this.parameters.clear();
        }
    }

    protected boolean isTrace() {
        boolean isTrace = this.getConnectionPool().isConnectionListenedTo() || this.getConnectionPool().getDefinition().isTrace() && this.getConnectionPool().getLog().isDebugEnabled();
        return isTrace;
    }

    protected void setSqlStatementIfNull(String sqlStatement) {
        if (this.sqlStatement == null) {
            this.sqlStatement = sqlStatement;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

