/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.envers.configuration;

import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.hibernate.envers.strategy.DefaultAuditStrategy;
import org.hibernate.envers.tools.Tools;

public class AuditEntitiesConfiguration {
    private final String auditTablePrefix;
    private final String auditTableSuffix;
    private final String auditStrategyName;
    private final String originalIdPropName;
    private final String revisionFieldName;
    private final String revisionNumberPath;
    private final String revisionPropBasePath;
    private final String revisionTypePropName;
    private final String revisionTypePropType;
    private final String revisionInfoEntityName;
    private final Map<String, String> customAuditTablesNames;
    private final String revisionEndFieldName;
    private final boolean revisionEndTimestampEnabled;
    private final String revisionEndTimestampFieldName;

    public AuditEntitiesConfiguration(Properties properties, String revisionInfoEntityName) {
        this.revisionInfoEntityName = revisionInfoEntityName;
        this.auditTablePrefix = Tools.getProperty(properties, "org.hibernate.envers.audit_table_prefix", "org.hibernate.envers.auditTablePrefix", "");
        this.auditTableSuffix = Tools.getProperty(properties, "org.hibernate.envers.audit_table_suffix", "org.hibernate.envers.auditTableSuffix", "_AUD");
        this.auditStrategyName = Tools.getProperty(properties, "org.hibernate.envers.audit_strategy", "org.hibernate.envers.audit_strategy", DefaultAuditStrategy.class.getName());
        this.originalIdPropName = "originalId";
        this.revisionFieldName = Tools.getProperty(properties, "org.hibernate.envers.revision_field_name", "org.hibernate.envers.revisionFieldName", "REV");
        this.revisionTypePropName = Tools.getProperty(properties, "org.hibernate.envers.revision_type_field_name", "org.hibernate.envers.revisionTypeFieldName", "REVTYPE");
        this.revisionTypePropType = "byte";
        this.revisionEndFieldName = Tools.getProperty(properties, "org.hibernate.envers.audit_strategy_validity_end_rev_field_name", "org.hibernate.envers.audit_strategy_valid_time_end_name", "REVEND");
        String revisionEndTimestampEnabledStr = Tools.getProperty(properties, "org.hibernate.envers.audit_strategy_validity_store_revend_timestamp", "org.hibernate.envers.audit_strategy_validity_store_revend_timestamp", "false");
        this.revisionEndTimestampEnabled = Boolean.parseBoolean(revisionEndTimestampEnabledStr);
        this.revisionEndTimestampFieldName = this.revisionEndTimestampEnabled ? Tools.getProperty(properties, "org.hibernate.envers.audit_strategy_validity_revend_timestamp_field_name", "org.hibernate.envers.audit_strategy_validity_revend_timestamp_field_name", "REVEND_TSTMP") : null;
        this.customAuditTablesNames = new HashMap<String, String>();
        this.revisionNumberPath = this.originalIdPropName + "." + this.revisionFieldName + ".id";
        this.revisionPropBasePath = this.originalIdPropName + "." + this.revisionFieldName + ".";
    }

    public String getOriginalIdPropName() {
        return this.originalIdPropName;
    }

    public String getRevisionFieldName() {
        return this.revisionFieldName;
    }

    public boolean isRevisionEndTimestampEnabled() {
        return this.revisionEndTimestampEnabled;
    }

    public String getRevisionEndTimestampFieldName() {
        return this.revisionEndTimestampFieldName;
    }

    public String getRevisionNumberPath() {
        return this.revisionNumberPath;
    }

    public String getRevisionPropPath(String propertyName) {
        return this.revisionPropBasePath + propertyName;
    }

    public String getRevisionTypePropName() {
        return this.revisionTypePropName;
    }

    public String getRevisionTypePropType() {
        return this.revisionTypePropType;
    }

    public String getRevisionInfoEntityName() {
        return this.revisionInfoEntityName;
    }

    public void addCustomAuditTableName(String entityName, String tableName) {
        this.customAuditTablesNames.put(entityName, tableName);
    }

    public String getAuditEntityName(String entityName) {
        return this.auditTablePrefix + entityName + this.auditTableSuffix;
    }

    public String getAuditTableName(String entityName, String tableName) {
        String customHistoryTableName = this.customAuditTablesNames.get(entityName);
        if (customHistoryTableName == null) {
            return this.auditTablePrefix + tableName + this.auditTableSuffix;
        }
        return customHistoryTableName;
    }

    public String getAuditStrategyName() {
        return this.auditStrategyName;
    }

    public String getRevisionEndFieldName() {
        return this.revisionEndFieldName;
    }
}

