/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.service.config.internal;

import java.util.Collections;
import java.util.Map;
import org.hibernate.service.config.spi.ConfigurationService;

public class ConfigurationServiceImpl
implements ConfigurationService {
    private final Map settings;

    public ConfigurationServiceImpl(Map settings) {
        this.settings = Collections.unmodifiableMap(settings);
    }

    @Override
    public Map getSettings() {
        return this.settings;
    }

    @Override
    public <T> T getSetting(String name, ConfigurationService.Converter<T> converter) {
        return this.getSetting(name, converter, null);
    }

    @Override
    public <T> T getSetting(String name, ConfigurationService.Converter<T> converter, T defaultValue) {
        Object value = this.settings.get(name);
        if (value == null) {
            return defaultValue;
        }
        return converter.convert(value);
    }
}

