/*
 * Decompiled with CFR 0.152.
 */
package org.kordamp.jarviz.commands;

import java.nio.file.Path;
import java.util.Set;
import org.kordamp.jarviz.bundle.RB;
import org.kordamp.jarviz.core.Format;
import org.kordamp.jarviz.core.internal.AbstractCommand;
import org.kordamp.jarviz.core.internal.AbstractConfiguration;
import org.kordamp.jarviz.core.processors.EntriesExtractJarProcessor;
import org.kordamp.jarviz.core.processors.JarProcessor;
import org.kordamp.jarviz.core.resolvers.JarFileResolver;
import org.kordamp.jarviz.reporting.Node;
import org.kordamp.jarviz.util.StringUtils;

public class EntriesExtractCommand
extends AbstractCommand<Configuration> {
    public static Configuration config() {
        return new Configuration();
    }

    @Override
    public int execute(Configuration configuration) {
        JarFileResolver jarFileResolver = this.createJarFileResolver(configuration);
        EntriesExtractJarProcessor processor = new EntriesExtractJarProcessor(jarFileResolver);
        processor.setEntryName(configuration.getEntryName());
        processor.setEntryPattern(configuration.getEntryPattern());
        processor.setTargetDirectory(configuration.getTargetDirectory());
        processor.setFlatten(configuration.isFlatten());
        Set<JarProcessor.JarFileResult<Set<String>>> results = processor.getResult();
        configuration.withEntryPattern(processor.getEntryPattern());
        if (results.isEmpty()) {
            return 1;
        }
        this.output(configuration, results);
        this.report(configuration, results);
        return 0;
    }

    private void output(Configuration configuration, Set<JarProcessor.JarFileResult<Set<String>>> results) {
        Node root = this.createRootNode();
        Format outputFormat = configuration.getOutputFormat();
        for (JarProcessor.JarFileResult<Set<String>> result : results) {
            if (null == outputFormat) {
                this.output(configuration, result);
                continue;
            }
            this.buildReport(configuration, outputFormat, root, result);
        }
        if (null != outputFormat) {
            this.writeOutput(configuration, this.resolveFormatter(outputFormat).write(root));
        }
    }

    private void output(Configuration configuration, JarProcessor.JarFileResult<Set<String>> result) {
        if (!result.getResult().isEmpty()) {
            configuration.getOut().println(this.$$("output.subject", result.getJarFileName()));
            if (StringUtils.isBlank(configuration.getEntryPattern())) {
                configuration.getOut().println(this.$$("entries.entry.name", configuration.getEntryName()));
            } else {
                configuration.getOut().println(this.$$("entries.entry.pattern", configuration.getEntryPattern()));
            }
            result.getResult().forEach(configuration.getOut()::println);
        }
    }

    private void report(Configuration configuration, Set<JarProcessor.JarFileResult<Set<String>>> results) {
        if (null == configuration.getReportPath()) {
            return;
        }
        for (Format format : configuration.getReportFormats()) {
            Node root = this.createRootNode();
            for (JarProcessor.JarFileResult<Set<String>> result : results) {
                if (result.getResult().isEmpty()) continue;
                this.buildReport(configuration, format, root, result);
            }
            this.writeReport(configuration, this.resolveFormatter(format).write(root), format);
        }
    }

    private void buildReport(Configuration configuration, Format format, Node root, JarProcessor.JarFileResult<Set<String>> result) {
        this.appendSubject(root, result.getJarPath(), "entries find", resultNode -> {
            String key = StringUtils.isBlank(configuration.getEntryPattern()) ? "report.key.entry.name" : "report.key.entry.pattern";
            String value = StringUtils.isBlank(configuration.getEntryPattern()) ? configuration.getEntryName() : configuration.getEntryPattern();
            Node entries = resultNode.node(RB.$(key, new Object[0])).value(value).end().array(RB.$("report.key.entries", new Object[0]));
            for (String service : (Set)result.getResult()) {
                if (format != Format.XML) {
                    entries.node(service);
                    continue;
                }
                entries.node(RB.$("report.key.entry", new Object[0])).value(service).end();
            }
        });
    }

    public static class Configuration
    extends AbstractConfiguration<Configuration> {
        private String entryName;
        private String entryPattern;
        private boolean flatten;
        private Path targetDirectory = Path.of(".", new String[0]);

        public String getEntryName() {
            return this.entryName;
        }

        public Configuration withEntryName(String entryName) {
            this.entryName = entryName;
            if (StringUtils.isNotBlank(this.entryName) && (entryName = entryName.replaceAll("/", ".")).startsWith(".")) {
                entryName = entryName.substring(1);
            }
            return this;
        }

        public String getEntryPattern() {
            return this.entryPattern;
        }

        public Configuration withEntryPattern(String entryPattern) {
            this.entryPattern = entryPattern;
            return this;
        }

        public boolean isFlatten() {
            return this.flatten;
        }

        public Configuration withFlatten(boolean flatten) {
            this.flatten = flatten;
            return this;
        }

        public Path getTargetDirectory() {
            return this.targetDirectory;
        }

        public Configuration withTargetDirectory(Path targetDirectory) {
            if (null != targetDirectory) {
                this.targetDirectory = targetDirectory;
            }
            return this;
        }
    }
}

