/*
 * Decompiled with CFR 0.152.
 */
package org.kordamp.jarviz.commands;

import java.lang.module.ModuleDescriptor;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.kordamp.jarviz.bundle.RB;
import org.kordamp.jarviz.core.Format;
import org.kordamp.jarviz.core.JarvizException;
import org.kordamp.jarviz.core.internal.AbstractCommand;
import org.kordamp.jarviz.core.internal.AbstractConfiguration;
import org.kordamp.jarviz.core.internal.Colorizer;
import org.kordamp.jarviz.core.model.ModuleMetadata;
import org.kordamp.jarviz.core.model.ModuleName;
import org.kordamp.jarviz.core.processors.JarProcessor;
import org.kordamp.jarviz.core.processors.ModuleDescriptorJarProcessor;
import org.kordamp.jarviz.core.resolvers.JarFileResolver;
import org.kordamp.jarviz.reporting.Node;

public class ModuleDescriptorCommand
extends AbstractCommand<Configuration> {
    public static Configuration config() {
        return new Configuration();
    }

    @Override
    public int execute(Configuration configuration) {
        JarFileResolver jarFileResolver = this.createJarFileResolver(configuration);
        ModuleDescriptorJarProcessor processor = new ModuleDescriptorJarProcessor(jarFileResolver);
        Set<JarProcessor.JarFileResult<ModuleMetadata>> results = processor.getResult();
        if (results.isEmpty()) {
            return 1;
        }
        this.output(configuration, results);
        this.report(configuration, results);
        Set errors = results.stream().map(JarProcessor.JarFileResult::getResult).map(ModuleMetadata::getModuleName).filter(ModuleName::isNotValid).map(ModuleName::asError).collect(Collectors.toSet());
        if (configuration.isFailOnError()) {
            throw new JarvizException(String.join((CharSequence)System.lineSeparator(), errors));
        }
        configuration.getErr().println(String.join((CharSequence)System.lineSeparator(), errors));
        return 0;
    }

    private void output(Configuration configuration, Set<JarProcessor.JarFileResult<ModuleMetadata>> results) {
        Node root = this.createRootNode();
        Format outputFormat = configuration.getOutputFormat();
        for (JarProcessor.JarFileResult<ModuleMetadata> result : results) {
            if (null == outputFormat) {
                this.output(configuration, result);
                continue;
            }
            this.buildReport(outputFormat, root, result);
        }
        if (null != outputFormat) {
            this.writeOutput(configuration, this.resolveFormatter(outputFormat).write(root));
        }
    }

    private void output(Configuration configuration, JarProcessor.JarFileResult<ModuleMetadata> result) {
        configuration.getOut().println(this.$$("output.subject", result.getJarFileName()));
        ModuleName moduleName = result.getResult().getModuleName();
        if (!moduleName.isValid()) {
            configuration.getOut().println(this.$$("module.name", moduleName.getModuleName()));
            configuration.getOut().println(this.$$("module.source", moduleName.resolveSource()));
            configuration.getOut().println(this.$$("module.automatic", this.$b(moduleName.isAutomatic())));
            configuration.getOut().println(this.$$("module.valid", this.$b(moduleName.isValid())));
            configuration.getOut().println(this.$$("module.reason", moduleName.getReason()));
            return;
        }
        ModuleDescriptor md = result.getResult().getModuleDescriptor().get();
        List<ModuleDescriptor.Exports> unqualifiedExports = md.exports().stream().sorted(Comparator.comparing(ModuleDescriptor.Exports::source)).filter(e -> !e.isQualified()).collect(Collectors.toList());
        List<ModuleDescriptor.Exports> qualifiedExports = md.exports().stream().sorted(Comparator.comparing(ModuleDescriptor.Exports::source)).filter(ModuleDescriptor.Exports::isQualified).collect(Collectors.toList());
        List<ModuleDescriptor.Opens> unqualifiedOpenPackages = md.opens().stream().sorted(Comparator.comparing(ModuleDescriptor.Opens::source)).filter(o -> !o.isQualified()).collect(Collectors.toList());
        List<ModuleDescriptor.Opens> qualifiedOpenPackages = md.opens().stream().sorted(Comparator.comparing(ModuleDescriptor.Opens::source)).filter(ModuleDescriptor.Opens::isQualified).collect(Collectors.toList());
        TreeSet<String> hiddenPackages = new TreeSet<String>(md.packages());
        md.exports().stream().map(ModuleDescriptor.Exports::source).forEach(hiddenPackages::remove);
        md.opens().stream().map(ModuleDescriptor.Opens::source).forEach(hiddenPackages::remove);
        configuration.getOut().println(this.$$("module.name", md.name()));
        md.version().ifPresent(v -> configuration.getOut().println(this.$$("module.version", v)));
        configuration.getOut().println(this.$$("module.open", this.$b(md.isOpen())));
        configuration.getOut().println(this.$$("module.automatic", this.$b(md.isAutomatic())));
        md.mainClass().ifPresent(c -> configuration.getOut().println(this.$$("module.main.class", c)));
        if (!unqualifiedExports.isEmpty()) {
            configuration.getOut().println(this.$$("module.exports", new Object[0]));
            unqualifiedExports.forEach(e -> configuration.getOut().println("  " + e.source() + Colorizer.magenta(this.toLowerCaseString(e.modifiers()))));
        }
        if (!md.requires().isEmpty()) {
            configuration.getOut().println(this.$$("module.requires", new Object[0]));
            md.requires().stream().sorted().forEach(r -> configuration.getOut().println("  " + r.name() + Colorizer.magenta(this.toLowerCaseString(r.modifiers()))));
        }
        if (!md.uses().isEmpty()) {
            configuration.getOut().println(this.$$("module.uses", new Object[0]));
            md.uses().stream().sorted().forEach(s -> configuration.getOut().println("  " + s));
        }
        if (!md.provides().isEmpty()) {
            configuration.getOut().println(this.$$("module.provides", new Object[0]));
            md.provides().stream().sorted(Comparator.comparing(ModuleDescriptor.Provides::service)).forEach(p -> configuration.getOut().println("  " + this.$$("module.provides.with", p.service(), this.toString(p.providers()))));
        }
        if (!qualifiedExports.isEmpty()) {
            configuration.getOut().println(this.$$("module.exports.qualified", new Object[0]));
            qualifiedExports.forEach(e -> configuration.getOut().println("  " + this.$$("module.exports.to", e.source(), this.toLowerCaseString(e.targets()))));
        }
        if (!unqualifiedOpenPackages.isEmpty()) {
            configuration.getOut().println(this.$$("module.opens", new Object[0]));
            unqualifiedOpenPackages.forEach(p -> configuration.getOut().println("  " + p.source() + Colorizer.magenta(this.toLowerCaseString(p.modifiers()))));
        }
        if (!qualifiedOpenPackages.isEmpty()) {
            configuration.getOut().println(this.$$("module.opens.qualified", new Object[0]));
            qualifiedOpenPackages.forEach(e -> configuration.getOut().println("  " + this.$$("module.opens.to", e.source(), this.toLowerCaseString(e.targets()))));
        }
        if (!hiddenPackages.isEmpty()) {
            configuration.getOut().println(this.$$("module.contains", new Object[0]));
            hiddenPackages.forEach(p -> configuration.getOut().println("  " + p));
        }
    }

    private void report(Configuration configuration, Set<JarProcessor.JarFileResult<ModuleMetadata>> results) {
        if (null == configuration.getReportPath()) {
            return;
        }
        for (Format format : configuration.getReportFormats()) {
            Node root = this.createRootNode();
            for (JarProcessor.JarFileResult<ModuleMetadata> result : results) {
                this.buildReport(format, root, result);
            }
            this.writeReport(configuration, this.resolveFormatter(format).write(root), format);
        }
    }

    private void buildReport(Format format, Node root, JarProcessor.JarFileResult<ModuleMetadata> result) {
        this.appendSubject(root, result.getJarPath(), "module descriptor", resultNode -> {
            ModuleName moduleName = ((ModuleMetadata)result.getResult()).getModuleName();
            if (!moduleName.isValid()) {
                resultNode.node(RB.$("report.key.name", new Object[0])).value(moduleName.getModuleName()).end().node(RB.$("report.key.source", new Object[0])).value(moduleName.resolveSource()).end().node(RB.$("report.key.automatic", new Object[0])).value(moduleName.isAutomatic()).end().node(RB.$("report.key.valid", new Object[0])).value(moduleName.isValid()).end().node(RB.$("report.key.reason", new Object[0])).value(moduleName.getReason()).end();
                return;
            }
            ModuleDescriptor md = ((ModuleMetadata)result.getResult()).getModuleDescriptor().get();
            Node module = resultNode.node(RB.$("report.key.module", new Object[0]));
            module.node(RB.$("report.key.name", new Object[0])).value(md.name()).end();
            md.version().ifPresent(v -> module.node(RB.$("report.key.version", new Object[0])).value(v).end());
            module.node(RB.$("report.key.open", new Object[0])).value(md.isOpen()).end();
            module.node(RB.$("report.key.automatic", new Object[0])).value(md.isAutomatic()).end();
            md.mainClass().ifPresent(c -> module.node(RB.$("report.key.main.class", new Object[0])).value(c).end());
            List<ModuleDescriptor.Exports> unqualifiedExports = md.exports().stream().sorted(Comparator.comparing(ModuleDescriptor.Exports::source)).filter(e -> !e.isQualified()).collect(Collectors.toList());
            List<ModuleDescriptor.Exports> qualifiedExports = md.exports().stream().sorted(Comparator.comparing(ModuleDescriptor.Exports::source)).filter(ModuleDescriptor.Exports::isQualified).collect(Collectors.toList());
            List<ModuleDescriptor.Opens> unqualifiedOpenPackages = md.opens().stream().sorted(Comparator.comparing(ModuleDescriptor.Opens::source)).filter(o -> !o.isQualified()).collect(Collectors.toList());
            List<ModuleDescriptor.Opens> qualifiedOpenPackages = md.opens().stream().sorted(Comparator.comparing(ModuleDescriptor.Opens::source)).filter(ModuleDescriptor.Opens::isQualified).collect(Collectors.toList());
            TreeSet<String> hiddenPackages = new TreeSet<String>(md.packages());
            md.exports().stream().map(ModuleDescriptor.Exports::source).forEach(hiddenPackages::remove);
            md.opens().stream().map(ModuleDescriptor.Opens::source).forEach(hiddenPackages::remove);
            if (!unqualifiedExports.isEmpty()) {
                Node exports = module.array(RB.$("report.key.exports", new Object[0]));
                unqualifiedExports.forEach(e -> {
                    if (format == Format.TXT) {
                        exports.node(e.source() + this.toLowerCaseString(e.modifiers())).end();
                    } else {
                        exports.collapsable(RB.$("report.key.export", new Object[0])).node(RB.$("report.key.package", new Object[0])).value(e.source()).end().node(RB.$("report.key.modifiers", new Object[0])).value(this.toLowerCaseString(e.modifiers())).end().cleanup();
                    }
                });
                exports.end();
            }
            if (!md.requires().isEmpty()) {
                Node requires = module.array(RB.$("report.key.requires", new Object[0]));
                md.requires().forEach(r -> {
                    if (format == Format.TXT) {
                        requires.node(r.name() + this.toLowerCaseString(r.modifiers())).end();
                    } else {
                        requires.collapsable(RB.$("report.key.require", new Object[0])).node(RB.$("report.key.module", new Object[0])).value(r.name()).end().node(RB.$("report.key.modifiers", new Object[0])).value(this.toLowerCaseString(r.modifiers())).end().cleanup();
                    }
                });
                requires.end();
            }
            if (!md.uses().isEmpty() || !md.provides().isEmpty()) {
                Node services = module.node(RB.$("report.key.services", new Object[0]));
                if (!md.uses().isEmpty()) {
                    Node requires = services.array(RB.$("report.key.uses", new Object[0]));
                    md.uses().forEach(s -> {
                        if (format == Format.TXT) {
                            requires.node((String)s).end();
                        } else {
                            requires.collapsable(RB.$("report.key.service", new Object[0])).value(s).end();
                        }
                    });
                    requires.end();
                }
                if (!md.provides().isEmpty()) {
                    Node provides = services.array(RB.$("report.key.provides", new Object[0]));
                    md.provides().stream().sorted(Comparator.comparing(ModuleDescriptor.Provides::service)).forEach(p -> {
                        if (format == Format.TXT) {
                            provides.node(p.service()).children(p.providers()).end();
                        } else {
                            provides.collapsable(RB.$("report.key.provider", new Object[0])).node(RB.$("report.key.service", new Object[0])).value(p.service()).end().array(RB.$("report.key.implementations", new Object[0])).collapsableChildren(RB.$("report.key.implementation", new Object[0]), p.providers()).end().cleanup();
                        }
                    });
                    provides.end();
                }
            }
            if (!unqualifiedOpenPackages.isEmpty()) {
                Node opens = module.array(RB.$("report.key.opens", new Object[0]));
                unqualifiedOpenPackages.forEach(e -> {
                    if (format == Format.TXT) {
                        opens.node(e.source() + this.toLowerCaseString(e.modifiers())).end();
                    } else {
                        opens.collapsable(RB.$("report.key.open", new Object[0])).node(RB.$("report.key.module", new Object[0])).value(e.source()).end().node(RB.$("report.key.modifiers", new Object[0])).value(this.toLowerCaseString(e.modifiers())).end().cleanup();
                    }
                });
                opens.end();
            }
            if (!qualifiedExports.isEmpty() || !qualifiedOpenPackages.isEmpty()) {
                Node exports;
                Node qualified = module.node(RB.$("report.key.qualified", new Object[0]));
                if (!qualifiedExports.isEmpty()) {
                    exports = qualified.array(RB.$("report.key.exports", new Object[0]));
                    qualifiedExports.forEach(e -> {
                        if (format == Format.TXT) {
                            exports.node(e.source()).children(e.targets()).end();
                        } else {
                            exports.collapsable(RB.$("report.key.export", new Object[0])).node(RB.$("report.key.package", new Object[0])).value(e.source()).end().array(RB.$("report.key.targets", new Object[0])).collapsableChildren(RB.$("report.key.target", new Object[0]), e.targets()).end().end();
                        }
                    });
                    exports.end();
                }
                if (!qualifiedOpenPackages.isEmpty()) {
                    exports = qualified.array(RB.$("report.key.opens", new Object[0]));
                    qualifiedOpenPackages.forEach(e -> {
                        if (format == Format.TXT) {
                            exports.node(e.source()).children(e.targets()).end();
                        } else {
                            exports.collapsable(RB.$("report.key.open", new Object[0])).node(RB.$("report.key.package", new Object[0])).value(e.source()).end().array(RB.$("report.key.targets", new Object[0])).collapsableChildren(RB.$("report.key.target", new Object[0]), e.targets()).end().end();
                        }
                    });
                    exports.end();
                }
            }
            if (!hiddenPackages.isEmpty()) {
                Node contains = module.array(RB.$("report.key.contains", new Object[0]));
                hiddenPackages.forEach(s -> {
                    if (format == Format.TXT) {
                        contains.node((String)s).end();
                    } else {
                        contains.collapsable(RB.$("report.key.package", new Object[0])).value(s).end();
                    }
                });
                contains.end();
            }
        });
    }

    private <T> String toLowerCaseString(Collection<T> set) {
        if (set.isEmpty()) {
            return "";
        }
        return " " + set.stream().map(e -> e.toString().toLowerCase(Locale.ROOT)).sorted().collect(Collectors.joining(" "));
    }

    private <T> String toString(Collection<T> set) {
        if (set.isEmpty()) {
            return "";
        }
        return " " + set.stream().map(Object::toString).sorted().collect(Collectors.joining(" "));
    }

    public static class Configuration
    extends AbstractConfiguration<Configuration> {
    }
}

