/*
 * Decompiled with CFR 0.152.
 */
package SQLite.JDBC2z;

import SQLite.Database;
import SQLite.JDBC2z.BatchArg;
import SQLite.JDBC2z.JDBCConnection;
import SQLite.JDBC2z.JDBCStatement;
import SQLite.StringEncoder;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.BatchUpdateException;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Map;

public class JDBCPreparedStatement
extends JDBCStatement
implements PreparedStatement {
    private String sql;
    private String[] args = null;
    private boolean[] blobs = null;
    private ArrayList<BatchArg> batch = null;
    private static final boolean nullrepl = Database.version().compareTo("2.5.0") < 0;

    public JDBCPreparedStatement(JDBCConnection jDBCConnection, String string) {
        super(jDBCConnection);
        this.sql = this.fixup(string);
    }

    private String fixup(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        int n = 0;
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == '\'') {
                if (bl) {
                    char c2 = '\u0000';
                    if (i + 1 < string.length()) {
                        c2 = string.charAt(i + 1);
                    }
                    if (c2 == '\'') {
                        stringBuffer.append(c);
                        stringBuffer.append(c2);
                        ++i;
                        continue;
                    }
                    bl = false;
                    stringBuffer.append(c);
                    continue;
                }
                bl = true;
                stringBuffer.append(c);
                continue;
            }
            if (c == '?') {
                if (bl) {
                    stringBuffer.append(c);
                    continue;
                }
                ++n;
                stringBuffer.append(nullrepl ? "'%q'" : "%Q");
                continue;
            }
            if (c == ';') {
                if (!bl) break;
                stringBuffer.append(c);
                continue;
            }
            if (c == '%') {
                stringBuffer.append("%%");
                continue;
            }
            stringBuffer.append(c);
        }
        this.args = new String[n];
        this.blobs = new boolean[n];
        try {
            this.clearParameters();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return stringBuffer.toString();
    }

    private String fixup2(String string) {
        if (!this.conn.db.is3()) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            int n2 = string.charAt(i);
            if (n2 == 37) {
                stringBuffer.append((char)n2);
                n2 = string.charAt(++i);
                if (n2 == 81 && this.blobs[++n]) {
                    n2 = 115;
                }
            }
            stringBuffer.append((char)n2);
        }
        return stringBuffer.toString();
    }

    @Override
    public ResultSet executeQuery() throws SQLException {
        return this.executeQuery(this.fixup2(this.sql), this.args, false);
    }

    @Override
    public int executeUpdate() throws SQLException {
        this.executeQuery(this.fixup2(this.sql), this.args, true);
        return this.updcnt;
    }

    @Override
    public void setNull(int n, int n2) throws SQLException {
        if (n < 1 || n > this.args.length) {
            throw new SQLException("bad parameter index");
        }
        this.args[n - 1] = nullrepl ? "" : null;
        this.blobs[n - 1] = false;
    }

    @Override
    public void setBoolean(int n, boolean bl) throws SQLException {
        if (n < 1 || n > this.args.length) {
            throw new SQLException("bad parameter index");
        }
        this.args[n - 1] = bl ? "1" : "0";
        this.blobs[n - 1] = false;
    }

    @Override
    public void setByte(int n, byte by) throws SQLException {
        if (n < 1 || n > this.args.length) {
            throw new SQLException("bad parameter index");
        }
        this.args[n - 1] = "" + by;
        this.blobs[n - 1] = false;
    }

    @Override
    public void setShort(int n, short s) throws SQLException {
        if (n < 1 || n > this.args.length) {
            throw new SQLException("bad parameter index");
        }
        this.args[n - 1] = "" + s;
        this.blobs[n - 1] = false;
    }

    @Override
    public void setInt(int n, int n2) throws SQLException {
        if (n < 1 || n > this.args.length) {
            throw new SQLException("bad parameter index");
        }
        this.args[n - 1] = "" + n2;
        this.blobs[n - 1] = false;
    }

    @Override
    public void setLong(int n, long l) throws SQLException {
        if (n < 1 || n > this.args.length) {
            throw new SQLException("bad parameter index");
        }
        this.args[n - 1] = "" + l;
        this.blobs[n - 1] = false;
    }

    @Override
    public void setFloat(int n, float f) throws SQLException {
        if (n < 1 || n > this.args.length) {
            throw new SQLException("bad parameter index");
        }
        this.args[n - 1] = "" + f;
        this.blobs[n - 1] = false;
    }

    @Override
    public void setDouble(int n, double d) throws SQLException {
        if (n < 1 || n > this.args.length) {
            throw new SQLException("bad parameter index");
        }
        this.args[n - 1] = "" + d;
        this.blobs[n - 1] = false;
    }

    @Override
    public void setBigDecimal(int n, BigDecimal bigDecimal) throws SQLException {
        if (n < 1 || n > this.args.length) {
            throw new SQLException("bad parameter index");
        }
        this.args[n - 1] = bigDecimal == null ? (nullrepl ? "" : null) : "" + bigDecimal;
        this.blobs[n - 1] = false;
    }

    @Override
    public void setString(int n, String string) throws SQLException {
        if (n < 1 || n > this.args.length) {
            throw new SQLException("bad parameter index");
        }
        this.args[n - 1] = string == null ? (nullrepl ? "" : null) : string;
        this.blobs[n - 1] = false;
    }

    @Override
    public void setBytes(int n, byte[] byArray) throws SQLException {
        if (n < 1 || n > this.args.length) {
            throw new SQLException("bad parameter index");
        }
        this.blobs[n - 1] = false;
        if (byArray == null) {
            this.args[n - 1] = nullrepl ? "" : null;
        } else if (this.conn.db.is3()) {
            this.args[n - 1] = StringEncoder.encodeX(byArray);
            this.blobs[n - 1] = true;
        } else {
            this.args[n - 1] = StringEncoder.encode(byArray);
        }
    }

    @Override
    public void setDate(int n, Date date) throws SQLException {
        if (n < 1 || n > this.args.length) {
            throw new SQLException("bad parameter index");
        }
        this.args[n - 1] = date == null ? (nullrepl ? "" : null) : (this.conn.useJulian ? Double.toString(Database.julian_from_long(date.getTime())) : date.toString());
        this.blobs[n - 1] = false;
    }

    @Override
    public void setTime(int n, Time time) throws SQLException {
        if (n < 1 || n > this.args.length) {
            throw new SQLException("bad parameter index");
        }
        this.args[n - 1] = time == null ? (nullrepl ? "" : null) : (this.conn.useJulian ? Double.toString(Database.julian_from_long(time.getTime())) : time.toString());
        this.blobs[n - 1] = false;
    }

    @Override
    public void setTimestamp(int n, Timestamp timestamp) throws SQLException {
        if (n < 1 || n > this.args.length) {
            throw new SQLException("bad parameter index");
        }
        this.args[n - 1] = timestamp == null ? (nullrepl ? "" : null) : (this.conn.useJulian ? Double.toString(Database.julian_from_long(timestamp.getTime())) : timestamp.toString());
        this.blobs[n - 1] = false;
    }

    @Override
    public void setAsciiStream(int n, InputStream inputStream, int n2) throws SQLException {
        throw new SQLException("not supported");
    }

    @Override
    @Deprecated
    public void setUnicodeStream(int n, InputStream inputStream, int n2) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setBinaryStream(int n, InputStream inputStream, int n2) throws SQLException {
        try {
            byte[] byArray = new byte[n2];
            inputStream.read(byArray, 0, n2);
            this.setBytes(n, byArray);
        }
        catch (IOException iOException) {
            throw new SQLException("I/O failed");
        }
    }

    @Override
    public void clearParameters() throws SQLException {
        for (int i = 0; i < this.args.length; ++i) {
            this.args[i] = nullrepl ? "" : null;
            this.blobs[i] = false;
        }
    }

    @Override
    public void setObject(int n, Object object, int n2, int n3) throws SQLException {
        if (n < 1 || n > this.args.length) {
            throw new SQLException("bad parameter index");
        }
        if (object == null) {
            this.args[n - 1] = nullrepl ? "" : null;
        } else if (object instanceof byte[]) {
            byte[] byArray = (byte[])object;
            if (this.conn.db.is3()) {
                this.args[n - 1] = StringEncoder.encodeX(byArray);
                this.blobs[n - 1] = true;
                return;
            }
            this.args[n - 1] = StringEncoder.encode(byArray);
        } else {
            this.args[n - 1] = object.toString();
        }
        this.blobs[n - 1] = false;
    }

    @Override
    public void setObject(int n, Object object, int n2) throws SQLException {
        if (n < 1 || n > this.args.length) {
            throw new SQLException("bad parameter index");
        }
        if (object == null) {
            this.args[n - 1] = nullrepl ? "" : null;
        } else if (object instanceof byte[]) {
            byte[] byArray = (byte[])object;
            if (this.conn.db.is3()) {
                this.args[n - 1] = StringEncoder.encodeX(byArray);
                this.blobs[n - 1] = true;
                return;
            }
            this.args[n - 1] = StringEncoder.encode(byArray);
        } else {
            this.args[n - 1] = object.toString();
        }
        this.blobs[n - 1] = false;
    }

    @Override
    public void setObject(int n, Object object) throws SQLException {
        if (n < 1 || n > this.args.length) {
            throw new SQLException("bad parameter index");
        }
        if (object == null) {
            this.args[n - 1] = nullrepl ? "" : null;
        } else if (object instanceof byte[]) {
            byte[] byArray = (byte[])object;
            if (this.conn.db.is3()) {
                this.args[n - 1] = StringEncoder.encodeX(byArray);
                this.blobs[n - 1] = true;
                return;
            }
            this.args[n - 1] = StringEncoder.encode(byArray);
        } else {
            this.args[n - 1] = object.toString();
        }
        this.blobs[n - 1] = false;
    }

    @Override
    public boolean execute() throws SQLException {
        return this.executeQuery(this.fixup2(this.sql), this.args, false) != null;
    }

    @Override
    public void addBatch() throws SQLException {
        if (this.batch == null) {
            this.batch = new ArrayList(this.args.length);
        }
        for (int i = 0; i < this.args.length; ++i) {
            this.batch.add(new BatchArg(this.args[i], this.blobs[i]));
        }
    }

    @Override
    public int[] executeBatch() throws SQLException {
        int n;
        if (this.batch == null) {
            return new int[0];
        }
        int[] nArray = new int[this.batch.size() / this.args.length];
        for (n = 0; n < nArray.length; ++n) {
            nArray[n] = -3;
        }
        n = 0;
        int n2 = 0;
        for (int i = 0; i < nArray.length; ++i) {
            for (int j = 0; j < this.args.length; ++j) {
                BatchArg batchArg = this.batch.get(n2++);
                this.args[j] = batchArg.arg;
                this.blobs[j] = batchArg.blob;
            }
            try {
                nArray[i] = this.executeUpdate();
                continue;
            }
            catch (SQLException sQLException) {
                ++n;
            }
        }
        if (n > 0) {
            throw new BatchUpdateException("batch failed", nArray);
        }
        return nArray;
    }

    @Override
    public void clearBatch() throws SQLException {
        if (this.batch != null) {
            this.batch.clear();
            this.batch = null;
        }
    }

    @Override
    public void close() throws SQLException {
        this.clearBatch();
        super.close();
    }

    @Override
    public void setCharacterStream(int n, Reader reader, int n2) throws SQLException {
        try {
            char[] cArray = new char[n2];
            reader.read(cArray);
            this.setString(n, new String(cArray));
        }
        catch (IOException iOException) {
            throw new SQLException("I/O failed");
        }
    }

    @Override
    public void setRef(int n, Ref ref) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setBlob(int n, Blob blob) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setClob(int n, Clob clob) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setArray(int n, Array array) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        return this.rs.getMetaData();
    }

    @Override
    public void setDate(int n, Date date, Calendar calendar) throws SQLException {
        this.setDate(n, date);
    }

    @Override
    public void setTime(int n, Time time, Calendar calendar) throws SQLException {
        this.setTime(n, time);
    }

    @Override
    public void setTimestamp(int n, Timestamp timestamp, Calendar calendar) throws SQLException {
        this.setTimestamp(n, timestamp);
    }

    @Override
    public void setNull(int n, int n2, String string) throws SQLException {
        this.setNull(n, n2);
    }

    @Override
    public ParameterMetaData getParameterMetaData() throws SQLException {
        throw new SQLException("not supported");
    }

    public void registerOutputParameter(String string, int n) throws SQLException {
        throw new SQLException("not supported");
    }

    public void registerOutputParameter(String string, int n, int n2) throws SQLException {
        throw new SQLException("not supported");
    }

    public void registerOutputParameter(String string, int n, String string2) throws SQLException {
        throw new SQLException("not supported");
    }

    public URL getURL(int n) throws SQLException {
        throw new SQLException("not supported");
    }

    @Override
    public void setURL(int n, URL uRL) throws SQLException {
        throw new SQLException("not supported");
    }

    public void setNull(String string, int n) throws SQLException {
        throw new SQLException("not supported");
    }

    public void setBoolean(String string, boolean bl) throws SQLException {
        throw new SQLException("not supported");
    }

    public void setByte(String string, byte by) throws SQLException {
        throw new SQLException("not supported");
    }

    public void setShort(String string, short s) throws SQLException {
        throw new SQLException("not supported");
    }

    public void setInt(String string, int n) throws SQLException {
        throw new SQLException("not supported");
    }

    public void setLong(String string, long l) throws SQLException {
        throw new SQLException("not supported");
    }

    public void setFloat(String string, float f) throws SQLException {
        throw new SQLException("not supported");
    }

    public void setDouble(String string, double d) throws SQLException {
        throw new SQLException("not supported");
    }

    public void setBigDecimal(String string, BigDecimal bigDecimal) throws SQLException {
        throw new SQLException("not supported");
    }

    public void setString(String string, String string2) throws SQLException {
        throw new SQLException("not supported");
    }

    public void setBytes(String string, byte[] byArray) throws SQLException {
        throw new SQLException("not supported");
    }

    public void setDate(String string, Date date) throws SQLException {
        throw new SQLException("not supported");
    }

    public void setTime(String string, Time time) throws SQLException {
        throw new SQLException("not supported");
    }

    public void setTimestamp(String string, Timestamp timestamp) throws SQLException {
        throw new SQLException("not supported");
    }

    public void setAsciiStream(String string, InputStream inputStream, int n) throws SQLException {
        throw new SQLException("not supported");
    }

    public void setBinaryStream(String string, InputStream inputStream, int n) throws SQLException {
        throw new SQLException("not supported");
    }

    public void setObject(String string, Object object, int n, int n2) throws SQLException {
        throw new SQLException("not supported");
    }

    public void setObject(String string, Object object, int n) throws SQLException {
        throw new SQLException("not supported");
    }

    public void setObject(String string, Object object) throws SQLException {
        throw new SQLException("not supported");
    }

    public void setCharacterStream(String string, Reader reader, int n) throws SQLException {
        throw new SQLException("not supported");
    }

    public void setDate(String string, Date date, Calendar calendar) throws SQLException {
        throw new SQLException("not supported");
    }

    public void setTime(String string, Time time, Calendar calendar) throws SQLException {
        throw new SQLException("not supported");
    }

    public void setTimestamp(String string, Timestamp timestamp, Calendar calendar) throws SQLException {
        throw new SQLException("not supported");
    }

    public void setNull(String string, int n, String string2) throws SQLException {
        throw new SQLException("not supported");
    }

    public String getString(String string) throws SQLException {
        throw new SQLException("not supported");
    }

    public boolean getBoolean(String string) throws SQLException {
        throw new SQLException("not supported");
    }

    public byte getByte(String string) throws SQLException {
        throw new SQLException("not supported");
    }

    public short getShort(String string) throws SQLException {
        throw new SQLException("not supported");
    }

    public int getInt(String string) throws SQLException {
        throw new SQLException("not supported");
    }

    public long getLong(String string) throws SQLException {
        throw new SQLException("not supported");
    }

    public float getFloat(String string) throws SQLException {
        throw new SQLException("not supported");
    }

    public double getDouble(String string) throws SQLException {
        throw new SQLException("not supported");
    }

    public byte[] getBytes(String string) throws SQLException {
        throw new SQLException("not supported");
    }

    public Date getDate(String string) throws SQLException {
        throw new SQLException("not supported");
    }

    public Time getTime(String string) throws SQLException {
        throw new SQLException("not supported");
    }

    public Timestamp getTimestamp(String string) throws SQLException {
        throw new SQLException("not supported");
    }

    public Object getObject(String string) throws SQLException {
        throw new SQLException("not supported");
    }

    public Object getObject(int n) throws SQLException {
        throw new SQLException("not supported");
    }

    public BigDecimal getBigDecimal(String string) throws SQLException {
        throw new SQLException("not supported");
    }

    public Object getObject(String string, Map map) throws SQLException {
        throw new SQLException("not supported");
    }

    public Object getObject(int n, Map map) throws SQLException {
        throw new SQLException("not supported");
    }

    public Ref getRef(int n) throws SQLException {
        throw new SQLException("not supported");
    }

    public Ref getRef(String string) throws SQLException {
        throw new SQLException("not supported");
    }

    public Blob getBlob(String string) throws SQLException {
        throw new SQLException("not supported");
    }

    public Blob getBlob(int n) throws SQLException {
        throw new SQLException("not supported");
    }

    public Clob getClob(String string) throws SQLException {
        throw new SQLException("not supported");
    }

    public Clob getClob(int n) throws SQLException {
        throw new SQLException("not supported");
    }

    public Array getArray(String string) throws SQLException {
        throw new SQLException("not supported");
    }

    public Array getArray(int n) throws SQLException {
        throw new SQLException("not supported");
    }

    public Date getDate(String string, Calendar calendar) throws SQLException {
        throw new SQLException("not supported");
    }

    public Date getDate(int n, Calendar calendar) throws SQLException {
        throw new SQLException("not supported");
    }

    public Time getTime(String string, Calendar calendar) throws SQLException {
        throw new SQLException("not supported");
    }

    public Time getTime(int n, Calendar calendar) throws SQLException {
        throw new SQLException("not supported");
    }

    public Timestamp getTimestamp(String string, Calendar calendar) throws SQLException {
        throw new SQLException("not supported");
    }

    public Timestamp getTimestamp(int n, Calendar calendar) throws SQLException {
        throw new SQLException("not supported");
    }

    public URL getURL(String string) throws SQLException {
        throw new SQLException("not supported");
    }

    @Override
    public void setRowId(int n, RowId rowId) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    public void setRowId(String string, RowId rowId) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setNString(int n, String string) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    public void setNString(String string, String string2) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setNCharacterStream(int n, Reader reader, long l) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    public void setNCharacterStream(String string, Reader reader, long l) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setNClob(int n, NClob nClob) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    public void setNClob(String string, NClob nClob) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setClob(int n, Reader reader, long l) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    public void setClob(String string, Reader reader, long l) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setBlob(int n, InputStream inputStream, long l) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    public void setBlob(String string, InputStream inputStream, long l) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setNClob(int n, Reader reader, long l) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    public void setNClob(String string, Reader reader, long l) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setSQLXML(int n, SQLXML sQLXML) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    public void setSQLXML(String string, SQLXML sQLXML) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setAsciiStream(int n, InputStream inputStream, long l) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    public void setAsciiStream(String string, InputStream inputStream, long l) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setBinaryStream(int n, InputStream inputStream, long l) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    public void setBinaryStream(String string, InputStream inputStream, long l) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setCharacterStream(int n, Reader reader, long l) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    public void setCharacterStream(String string, Reader reader, long l) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setAsciiStream(int n, InputStream inputStream) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    public void setAsciiStream(String string, InputStream inputStream) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setBinaryStream(int n, InputStream inputStream) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    public void setBinaryStream(String string, InputStream inputStream) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setCharacterStream(int n, Reader reader) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    public void setCharacterStream(String string, Reader reader) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setNCharacterStream(int n, Reader reader) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    public void setNCharacterStream(String string, Reader reader) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setClob(int n, Reader reader) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    public void setClob(String string, Reader reader) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setBlob(int n, InputStream inputStream) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    public void setBlob(String string, InputStream inputStream) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setNClob(int n, Reader reader) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    public void setNClob(String string, Reader reader) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }
}

