/*
 * Decompiled with CFR 0.152.
 */
package SQLite.JDBC2z;

import SQLite.BusyHandler;
import SQLite.Database;
import SQLite.Exception;
import SQLite.JDBC2z.DatabaseX;
import SQLite.JDBC2z.JDBCDatabaseMetaData;
import SQLite.JDBC2z.JDBCPreparedStatement;
import SQLite.JDBC2z.JDBCStatement;
import SQLite.JDBCDriver;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Struct;
import java.util.Map;
import java.util.Properties;

public class JDBCConnection
implements Connection,
BusyHandler {
    protected DatabaseX db;
    protected String url;
    protected String enc;
    protected String vfs;
    protected boolean autocommit = true;
    protected boolean intrans = false;
    protected int timeout = 1000000;
    protected boolean useJulian = false;
    private String dbfile = null;
    private JDBCDatabaseMetaData meta = null;
    private long t0;
    private boolean readonly = false;
    private int trmode = 8;

    private boolean busy0(DatabaseX databaseX, int n) {
        if (n <= 1) {
            this.t0 = System.currentTimeMillis();
        }
        if (databaseX != null) {
            long l = System.currentTimeMillis();
            if (l - this.t0 > (long)this.timeout) {
                return false;
            }
            databaseX.wait(100);
            return true;
        }
        return false;
    }

    @Override
    public boolean busy(String string, int n) {
        return this.busy0(this.db, n);
    }

    protected boolean busy3(DatabaseX databaseX, int n) {
        if (n <= 1) {
            this.t0 = System.currentTimeMillis();
        }
        if (databaseX != null) {
            long l = System.currentTimeMillis();
            return l - this.t0 <= (long)this.timeout;
        }
        return false;
    }

    private DatabaseX open(boolean bl) throws SQLException {
        DatabaseX databaseX = null;
        try {
            databaseX = new DatabaseX();
            databaseX.open(this.dbfile, bl ? 1 : 6, this.vfs);
            databaseX.set_encoding(this.enc);
        }
        catch (Exception exception) {
            throw new SQLException(exception.toString());
        }
        int n = 0;
        while (true) {
            try {
                databaseX.exec("PRAGMA short_column_names = off;", null);
                databaseX.exec("PRAGMA full_column_names = on;", null);
                databaseX.exec("PRAGMA empty_result_callbacks = on;", null);
                if (Database.version().compareTo("2.6.0") < 0) break;
                databaseX.exec("PRAGMA show_datatypes = on;", null);
            }
            catch (Exception exception) {
                if (databaseX.last_error() == 5 && this.busy0(databaseX, ++n)) continue;
                try {
                    databaseX.close();
                }
                catch (Exception exception2) {
                    // empty catch block
                }
                throw new SQLException(exception.toString());
            }
            break;
        }
        return databaseX;
    }

    public JDBCConnection(String string, String string2, String string3, String string4, String string5) throws SQLException {
        if (string.startsWith("sqlite:/")) {
            this.dbfile = string.substring(8);
        } else if (string.startsWith("jdbc:sqlite:/")) {
            this.dbfile = string.substring(13);
        } else {
            throw new SQLException("unsupported url");
        }
        this.url = string;
        this.enc = string2;
        this.vfs = string5;
        try {
            this.db = this.open(this.readonly);
            try {
                if (string3 != null && string3.length() > 0) {
                    this.db.key(string3);
                }
            }
            catch (Exception exception) {
                throw new SQLException("error while setting key");
            }
            this.db.busy_handler(this);
        }
        catch (SQLException sQLException) {
            if (this.db != null) {
                try {
                    this.db.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            throw sQLException;
        }
        this.useJulian = string4 != null && (string4.startsWith("j") || string4.startsWith("J"));
    }

    public Database getSQLiteDatabase() {
        return this.db;
    }

    @Override
    public Statement createStatement() {
        JDBCStatement jDBCStatement = new JDBCStatement(this);
        return jDBCStatement;
    }

    @Override
    public Statement createStatement(int n, int n2) throws SQLException {
        if (n != 1003 && n != 1004 && n != 1005) {
            throw new SQLFeatureNotSupportedException("unsupported result set type");
        }
        if (n2 != 1007 && n2 != 1008) {
            throw new SQLFeatureNotSupportedException("unsupported result set concurrency");
        }
        JDBCStatement jDBCStatement = new JDBCStatement(this);
        return jDBCStatement;
    }

    @Override
    public DatabaseMetaData getMetaData() throws SQLException {
        if (this.meta == null) {
            this.meta = new JDBCDatabaseMetaData(this);
        }
        return this.meta;
    }

    @Override
    public void close() throws SQLException {
        try {
            this.rollback();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        this.intrans = false;
        if (this.db != null) {
            try {
                this.db.close();
                this.db = null;
            }
            catch (Exception exception) {
                throw new SQLException(exception.toString());
            }
        }
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.db == null;
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        return this.readonly;
    }

    @Override
    public void clearWarnings() throws SQLException {
    }

    @Override
    public void commit() throws SQLException {
        if (this.db == null) {
            throw new SQLException("stale connection");
        }
        if (!this.intrans) {
            return;
        }
        try {
            this.db.exec("COMMIT", null);
            this.intrans = false;
        }
        catch (Exception exception) {
            throw new SQLException(exception.toString());
        }
    }

    @Override
    public boolean getAutoCommit() throws SQLException {
        return this.autocommit;
    }

    @Override
    public String getCatalog() throws SQLException {
        return null;
    }

    @Override
    public int getTransactionIsolation() throws SQLException {
        return this.trmode;
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        return null;
    }

    @Override
    public String nativeSQL(String string) throws SQLException {
        throw new SQLException("not supported");
    }

    @Override
    public CallableStatement prepareCall(String string) throws SQLException {
        throw new SQLException("not supported");
    }

    @Override
    public CallableStatement prepareCall(String string, int n, int n2) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public PreparedStatement prepareStatement(String string) throws SQLException {
        JDBCPreparedStatement jDBCPreparedStatement = new JDBCPreparedStatement(this, string);
        return jDBCPreparedStatement;
    }

    @Override
    public PreparedStatement prepareStatement(String string, int n, int n2) throws SQLException {
        if (n != 1003 && n != 1004 && n != 1005) {
            throw new SQLFeatureNotSupportedException("unsupported result set type");
        }
        if (n2 != 1007 && n2 != 1008) {
            throw new SQLFeatureNotSupportedException("unsupported result set concurrency");
        }
        JDBCPreparedStatement jDBCPreparedStatement = new JDBCPreparedStatement(this, string);
        return jDBCPreparedStatement;
    }

    @Override
    public void rollback() throws SQLException {
        if (this.db == null) {
            throw new SQLException("stale connection");
        }
        if (!this.intrans) {
            return;
        }
        try {
            this.db.exec("ROLLBACK", null);
            this.intrans = false;
        }
        catch (Exception exception) {
            throw new SQLException(exception.toString());
        }
    }

    @Override
    public void setAutoCommit(boolean bl) throws SQLException {
        if (bl && this.intrans && this.db != null) {
            try {
                this.db.exec("ROLLBACK", null);
            }
            catch (Exception exception) {
                throw new SQLException(exception.toString());
            }
            finally {
                this.intrans = false;
            }
        }
        this.autocommit = bl;
    }

    @Override
    public void setCatalog(String string) throws SQLException {
    }

    @Override
    public void setReadOnly(boolean bl) throws SQLException {
        if (this.intrans) {
            throw new SQLException("incomplete transaction");
        }
        if (bl != this.readonly) {
            DatabaseX databaseX = null;
            try {
                databaseX = this.open(bl);
                this.db.close();
                this.db = databaseX;
                databaseX = null;
                this.readonly = bl;
            }
            catch (SQLException sQLException) {
                throw sQLException;
            }
            catch (Exception exception) {
                if (databaseX != null) {
                    try {
                        databaseX.close();
                    }
                    catch (Exception exception2) {
                        // empty catch block
                    }
                }
                throw new SQLException(exception.toString());
            }
        }
    }

    @Override
    public void setTransactionIsolation(int n) throws SQLException {
        if (this.db.is3() && JDBCDriver.sharedCache) {
            String string = null;
            if (n == 1 && this.trmode != 1) {
                string = "on";
            } else if (n == 8 && this.trmode != 8) {
                string = "off";
            }
            if (string != null) {
                try {
                    this.db.exec("PRAGMA read_uncommitted = " + string + ";", null);
                    this.trmode = n;
                }
                catch (java.lang.Exception exception) {
                    // empty catch block
                }
            }
        }
        if (n != this.trmode) {
            throw new SQLException("not supported");
        }
    }

    @Override
    public Map<String, Class<?>> getTypeMap() throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    public void setTypeMap(Map map) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public int getHoldability() throws SQLException {
        return 1;
    }

    @Override
    public void setHoldability(int n) throws SQLException {
        if (n == 1) {
            return;
        }
        throw new SQLFeatureNotSupportedException("unsupported holdability");
    }

    @Override
    public Savepoint setSavepoint() throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public Savepoint setSavepoint(String string) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void rollback(Savepoint savepoint) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public Statement createStatement(int n, int n2, int n3) throws SQLException {
        if (n3 != 1) {
            throw new SQLFeatureNotSupportedException("unsupported holdability");
        }
        return this.createStatement(n, n2);
    }

    @Override
    public PreparedStatement prepareStatement(String string, int n, int n2, int n3) throws SQLException {
        if (n3 != 1) {
            throw new SQLFeatureNotSupportedException("unsupported holdability");
        }
        return this.prepareStatement(string, n, n2);
    }

    @Override
    public CallableStatement prepareCall(String string, int n, int n2, int n3) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public PreparedStatement prepareStatement(String string, int n) throws SQLException {
        if (n != 2) {
            throw new SQLFeatureNotSupportedException("generated keys not supported");
        }
        return this.prepareStatement(string);
    }

    @Override
    public PreparedStatement prepareStatement(String string, int[] nArray) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public PreparedStatement prepareStatement(String string, String[] stringArray) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public Clob createClob() throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public Blob createBlob() throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public NClob createNClob() throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public SQLXML createSQLXML() throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public boolean isValid(int n) throws SQLException {
        return true;
    }

    @Override
    public void setClientInfo(String string, String string2) throws SQLClientInfoException {
        throw new SQLClientInfoException();
    }

    @Override
    public void setClientInfo(Properties properties) throws SQLClientInfoException {
        throw new SQLClientInfoException();
    }

    @Override
    public String getClientInfo(String string) throws SQLException {
        throw new SQLException("unsupported");
    }

    @Override
    public Properties getClientInfo() throws SQLException {
        return new Properties();
    }

    @Override
    public Array createArrayOf(String string, Object[] objectArray) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public Struct createStruct(String string, Object[] objectArray) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public <T> T unwrap(Class<T> clazz) throws SQLException {
        throw new SQLException("unsupported");
    }

    public boolean isWrapperFor(Class clazz) throws SQLException {
        return false;
    }
}

