/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.protocols.icmp;

import org.opennms.protocols.icmp.ICMPHeader;
import org.opennms.protocols.ip.OC16ChecksumProducer;

public final class AddressMaskReply
extends ICMPHeader {
    private int m_mask;

    public AddressMaskReply() {
        super((byte)18, (byte)0);
        this.m_mask = 0;
    }

    public AddressMaskReply(byte[] byArray, int n) {
        this.loadFromBuffer(byArray, n);
    }

    public final void computeChecksum() {
        OC16ChecksumProducer oC16ChecksumProducer = new OC16ChecksumProducer();
        super.computeChecksum(oC16ChecksumProducer);
        oC16ChecksumProducer.add(this.m_mask);
        this.setChecksum(oC16ChecksumProducer.getChecksum());
    }

    public final int storeToBuffer(byte[] byArray, int n) {
        if (byArray.length < n + 12) {
            throw new IndexOutOfBoundsException("Array index overflow in buffer build");
        }
        this.computeChecksum();
        n = super.storeToBuffer(byArray, n);
        byArray[n++] = (byte)(this.m_mask >> 24 & 0xFF);
        byArray[n++] = (byte)(this.m_mask >> 16 & 0xFF);
        byArray[n++] = (byte)(this.m_mask >> 8 & 0xFF);
        byArray[n++] = (byte)(this.m_mask & 0xFF);
        return n;
    }

    public final int loadFromBuffer(byte[] byArray, int n) {
        if (byArray.length < n + 12) {
            throw new IndexOutOfBoundsException("Insufficient data to load ICMP header");
        }
        n = super.loadFromBuffer(byArray, n);
        if (this.getType() != 18) {
            throw new IllegalArgumentException("The buffer did not contain an Address Mask Reply");
        }
        this.m_mask = AddressMaskReply.byteToInt(byArray[n++]) << 24 | AddressMaskReply.byteToInt(byArray[n++]) << 16 | AddressMaskReply.byteToInt(byArray[n++]) << 8 | AddressMaskReply.byteToInt(byArray[n++]);
        return n;
    }

    public final int getAddressMask() {
        return this.m_mask;
    }

    public final void setAddressMask(int n) {
        this.m_mask = n;
    }

    public final byte[] toBytes() {
        byte[] byArray = new byte[12];
        this.storeToBuffer(byArray, 0);
        return byArray;
    }
}

