/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.protocols.icmp;

import org.opennms.protocols.icmp.ICMPHeader;
import org.opennms.protocols.ip.OC16ChecksumProducer;

public final class AddressMaskRequest
extends ICMPHeader {
    public AddressMaskRequest() {
        super((byte)17, (byte)0);
    }

    public AddressMaskRequest(byte[] byArray, int n) {
        this.loadFromBuffer(byArray, n);
    }

    public final void computeChecksum() {
        OC16ChecksumProducer oC16ChecksumProducer = new OC16ChecksumProducer();
        super.computeChecksum(oC16ChecksumProducer);
        oC16ChecksumProducer.add(0);
        this.setChecksum(oC16ChecksumProducer.getChecksum());
    }

    public final int storeToBuffer(byte[] byArray, int n) {
        if (byArray.length < n + 12) {
            throw new IndexOutOfBoundsException("Array index overflow in buffer build");
        }
        this.computeChecksum();
        n = super.storeToBuffer(byArray, n);
        for (int i = 0; i < 4; ++i) {
            byArray[n++] = 0;
        }
        return n;
    }

    public final int loadFromBuffer(byte[] byArray, int n) {
        if (byArray.length < n + 12) {
            throw new IndexOutOfBoundsException("Insufficient data to load ICMP header");
        }
        n = super.loadFromBuffer(byArray, n);
        if (this.getType() != 17) {
            throw new IllegalArgumentException("The buffer did not contain an Address Mask Request");
        }
        return n += 4;
    }

    public final byte[] toBytes() {
        byte[] byArray = new byte[12];
        this.storeToBuffer(byArray, 0);
        return byArray;
    }
}

