/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.protocols.icmp;

import java.util.Date;
import java.util.Random;
import org.opennms.protocols.ip.OC16ChecksumProducer;

public class ICMPHeader {
    public static final byte TYPE_ECHO_REPLY = 0;
    public static final byte TYPE_DESTINATION_UNREACHABLE = 3;
    public static final byte CODE_NETWORK_UNREACHABLE = 0;
    public static final byte CODE_HOST_UNREACHABLE = 1;
    public static final byte CODE_PROTOCOL_UNREACHABLE = 2;
    public static final byte CODE_PORT_UNREACHABLE = 3;
    public static final byte CODE_FRAGMENTATION_NEEDED = 4;
    public static final byte CODE_SOURCE_ROUTE_FAILED = 5;
    public static final byte CODE_DESTINATION_NETWORK_UNKNOWN = 6;
    public static final byte CODE_DESTINATION_HOST_UNKNOWN = 7;
    public static final byte CODE_SOURCE_HOST_ISOLATED = 8;
    public static final byte CODE_DESTINATION_NETWORK_ADMIN_PROHIBITED = 9;
    public static final byte CODE_DESTINATION_HOST_ADMIN_PROHIBITED = 10;
    public static final byte CODE_NETWORK_UNREACHABLE_FOR_TOS = 11;
    public static final byte CODE_HOST_UNREACHABLE_FOR_TOS = 12;
    public static final byte CODE_COMMUNICATIONS_ADMIN_PROHIBITIED = 13;
    public static final byte CODE_HOST_PRECEDENCE_VIOLATION = 14;
    public static final byte CODE_PRECEDENCE_CUTOFF_IN_EFFECT = 15;
    public static final byte TYPE_SOURCE_QUENCH = 4;
    public static final byte TYPE_REDIRECT = 5;
    public static final byte CODE_REDIRECT_FOR_NETWORK = 0;
    public static final byte CODE_REDIRECT_FOR_HOST = 1;
    public static final byte CODE_REDIRECT_FOR_TYPE_OF_SERVICE_AND_NETWORK = 2;
    public static final byte CODE_REDIRECT_FOR_TYPE_OF_SERVICE_AND_HOST = 3;
    public static final byte TYPE_ECHO_REQUEST = 8;
    public static final byte TYPE_ROUTER_ADVERTISEMENT = 9;
    public static final byte TYPE_ROUTER_SOLICITATION = 10;
    public static final byte TYPE_TIME_EXCEEDED = 11;
    public static final byte CODE_TTL_EQ_ZERO_IN_TRANSIT = 0;
    public static final byte CODE_TTL_EQ_ZERO_IN_REASSEMBLY = 1;
    public static final byte TYPE_PARAMETER_PROBLEM = 12;
    public static final byte CODE_BAD_IP_HEADER = 0;
    public static final byte CODE_REQUIRED_OPTION_MISSING = 1;
    public static final byte TYPE_TIMESTAMP_REQUEST = 13;
    public static final byte TYPE_TIMESTAMP_REPLY = 14;
    public static final byte TYPE_INFORMATION_REQUEST = 15;
    public static final byte TYPE_INFORMATION_REPLY = 16;
    public static final byte TYPE_ADDRESS_MASK_REQUEST = 17;
    public static final byte TYPE_ADDRESS_MASK_REPLY = 18;
    private byte m_type;
    private byte m_code;
    private short m_checksum;
    private short m_ident;
    private short m_sequence;
    private static short sm_seq = 0;

    public static final synchronized short nextSequenceId() {
        if (sm_seq == 0) {
            Date date = new Date();
            Random random = new Random(date.getTime());
            sm_seq = (short)random.nextInt();
        }
        sm_seq = (short)(sm_seq + 1);
        return sm_seq;
    }

    protected static short byteToShort(byte by) {
        short s = by;
        if (s < 0) {
            s = (short)(s + 256);
        }
        return s;
    }

    protected static int byteToInt(byte n) {
        int n2 = n;
        if (n2 < 0) {
            n2 += 256;
        }
        return n2;
    }

    public ICMPHeader() {
        this.m_type = 0;
        this.m_code = 0;
        this.m_checksum = 0;
        this.m_ident = 0;
        this.m_sequence = 0;
    }

    public ICMPHeader(byte by) {
        this();
        this.m_type = by;
    }

    public ICMPHeader(byte by, byte by2) {
        this(by);
        this.m_code = by2;
    }

    public ICMPHeader(byte by, byte by2, short s, short s2, short s3) {
        this.m_type = by;
        this.m_code = by2;
        this.m_checksum = s;
        this.m_ident = s2;
        this.m_sequence = s3;
    }

    public ICMPHeader(ICMPHeader iCMPHeader) {
        this.m_type = iCMPHeader.m_type;
        this.m_code = iCMPHeader.m_code;
        this.m_checksum = iCMPHeader.m_checksum;
        this.m_sequence = iCMPHeader.m_sequence;
        this.m_ident = iCMPHeader.m_ident;
    }

    public ICMPHeader(byte[] byArray, int n) {
        if (byArray.length - n < ICMPHeader.getNetworkSize()) {
            throw new IndexOutOfBoundsException("Insufficient number of bytes available to construct the ICMP header");
        }
        this.m_type = byArray[n++];
        this.m_code = byArray[n++];
        this.m_checksum = (short)(ICMPHeader.byteToShort(byArray[n++]) << 8 | ICMPHeader.byteToShort(byArray[n++]));
        this.m_sequence = (short)(ICMPHeader.byteToShort(byArray[n++]) << 8 | ICMPHeader.byteToShort(byArray[n++]));
        this.m_ident = (short)(ICMPHeader.byteToShort(byArray[n++]) << 8 | ICMPHeader.byteToShort(byArray[n++]));
    }

    public final byte getType() {
        return this.m_type;
    }

    protected void setType(byte by) {
        this.m_type = by;
    }

    public final byte getCode() {
        return this.m_code;
    }

    public final void setCode(byte by) {
        this.m_code = by;
    }

    public final short getSequenceId() {
        return this.m_sequence;
    }

    public final short setNextSequenceId() {
        this.m_sequence = ICMPHeader.nextSequenceId();
        return this.m_sequence;
    }

    public final void setSequenceId(short s) {
        this.m_sequence = s;
    }

    public final short getIdentity() {
        return this.m_ident;
    }

    public final void setIdentity(short s) {
        this.m_ident = s;
    }

    public final short getChecksum() {
        return this.m_checksum;
    }

    protected void setChecksum(short s) {
        this.m_checksum = s;
    }

    public void computeChecksum() {
        OC16ChecksumProducer oC16ChecksumProducer = new OC16ChecksumProducer();
        this.computeChecksum(oC16ChecksumProducer);
        this.m_checksum = oC16ChecksumProducer.getChecksum();
    }

    protected void computeChecksum(OC16ChecksumProducer oC16ChecksumProducer) {
        oC16ChecksumProducer.reset();
        oC16ChecksumProducer.add(this.m_type, this.m_code);
        oC16ChecksumProducer.add((short)0);
        oC16ChecksumProducer.add(this.m_sequence);
        oC16ChecksumProducer.add(this.m_ident);
    }

    protected int storeToBuffer(byte[] byArray, int n) {
        if (byArray.length < n + 8) {
            throw new IndexOutOfBoundsException("Array index overflow in buffer");
        }
        byArray[n++] = this.m_type;
        byArray[n++] = this.m_code;
        byArray[n++] = (byte)(this.m_checksum >>> 8 & 0xFF);
        byArray[n++] = (byte)(this.m_checksum & 0xFF);
        byArray[n++] = (byte)(this.m_ident >>> 8 & 0xFF);
        byArray[n++] = (byte)(this.m_ident & 0xFF);
        byArray[n++] = (byte)(this.m_sequence >>> 8 & 0xFF);
        byArray[n++] = (byte)(this.m_sequence & 0xFF);
        return n;
    }

    protected int loadFromBuffer(byte[] byArray, int n) {
        if (byArray.length < n + 8) {
            throw new IndexOutOfBoundsException("Insufficient data to load ICMP header");
        }
        this.m_type = byArray[n++];
        this.m_code = byArray[n++];
        this.m_checksum = (short)(ICMPHeader.byteToShort(byArray[n++]) << 8 | ICMPHeader.byteToShort(byArray[n++]));
        this.m_ident = (short)(ICMPHeader.byteToShort(byArray[n++]) << 8 | ICMPHeader.byteToShort(byArray[n++]));
        this.m_sequence = (short)(ICMPHeader.byteToShort(byArray[n++]) << 8 | ICMPHeader.byteToShort(byArray[n++]));
        return n;
    }

    public static int getNetworkSize() {
        return 8;
    }

    public final boolean isEchoReply() {
        return this.m_type == 0;
    }

    public final boolean isEchoRequest() {
        return this.m_type == 8;
    }

    public byte[] toBytes() {
        byte[] byArray = new byte[8];
        this.storeToBuffer(byArray, 0);
        return byArray;
    }
}

