/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.protocols.ip;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.opennms.protocols.ip.IPv4Address;
import org.opennms.protocols.ip.UnknownIPVersionException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IPHeader {
    public static final int IP_VERSION = 4;
    public static final int TOS_PRECEDENCE_MASK = 224;
    public static final int TOS_PRECEDENCE_NETWORK_CRITICAL = 224;
    public static final int TOS_PRECEDENCE_INTERNETWORK_CONTROL = 192;
    public static final int TOS_PRECEDENCE_CRITICAL_ECP = 144;
    public static final int TOS_PRECEDENCE_FLASH_OVERRIDE = 128;
    public static final int TOS_PRECEDENCE_FLASH = 96;
    public static final int TOS_PRECEDENCE_IMMEDIATE = 64;
    public static final int TOS_PRECEDENCE_PRIORITY = 32;
    public static final int TOS_PRECEDENCE_ROUTINE = 0;
    public static final int TOS_DELAY_MASK = 16;
    public static final int TOS_DELAY_LOW = 16;
    public static final int TOS_DELAY_NORMAL = 0;
    public static final int TOS_THROUGHPUT_MASK = 8;
    public static final int TOS_THROUGHPUT_HIGH = 8;
    public static final int TOS_THROUGHPUT_NORMAL = 0;
    public static final int TOS_RELIBILITY_MASK = 4;
    public static final int TOS_RELIBILITY_HIGH = 4;
    public static final int TOS_RELIBILITY_NORMAL = 0;
    public static final int TOS_RESERVED_MASK = 3;
    public static final int FLAGS_MASK = 57344;
    public static final int FLAGS_DONT_FRAGMENT = 16384;
    public static final int FLAGS_MORE_FRAGMENTS = 8192;
    public static final int OPTION_COPY_MASK = 128;
    public static final int OPTION_CLASS_MASK = 96;
    public static final int OPTION_NUMBER_MASK = 31;
    public static final int OPTION_ID_EOO = 0;
    public static final int OPTION_ID_LOOSE_SOURCE_ROUTING = 131;
    public static final int OPTION_ID_STRICT_SOURCE_ROUTING = 137;
    public static final int OPTION_ID_ROUTE_RECORD = 7;
    private byte m_version;
    private byte m_hdrlen;
    private byte m_tos;
    private short m_length;
    private short m_identity;
    private byte m_flags;
    private short m_fragOffset;
    private byte m_ttl;
    private byte m_protocol;
    private short m_checksum;
    private int m_srcAddr;
    private int m_dstAddr;
    private byte[] m_options;

    private byte[] dup(byte[] byArray) {
        byte[] byArray2 = null;
        if (byArray != null) {
            byArray2 = new byte[byArray.length];
            System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
        }
        return byArray2;
    }

    private static short byteToShort(byte by) {
        short s = by;
        if (s < 0) {
            s = (short)(s + 256);
        }
        return s;
    }

    private static int byteToInt(byte n) {
        int n2 = n;
        if (n2 < 0) {
            n2 += 256;
        }
        return n2;
    }

    private static int shortToInt(short n) {
        int n2 = n;
        if (n2 < 0) {
            n2 += 65536;
        }
        return n2;
    }

    public IPHeader() {
        this.m_hdrlen = (byte)5;
        this.m_version = (byte)4;
        this.m_tos = 0;
        this.m_length = (short)20;
        this.m_identity = 0;
        this.m_flags = 0;
        this.m_fragOffset = 0;
        this.m_ttl = (byte)30;
        this.m_protocol = 0;
        this.m_checksum = 0;
        this.m_srcAddr = 0;
        this.m_dstAddr = 0;
        this.m_options = new byte[0];
    }

    public IPHeader(IPHeader iPHeader) {
        this.m_hdrlen = iPHeader.m_hdrlen;
        this.m_version = iPHeader.m_version;
        this.m_tos = iPHeader.m_tos;
        this.m_length = iPHeader.m_length;
        this.m_identity = iPHeader.m_identity;
        this.m_flags = iPHeader.m_flags;
        this.m_fragOffset = iPHeader.m_fragOffset;
        this.m_ttl = iPHeader.m_ttl;
        this.m_protocol = iPHeader.m_protocol;
        this.m_checksum = iPHeader.m_checksum;
        this.m_srcAddr = iPHeader.m_srcAddr;
        this.m_dstAddr = iPHeader.m_dstAddr;
        this.m_options = this.dup(iPHeader.m_options);
    }

    public IPHeader(byte[] byArray, int n) {
        int n2 = byArray.length;
        if (n2 - n < 20) {
            throw new IndexOutOfBoundsException("Minimum IP header size is 20 bytes");
        }
        int n3 = 0;
        this.m_version = (byte)(byArray[n + n3] >>> 4);
        this.m_hdrlen = (byte)(byArray[n + n3] & 0xF);
        ++n3;
        if (this.m_version != 4) {
            throw new UnknownIPVersionException("Unknown IP Version, version = " + this.m_version);
        }
        if (n2 - n < this.m_hdrlen * 4) {
            throw new IndexOutOfBoundsException("Insufficient data: buffer size = " + (n2 - n) + " and header length = " + this.m_hdrlen * 4);
        }
        this.m_tos = byArray[n + n3];
        this.m_length = (short)(IPHeader.byteToShort(byArray[n + ++n3]) << 8 | IPHeader.byteToShort(byArray[n + n3 + 1]));
        this.m_identity = (short)(IPHeader.byteToShort(byArray[n + (n3 += 2)]) << 8 | IPHeader.byteToShort(byArray[n + n3 + 1]));
        this.m_fragOffset = (short)(IPHeader.byteToShort(byArray[n + (n3 += 2)]) << 8 | IPHeader.byteToShort(byArray[n + n3 + 1]));
        this.m_flags = (byte)(this.m_fragOffset >>> 13);
        this.m_fragOffset = (short)(this.m_fragOffset & 0x1FFF);
        this.m_ttl = byArray[n + (n3 += 2)];
        this.m_protocol = byArray[n + ++n3];
        this.m_checksum = (short)(IPHeader.byteToShort(byArray[n + ++n3]) << 8 | IPHeader.byteToShort(byArray[n + n3 + 1]));
        this.m_srcAddr = IPHeader.byteToInt(byArray[n + (n3 += 2)]) << 24 | IPHeader.byteToInt(byArray[n + n3 + 1]) << 16 | IPHeader.byteToInt(byArray[n + n3 + 2]) << 8 | IPHeader.byteToInt(byArray[n + n3 + 3]);
        this.m_dstAddr = IPHeader.byteToInt(byArray[n + (n3 += 4)]) << 24 | IPHeader.byteToInt(byArray[n + n3 + 1]) << 16 | IPHeader.byteToInt(byArray[n + n3 + 2]) << 8 | IPHeader.byteToInt(byArray[n + n3 + 3]);
        int n4 = IPHeader.byteToInt(this.m_hdrlen) << 2;
        if (n4 > (n3 += 4)) {
            this.m_options = new byte[n4 - n3];
            int n5 = 0;
            while (n3 < n4) {
                this.m_options[n5++] = byArray[n + n3++];
            }
        } else {
            this.m_options = new byte[0];
        }
    }

    public byte getVersion() {
        return this.m_version;
    }

    public int getHeaderLength() {
        return 4 * IPHeader.byteToInt(this.m_hdrlen);
    }

    public byte getTypeOfService() {
        return this.m_tos;
    }

    public void setTypeOfService(byte by) {
        this.m_tos = by;
    }

    public boolean getTypeOfService(int n) {
        if (n >= 0 && n < 8) {
            return (this.m_tos & 1 << n) != 0;
        }
        return false;
    }

    public int getPacketLength() {
        return IPHeader.shortToInt(this.m_length);
    }

    public void setPacketLength(short s) {
        this.m_length = s;
    }

    public short getIdentity() {
        return this.m_identity;
    }

    public void setIdentity(short s) {
        this.m_identity = s;
    }

    public byte getFlags() {
        return this.m_flags;
    }

    public void setFlags(byte by) {
        this.m_flags = by;
    }

    public boolean getFlag(int n) {
        if (n >= 0 && n < 3) {
            return (this.m_flags & 1 << n) != 0;
        }
        return false;
    }

    public short getFragmentOffset() {
        return this.m_fragOffset;
    }

    public void setFragmentOffset(short s) {
        this.m_fragOffset = s;
    }

    public byte getTTL() {
        return this.m_ttl;
    }

    public void setTTL(byte by) {
        this.m_ttl = by;
    }

    public byte getProtocol() {
        return this.m_protocol;
    }

    public void setProtocol(byte by) {
        this.m_protocol = by;
    }

    public short getChecksum() {
        return this.m_checksum;
    }

    public void setChecksum(short s) {
        this.m_checksum = s;
    }

    public int getSourceAddress() {
        return this.m_srcAddr;
    }

    public void setSourceAddr(int n) {
        this.m_srcAddr = n;
    }

    public int getDestinationAddress() {
        return this.m_dstAddr;
    }

    public void setDestinationAddress(int n) {
        this.m_dstAddr = n;
    }

    public byte[] getOptionData() {
        return this.m_options;
    }

    public void setOptionData(byte[] byArray) {
        this.m_options = byArray;
        this.m_hdrlen = (byte)((20 + this.m_options.length) / 4);
    }

    public List<Option> getOptions() throws InstantiationException {
        if (this.m_options == null) {
            return new ArrayList<Option>();
        }
        ArrayList<Option> arrayList = new ArrayList<Option>();
        int n = 0;
        block6: while (n < this.m_options.length) {
            switch (this.m_options[n++] & 0xFF) {
                case 0: {
                    arrayList.add(new EndOfOptions());
                    continue block6;
                }
                case 131: {
                    int n2;
                    int n3;
                    int n4;
                    RouteOption routeOption = new LooseSourceRouteOption();
                    int n5 = (this.m_options[n] & 0xFF) - 3;
                    n += 2;
                    for (n4 = 0; n4 < n5 / 4; ++n4) {
                        n3 = 0;
                        for (n2 = 0; n2 < 4; ++n2) {
                            n3 <<= 8 + (this.m_options[n++] & 0xFF);
                        }
                        routeOption.add(new IPv4Address(n3));
                    }
                    arrayList.add(routeOption);
                    continue block6;
                }
                case 137: {
                    int n2;
                    int n3;
                    int n4;
                    RouteOption routeOption = new StrictSourceRouteOption();
                    int n5 = (this.m_options[n] & 0xFF) - 3;
                    n += 2;
                    for (n4 = 0; n4 < n5 / 4; ++n4) {
                        n3 = 0;
                        for (n2 = 0; n2 < 4; ++n2) {
                            n3 <<= 8 + (this.m_options[n++] & 0xFF);
                        }
                        routeOption.add(new IPv4Address(n3));
                    }
                    arrayList.add(routeOption);
                    continue block6;
                }
                case 7: {
                    int n2;
                    int n3;
                    int n4;
                    RouteOption routeOption = new LooseSourceRouteOption();
                    int n5 = (this.m_options[n] & 0xFF) - 3;
                    n += 2;
                    for (n4 = 0; n4 < n5 / 4; ++n4) {
                        n3 = 0;
                        for (n2 = 0; n2 < 4; ++n2) {
                            n3 <<= 8 + (this.m_options[n++] & 0xFF);
                        }
                        routeOption.add(new IPv4Address(n3));
                    }
                    arrayList.add(routeOption);
                    continue block6;
                }
            }
            throw new InstantiationException("Unsupported Option Type");
        }
        return arrayList;
    }

    public void addOption(Option option) {
        int n = 0;
        if (this.m_options == null) {
            int n2 = option.bytesRequired();
            if (n2 % 4 != 0) {
                n2 = 4 - n2 % 4;
            }
            this.m_options = new byte[option.bytesRequired()];
            int n3 = option.writeBytes(this.m_options, 0);
            while (n3 < n2) {
                this.m_options[n3++] = 0;
            }
        } else {
            n = this.m_options.length;
            if (n + option.bytesRequired() > 40) {
                throw new IndexOutOfBoundsException("Option List is too long, must be less than 40 bytes");
            }
            int n4 = n + option.bytesRequired();
            if (n4 % 4 != 0) {
                n4 += 4 - n4 % 4;
            }
            byte[] byArray = new byte[n4];
            System.arraycopy(this.m_options, 0, byArray, 0, n);
            int n5 = option.writeBytes(byArray, n);
            while (n5 < n4) {
                byArray[n5++] = 0;
            }
        }
        this.m_hdrlen = (byte)((20 + this.m_options.length) / 4);
    }

    public int writeBytes(byte[] byArray, int n) {
        byArray[n++] = (byte)(this.m_version << 4 | this.m_hdrlen & 0xF);
        byArray[n++] = this.m_tos;
        byArray[n++] = (byte)(this.m_length >> 8 & 0xFF);
        byArray[n++] = (byte)(this.m_length & 0xFF);
        byArray[n++] = (byte)(this.m_identity >> 8 & 0xFF);
        byArray[n++] = (byte)(this.m_identity & 0xFF);
        byArray[n++] = (byte)(this.m_flags << 5 | this.m_fragOffset >> 8 & 0xFF);
        byArray[n++] = (byte)(this.m_fragOffset & 0xFF);
        byArray[n++] = this.m_ttl;
        byArray[n++] = this.m_protocol;
        byArray[n++] = (byte)(this.m_checksum >> 8 & 0xFF);
        byArray[n++] = (byte)(this.m_checksum & 0xFF);
        byArray[n++] = (byte)(this.m_srcAddr >> 24 & 0xFF);
        byArray[n++] = (byte)(this.m_srcAddr >> 16 & 0xFF);
        byArray[n++] = (byte)(this.m_srcAddr >> 8 & 0xFF);
        byArray[n++] = (byte)(this.m_srcAddr & 0xFF);
        byArray[n++] = (byte)(this.m_dstAddr >> 24 & 0xFF);
        byArray[n++] = (byte)(this.m_dstAddr >> 16 & 0xFF);
        byArray[n++] = (byte)(this.m_dstAddr >> 8 & 0xFF);
        byArray[n++] = (byte)(this.m_dstAddr & 0xFF);
        System.arraycopy(this.m_options, 0, byArray, n, this.m_options.length);
        return n += this.m_options.length;
    }

    public static String addressToString(int n) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(n >> 24 & 0xFF);
        stringBuffer.append('.');
        stringBuffer.append(n >> 16 & 0xFF);
        stringBuffer.append('.');
        stringBuffer.append(n >> 8 & 0xFF);
        stringBuffer.append('.');
        stringBuffer.append(n & 0xFF);
        return stringBuffer.toString();
    }

    public static String addressToString(byte[] byArray) {
        if (byArray.length != 4) {
            throw new IllegalArgumentException("IPv4 Address must be 4-bytes in length");
        }
        int n = byArray[0] < 0 ? byArray[0] + 256 : byArray[0];
        int n2 = byArray[1] < 0 ? byArray[1] + 256 : byArray[1];
        int n3 = byArray[2] < 0 ? byArray[2] + 256 : byArray[2];
        int n4 = byArray[3] < 0 ? byArray[3] + 256 : byArray[3];
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(n).append('.').append(n2).append('.').append(n3).append('.').append(n4);
        return stringBuffer.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class RouteRecordOption
    extends RouteOption {
        RouteRecordOption() {
            super((byte)7);
        }

        public RouteRecordOption(int n) {
            super((byte)7);
            for (int i = 0; i < n; ++i) {
                this.add(new IPv4Address(0));
            }
        }

        public RouteRecordOption(IPv4Address[] iPv4AddressArray) {
            super((byte)7, iPv4AddressArray);
        }

        public RouteRecordOption(List<IPv4Address> list) {
            super((byte)7, list);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class StrictSourceRouteOption
    extends RouteOption {
        StrictSourceRouteOption() {
            super((byte)-119);
        }

        public StrictSourceRouteOption(IPv4Address[] iPv4AddressArray) {
            super((byte)-119, iPv4AddressArray);
        }

        public StrictSourceRouteOption(List<IPv4Address> list) {
            super((byte)-119, list);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class LooseSourceRouteOption
    extends RouteOption {
        LooseSourceRouteOption() {
            super((byte)-125);
        }

        public LooseSourceRouteOption(IPv4Address[] iPv4AddressArray) {
            super((byte)-125, iPv4AddressArray);
        }

        public LooseSourceRouteOption(List<IPv4Address> list) {
            super((byte)-125, list);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class RouteOption
    extends Option {
        protected List<IPv4Address> m_addrs;

        void add(IPv4Address iPv4Address) {
            if (this.m_addrs.size() == 9) {
                throw new IndexOutOfBoundsException("The address could not be added, the record is full");
            }
            this.m_addrs.add(iPv4Address);
        }

        @Override
        int bytesRequired() {
            return 3 + 4 * this.m_addrs.size();
        }

        @Override
        int writeBytes(byte[] byArray, int n) {
            byArray[n++] = (byte)this.m_code;
            byArray[n++] = (byte)this.bytesRequired();
            byArray[n++] = 4;
            Iterator<IPv4Address> iterator = this.m_addrs.iterator();
            while (iterator.hasNext()) {
                int n2 = iterator.next().getAddress();
                for (int i = 3; i >= 0; ++i) {
                    byArray[n++] = (byte)(n2 >> 8 * i & 0xFF);
                }
            }
            return n;
        }

        RouteOption(byte by) {
            super(by);
            this.m_addrs = new ArrayList<IPv4Address>(9);
        }

        RouteOption(byte by, IPv4Address[] iPv4AddressArray) {
            super(by);
            if (iPv4AddressArray.length > 9) {
                throw new IndexOutOfBoundsException("Route Option List Cannot Exceed 9 Addresses");
            }
            this.m_addrs = new ArrayList<IPv4Address>(9);
            for (int i = 0; i < iPv4AddressArray.length; ++i) {
                this.m_addrs.add(iPv4AddressArray[i]);
            }
        }

        RouteOption(byte by, List<IPv4Address> list) {
            super(by);
            if (list.size() > 9) {
                throw new IndexOutOfBoundsException("Route Option List Cannot Exceed 9 Addresses");
            }
            Iterator<IPv4Address> iterator = list.iterator();
            this.m_addrs = new ArrayList<IPv4Address>(9);
            while (iterator.hasNext()) {
                this.m_addrs.add(iterator.next());
            }
        }

        public Iterator<IPv4Address> iterator() {
            return this.m_addrs.iterator();
        }

        public int size() {
            return this.m_addrs.size();
        }
    }

    public static final class EndOfOptions
    extends Option {
        int bytesRequired() {
            return 1;
        }

        int writeBytes(byte[] byArray, int n) {
            byArray[n++] = 0;
            return n;
        }

        public EndOfOptions() {
            super((byte)0);
        }
    }

    public static abstract class Option {
        protected int m_code;
        public static final int CODE_END_OF_OPTION_LIST = 0;
        public static final int CODE_LOOSE_SOURCE_ROUTE = 131;
        public static final int CODE_STRICT_SOURCE_ROUTE = 137;
        public static final int CODE_ROUTE_RECORD = 7;

        protected Option(byte by) {
            this.m_code = by & 0xFF;
        }

        abstract int bytesRequired();

        abstract int writeBytes(byte[] var1, int var2);

        public int getOptionClass() {
            return this.m_code & 0x60;
        }

        public int getOptionNumber() {
            return this.m_code & 0x1F;
        }

        public boolean isOptionCopied() {
            return (this.m_code & 0x80) != 0;
        }
    }
}

