/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.protocols.ip;

public final class OC16ChecksumProducer {
    private int m_cksum = 0;
    private boolean m_finalized = false;

    private static int byteToInt(byte by) {
        if (by < 0) {
            return by + 256;
        }
        return by;
    }

    private static int shortToInt(short s) {
        if (s < 0) {
            return s + 65536;
        }
        return s;
    }

    private void finalizeSum() {
        if ((this.m_cksum & 0xFFFF0000) != 0) {
            this.m_cksum = (this.m_cksum >> 16 & 0xFFFF) + (this.m_cksum & 0xFFFF);
            this.m_cksum += this.m_cksum >>> 16;
        }
        this.m_finalized = true;
    }

    public void add(byte by) {
        this.add(by, (byte)0);
    }

    public void add(byte by, byte by2) {
        this.m_cksum += OC16ChecksumProducer.byteToInt(by) << 8 | OC16ChecksumProducer.byteToInt(by2);
        this.m_finalized = false;
    }

    public void add(short s) {
        this.m_cksum += OC16ChecksumProducer.shortToInt(s);
        this.m_finalized = false;
    }

    public void add(int n) {
        this.m_cksum += n >> 16 & 0xFFFF;
        this.m_cksum += n & 0xFFFF;
        this.m_finalized = false;
    }

    public void add(long l) {
        this.m_cksum += (int)(l >> 48) & 0xFFFF;
        this.m_cksum += (int)(l >> 32) & 0xFFFF;
        this.m_cksum += (int)(l >> 16) & 0xFFFF;
        this.m_cksum += (int)l & 0xFFFF;
        this.m_finalized = false;
    }

    public void reset() {
        this.m_cksum = 0;
        this.m_finalized = false;
    }

    public short getChecksum() {
        if (!this.m_finalized) {
            this.finalizeSum();
        }
        return (short)(~this.m_cksum & 0xFFFF);
    }
}

