/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.protocols.icmp;

import java.io.FileDescriptor;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.InetAddress;
import org.opennms.protocols.icmp.ICMPEchoPacket;

public final class IcmpSocket {
    private static final String LIBRARY_NAME = "jicmp";
    private static final String PROPERTY_NAME = "opennms.library.jicmp";
    private static final String LOGGER_PROPERTY_NAME = "opennms.logger.jicmp";
    private final FileDescriptor m_rawFd;

    private native void initSocket() throws IOException;

    public IcmpSocket() throws IOException {
        String string = System.getProperty(PROPERTY_NAME);
        if (string != null) {
            this.log().debug("System property 'opennms.library.jicmp' set to '" + System.getProperty(PROPERTY_NAME) + ".  Attempting to load " + LIBRARY_NAME + " library from this location.");
            System.load(string);
        } else {
            this.log().debug("System property 'opennms.library.jicmp' not set.  Attempting to load library using System.loadLibrary(\"jicmp\").");
            System.loadLibrary(LIBRARY_NAME);
        }
        this.log().info("Successfully loaded jicmp library.");
        this.m_rawFd = new FileDescriptor();
        this.initSocket();
        String string2 = System.getProperty("os.name");
        if (string2 != null && string2.toLowerCase().startsWith("windows")) {
            ICMPEchoPacket iCMPEchoPacket = new ICMPEchoPacket(0L);
            iCMPEchoPacket.setIdentity((short)0);
            iCMPEchoPacket.computeChecksum();
            byte[] byArray = iCMPEchoPacket.toBytes();
            DatagramPacket datagramPacket = new DatagramPacket(byArray, byArray.length, InetAddress.getByName("127.0.0.1"), 0);
            this.send(datagramPacket);
        }
    }

    private Logger log() {
        try {
            if (System.getProperty(LOGGER_PROPERTY_NAME) != null) {
                return (Logger)Class.forName(System.getProperty(LOGGER_PROPERTY_NAME)).newInstance();
            }
        }
        catch (Exception exception) {
            System.err.println("[WARN] Unable to create jicmp logger from property opennms.logger.jicmp with value " + System.getProperty(LOGGER_PROPERTY_NAME) + ". " + exception);
        }
        return new Logger(){

            public void debug(String string) {
                System.err.println("[DEBUG] " + string);
            }

            public void info(String string) {
                System.err.println("[INFO] " + string);
            }
        };
    }

    public final native DatagramPacket receive() throws IOException;

    public final native void send(DatagramPacket var1) throws IOException;

    public final native void close();

    public static interface Logger {
        public void debug(String var1);

        public void info(String var1);
    }
}

