/*
 * Decompiled with CFR 0.152.
 */
package org.jCharts.axisChart;

import java.awt.Graphics2D;
import java.awt.geom.Line2D;
import org.jCharts.axisChart.AxisChart;
import org.jCharts.chartData.interfaces.IDataSeries;
import org.jCharts.chartData.interfaces.IStockChartDataSet;
import org.jCharts.imageMap.CircleMapArea;
import org.jCharts.properties.DataAxisProperties;
import org.jCharts.properties.StockChartProperties;
import org.jCharts.types.StockChartDataType;

abstract class StockChart {
    StockChart() {
    }

    static final void render(AxisChart axisChart, IStockChartDataSet iStockChartDataSet) {
        StockChartProperties stockChartProperties = (StockChartProperties)iStockChartDataSet.getChartTypeProperties();
        Graphics2D graphics2D = axisChart.getGraphics2D();
        DataAxisProperties dataAxisProperties = (DataAxisProperties)axisChart.getAxisProperties().getYAxisProperties();
        IDataSeries iDataSeries = (IDataSeries)axisChart.getIAxisDataSeries();
        Line2D.Float float_ = new Line2D.Float(axisChart.getXAxis().getTickStart(), 0.0f, axisChart.getXAxis().getTickStart(), 0.0f);
        Line2D.Float float_2 = null;
        if (iStockChartDataSet.hasOpenValues()) {
            float_2 = new Line2D.Float(axisChart.getXAxis().getTickStart() - (float)stockChartProperties.getOpenPixelLength() - 1.0f, 0.0f, axisChart.getXAxis().getTickStart() - 1.0f, 0.0f);
        }
        Line2D.Float float_3 = null;
        if (iStockChartDataSet.hasCloseValues()) {
            float_3 = new Line2D.Float(axisChart.getXAxis().getTickStart() + 1.0f, 0.0f, axisChart.getXAxis().getTickStart() + (float)stockChartProperties.getClosePixelLength() + 1.0f, 0.0f);
        }
        int n = 0;
        while (n < iStockChartDataSet.getNumberOfDataItems()) {
            float_.y1 = axisChart.getYAxis().computeAxisCoordinate(axisChart.getYAxis().getOrigin(), iStockChartDataSet.getLowValue(n), axisChart.getYAxis().getScaleCalculator().getMinValue());
            float_.y2 = axisChart.getYAxis().computeAxisCoordinate(axisChart.getYAxis().getOrigin(), iStockChartDataSet.getHighValue(n), axisChart.getYAxis().getScaleCalculator().getMinValue());
            String string = axisChart.getXAxis().getAxisLabelsGroup() != null ? axisChart.getXAxis().getAxisLabelsGroup().getTextTag(n).getText() : null;
            if (axisChart.getGenerateImageMapFlag()) {
                axisChart.getImageMap().addImageMapArea(new CircleMapArea(float_.x1, float_.y1, iStockChartDataSet.getLowValue(n), string, iStockChartDataSet.getLegendLabel(StockChartDataType.LOW.getInt())));
                axisChart.getImageMap().addImageMapArea(new CircleMapArea(float_.x2, float_.y2, iStockChartDataSet.getHighValue(n), string, iStockChartDataSet.getLegendLabel(StockChartDataType.HIGH.getInt())));
            }
            graphics2D.setPaint(iStockChartDataSet.getPaint(StockChartDataType.HIGH.getInt()));
            graphics2D.setStroke(stockChartProperties.getHiLowStroke());
            graphics2D.draw(float_);
            float_.x1 += axisChart.getXAxis().getScalePixelWidth();
            float_.x2 = float_.x1;
            if (float_2 != null && iStockChartDataSet.getOpenValue(n) != Double.NaN) {
                float_2.y2 = float_2.y1 = axisChart.getYAxis().computeAxisCoordinate(axisChart.getYAxis().getOrigin(), iStockChartDataSet.getOpenValue(n), axisChart.getYAxis().getScaleCalculator().getMinValue());
                graphics2D.setPaint(iStockChartDataSet.getPaint(StockChartDataType.OPEN.getInt()));
                graphics2D.setStroke(stockChartProperties.getOpenStroke());
                graphics2D.draw(float_2);
                if (axisChart.getGenerateImageMapFlag()) {
                    axisChart.getImageMap().addImageMapArea(new CircleMapArea(float_2.x1, float_2.y1, iStockChartDataSet.getOpenValue(n), string, iStockChartDataSet.getLegendLabel(StockChartDataType.OPEN.getInt())));
                }
                float_2.x1 += axisChart.getXAxis().getScalePixelWidth();
                float_2.x2 += axisChart.getXAxis().getScalePixelWidth();
            }
            if (float_3 != null && iStockChartDataSet.getOpenValue(n) != Double.NaN) {
                float_3.y2 = float_3.y1 = axisChart.getYAxis().computeAxisCoordinate(axisChart.getYAxis().getOrigin(), iStockChartDataSet.getCloseValue(n), axisChart.getYAxis().getScaleCalculator().getMinValue());
                graphics2D.setPaint(iStockChartDataSet.getPaint(StockChartDataType.CLOSE.getInt()));
                graphics2D.setStroke(stockChartProperties.getCloseStroke());
                graphics2D.draw(float_3);
                if (axisChart.getGenerateImageMapFlag()) {
                    axisChart.getImageMap().addImageMapArea(new CircleMapArea(float_3.x2, float_3.y2, iStockChartDataSet.getCloseValue(n), string, iStockChartDataSet.getLegendLabel(StockChartDataType.CLOSE.getInt())));
                }
                float_3.x1 += axisChart.getXAxis().getScalePixelWidth();
                float_3.x2 += axisChart.getXAxis().getScalePixelWidth();
            }
            ++n;
        }
    }
}

