/*
 * Decompiled with CFR 0.152.
 */
package org.jCharts.encoders;

import java.awt.image.BufferedImage;
import java.awt.image.IndexColorModel;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Iterator;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.ImageWriter;
import javax.imageio.plugins.jpeg.JPEGImageWriteParam;
import javax.imageio.stream.ImageOutputStream;
import org.jCharts.Chart;
import org.jCharts.chartData.ChartDataException;
import org.jCharts.encoders.BinaryEncoderUtil;
import org.jCharts.properties.PropertyException;

public final class JPEGEncoder {
    private static final String JPEG = "jpeg";

    private JPEGEncoder() throws Exception {
        throw new Exception("No need to create an instance of this class!");
    }

    public static final void encode(Chart chart, float f, OutputStream outputStream) throws ChartDataException, PropertyException, IOException {
        BufferedImage bufferedImage = BinaryEncoderUtil.render(chart);
        Iterator<ImageWriter> iterator = ImageIO.getImageWritersByFormatName(JPEG);
        ImageWriter imageWriter = iterator.next();
        JPEGImageWriteParam jPEGImageWriteParam = new JPEGImageWriteParam(null);
        jPEGImageWriteParam.setCompressionMode(2);
        jPEGImageWriteParam.setCompressionQuality(f);
        jPEGImageWriteParam.setProgressiveMode(0);
        jPEGImageWriteParam.setDestinationType(new ImageTypeSpecifier(IndexColorModel.getRGBdefault(), IndexColorModel.getRGBdefault().createCompatibleSampleModel(16, 16)));
        ImageOutputStream imageOutputStream = ImageIO.createImageOutputStream(outputStream);
        imageWriter.setOutput(imageOutputStream);
        imageWriter.write(null, new IIOImage(bufferedImage, null, null), jPEGImageWriteParam);
        imageOutputStream.close();
        imageWriter.dispose();
    }

    static {
        ImageIO.setUseCache(false);
    }
}

