/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.util.pngj;

import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.letsPlot.util.pngj.IBytesConsumer;
import org.jetbrains.letsPlot.util.pngj.InputPngStream;
import org.jetbrains.letsPlot.util.pngj.PngjInputException;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\b\u0000\u0018\u0000 \u001c2\u00020\u0001:\u0001\u001cB\u0019\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0006\u0010\u0010\u001a\u00020\u0011J\u000e\u0010\u0012\u001a\u00020\u00052\u0006\u0010\u0013\u001a\u00020\u0014J\u0018\u0010\u0012\u001a\u00020\u00052\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0005H\u0002J\u000e\u0010\u0016\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\u0014J\u0016\u0010\u0017\u001a\u00020\u00052\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0018\u001a\u00020\u0005J\u0006\u0010\u0019\u001a\u00020\fJ\b\u0010\u001a\u001a\u00020\u0011H\u0002J\u000e\u0010\u001b\u001a\u00020\u00112\u0006\u0010\u000b\u001a\u00020\fR\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lorg/jetbrains/letsPlot/util/pngj/BufferedStreamFeeder;", "", "stream", "Lorg/jetbrains/letsPlot/util/pngj/InputPngStream;", "bufSize", "", "(Lorg/jetbrains/letsPlot/util/pngj/InputPngStream;I)V", "buf", "", "bytesRead", "", "closeStream", "", "isEof", "offset", "pendinglen", "close", "", "feed", "consumer", "Lorg/jetbrains/letsPlot/util/pngj/IBytesConsumer;", "maxBytes", "feedAll", "feedFixed", "nbytes", "hasPendingBytes", "refillBufferIfAppropiate", "setCloseStream", "Companion", "plot-api"})
public final class BufferedStreamFeeder {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final InputPngStream stream;
    @NotNull
    private final byte[] buf;
    private int pendinglen;
    private int offset;
    private boolean isEof;
    private boolean closeStream;
    private long bytesRead;
    private static final int DEFAULTSIZE = 16384;

    @JvmOverloads
    public BufferedStreamFeeder(@NotNull InputPngStream stream, int bufSize) {
        Intrinsics.checkNotNullParameter((Object)stream, (String)"stream");
        this.stream = stream;
        this.buf = new byte[bufSize < 1 ? 16384 : bufSize];
        this.closeStream = true;
    }

    public /* synthetic */ BufferedStreamFeeder(InputPngStream inputPngStream, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            n = 16384;
        }
        this(inputPngStream, n);
    }

    public final int feed(@NotNull IBytesConsumer consumer) {
        Intrinsics.checkNotNullParameter((Object)consumer, (String)"consumer");
        return this.feed(consumer, Integer.MAX_VALUE);
    }

    private final int feed(IBytesConsumer consumer, int maxBytes) {
        int n;
        int toFeed;
        this.refillBufferIfAppropiate();
        int consumed = 0;
        int n2 = toFeed = (1 <= maxBytes ? maxBytes < this.pendinglen : false) ? maxBytes : this.pendinglen;
        if (toFeed > 0) {
            consumed = consumer.consume(this.buf, this.offset, toFeed);
            if (consumed > 0) {
                this.offset += consumed;
                this.pendinglen -= consumed;
                if (!(this.pendinglen >= 0)) {
                    String string = "Failed requirement.";
                    throw new IllegalArgumentException(string.toString());
                }
            }
        } else {
            if (!this.isEof) {
                throw new PngjInputException("This should not happen");
            }
            return consumer.isDone() ? -1 : 0;
        }
        if (consumed > 0) {
            n = consumed;
        } else {
            if (!consumer.isDone()) {
                throw new PngjInputException("This should not happen!");
            }
            n = -1;
        }
        return n;
    }

    public final long feedAll(@NotNull IBytesConsumer consumer) {
        int n1;
        Intrinsics.checkNotNullParameter((Object)consumer, (String)"consumer");
        long n = 0L;
        while (this.hasPendingBytes() && (n1 = this.feed(consumer)) > 0) {
            n += (long)n1;
        }
        return n;
    }

    public final int feedFixed(@NotNull IBytesConsumer consumer, int nbytes) {
        int remain;
        int n;
        Intrinsics.checkNotNullParameter((Object)consumer, (String)"consumer");
        for (remain = nbytes; remain > 0; remain -= n) {
            n = this.feed(consumer, remain);
            if (n > 0) continue;
            return n;
        }
        if (!(remain == 0)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        return nbytes;
    }

    private final void refillBufferIfAppropiate() {
        if (this.pendinglen > 0 || this.isEof) {
            return;
        }
        this.offset = 0;
        this.pendinglen = this.stream.read(this.buf);
        if (this.pendinglen == 0) {
            throw new PngjInputException("This should not happen: stream.read(buf) returned 0");
        }
        if (this.pendinglen < 0) {
            this.close();
        } else {
            this.bytesRead += (long)this.pendinglen;
        }
    }

    public final boolean hasPendingBytes() {
        this.refillBufferIfAppropiate();
        return this.pendinglen > 0;
    }

    public final void setCloseStream(boolean closeStream) {
        this.closeStream = closeStream;
    }

    public final void close() {
        this.isEof = true;
        this.pendinglen = 0;
        this.offset = 0;
        if (this.closeStream) {
            this.stream.close();
        }
    }

    @JvmOverloads
    public BufferedStreamFeeder(@NotNull InputPngStream stream) {
        Intrinsics.checkNotNullParameter((Object)stream, (String)"stream");
        this(stream, 0, 2, null);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lorg/jetbrains/letsPlot/util/pngj/BufferedStreamFeeder$Companion;", "", "()V", "DEFAULTSIZE", "", "plot-api"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

