/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jexl2.internal;

import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.util.List;
import org.apache.commons.jexl2.internal.AbstractExecutor;
import org.apache.commons.jexl2.internal.Introspector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ListGetExecutor
extends AbstractExecutor.Get {
    private static final Method ARRAY_GET = ListGetExecutor.initMarker(Array.class, "get", Object.class, Integer.TYPE);
    private static final Method LIST_GET = ListGetExecutor.initMarker(List.class, "get", Integer.TYPE);
    private final Integer property;

    public ListGetExecutor(Introspector is, Class<?> clazz, Integer key) {
        super(clazz, ListGetExecutor.discover(clazz));
        this.property = key;
    }

    @Override
    public Object getTargetProperty() {
        return this.property;
    }

    @Override
    public Object execute(Object obj) {
        if (this.method == ARRAY_GET) {
            return Array.get(obj, this.property);
        }
        return ((List)obj).get(this.property);
    }

    @Override
    public Object tryExecute(Object obj, Object key) {
        if (obj != null && this.method != null && this.objectClass.equals(obj.getClass()) && key instanceof Integer) {
            if (this.method == ARRAY_GET) {
                return Array.get(obj, (Integer)key);
            }
            return ((List)obj).get((Integer)key);
        }
        return TRY_FAILED;
    }

    static Method discover(Class<?> clazz) {
        if (clazz.isArray()) {
            return ARRAY_GET;
        }
        if (List.class.isAssignableFrom(clazz)) {
            return LIST_GET;
        }
        return null;
    }
}

