/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.visualizers;

import java.awt.BorderLayout;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.ServiceLoader;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import org.apache.jmeter.samplers.SampleResult;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jmeter.visualizers.RequestView;
import org.apache.jorphan.reflect.LogAndIgnoreServiceLoadExceptionHandler;
import org.apache.jorphan.reflect.ServiceLoadExceptionHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RequestPanel {
    private static final Logger log = LoggerFactory.getLogger(RequestPanel.class);
    private final Deque<RequestView> listRequestView = new ArrayDeque<RequestView>();
    private final JPanel panel;

    public RequestPanel() {
        String rawTab = JMeterUtils.getResString((String)"view_results_table_request_tab_raw");
        RequestView rawObject = null;
        for (RequestView requestView : JMeterUtils.loadServicesAndScanJars(RequestView.class, ServiceLoader.load(RequestView.class), (ClassLoader)Thread.currentThread().getContextClassLoader(), (ServiceLoadExceptionHandler)new LogAndIgnoreServiceLoadExceptionHandler(log))) {
            if (rawTab.equals(requestView.getLabel())) {
                rawObject = requestView;
                continue;
            }
            this.listRequestView.add(requestView);
        }
        if (rawObject != null) {
            this.listRequestView.addFirst(rawObject);
        }
        JTabbedPane tabbedRequest = new JTabbedPane(3);
        for (RequestView requestView : this.listRequestView) {
            requestView.init();
            tabbedRequest.addTab(requestView.getLabel(), requestView.getPanel());
        }
        this.panel = new JPanel(new BorderLayout());
        this.panel.add(tabbedRequest);
    }

    public void clearData() {
        for (RequestView requestView : this.listRequestView) {
            requestView.clearData();
        }
    }

    public void setSamplerResult(SampleResult samplerResult) {
        for (RequestView requestView : this.listRequestView) {
            requestView.setSamplerResult(samplerResult);
        }
    }

    public JPanel getPanel() {
        return this.panel;
    }
}

