/*
 * Decompiled with CFR 0.152.
 */
package org.jCharts.axisChart;

import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import org.jCharts.axisChart.AxisChart;
import org.jCharts.axisChart.BarChart;
import org.jCharts.axisChart.customRenderers.axisValue.AxisValueRenderEvent;
import org.jCharts.chartData.interfaces.IAxisChartDataSet;
import org.jCharts.imageMap.RectMapArea;
import org.jCharts.properties.BarChartProperties;
import org.jCharts.properties.ClusteredBarChartProperties;
import org.jCharts.properties.DataAxisProperties;

abstract class ClusteredBarChart {
    ClusteredBarChart() {
    }

    static void render(AxisChart axisChart, IAxisChartDataSet iAxisChartDataSet) {
        Graphics2D graphics2D = axisChart.getGraphics2D();
        ClusteredBarChartProperties clusteredBarChartProperties = (ClusteredBarChartProperties)iAxisChartDataSet.getChartTypeProperties();
        if (axisChart.getAxisProperties().isPlotHorizontal()) {
            DataAxisProperties dataAxisProperties = (DataAxisProperties)axisChart.getAxisProperties().getXAxisProperties();
            float f = axisChart.getYAxis().getScalePixelWidth() * clusteredBarChartProperties.getPercentage();
            float f2 = f / (float)iAxisChartDataSet.getNumberOfDataSets();
            float f3 = axisChart.getXAxis().getZeroLineCoordinate();
            float f4 = axisChart.getYAxis().getLastTickY() - f / 2.0f;
            float f5 = 0.0f;
            float f6 = f2;
            Rectangle2D.Float float_ = new Rectangle2D.Float(f3, f4, f5, f6);
            ClusteredBarChart.horizontalPlot(axisChart, iAxisChartDataSet, clusteredBarChartProperties, dataAxisProperties, graphics2D, float_, f3, f4, f2);
        } else {
            DataAxisProperties dataAxisProperties = (DataAxisProperties)axisChart.getAxisProperties().getYAxisProperties();
            float f = axisChart.getXAxis().getScalePixelWidth() * clusteredBarChartProperties.getPercentage();
            float f7 = f / (float)iAxisChartDataSet.getNumberOfDataSets();
            float f8 = axisChart.getXAxis().getTickStart() - f / 2.0f;
            float f9 = axisChart.getYAxis().getZeroLineCoordinate();
            float f10 = f7;
            float f11 = 0.0f;
            Rectangle2D.Float float_ = new Rectangle2D.Float(f8, f9, f10, f11);
            ClusteredBarChart.verticalPlot(axisChart, iAxisChartDataSet, clusteredBarChartProperties, dataAxisProperties, graphics2D, float_, f8, f9, f7);
        }
    }

    private static void horizontalPlot(AxisChart axisChart, IAxisChartDataSet iAxisChartDataSet, ClusteredBarChartProperties clusteredBarChartProperties, DataAxisProperties dataAxisProperties, Graphics2D graphics2D, Rectangle2D.Float float_, float f, float f2, float f3) {
        int n = axisChart.getYAxis().getNumberOfScaleItems() - 1;
        Rectangle2D.Float float_2 = new Rectangle2D.Float();
        float_2.y = axisChart.getYAxis().getOrigin() - axisChart.getYAxis().getPixelLength() + 1.0f;
        float_2.height = axisChart.getYAxis().getScalePixelWidth() - 1.0f;
        float_2.x = axisChart.getXAxis().getOrigin() + 1.0f;
        float_2.width = axisChart.getXAxis().getPixelLength() - 1.0f;
        AxisValueRenderEvent axisValueRenderEvent = new AxisValueRenderEvent(axisChart, iAxisChartDataSet, graphics2D, float_2, axisChart.getXAxis().getZeroLineCoordinate());
        int n2 = 0;
        while (n2 < iAxisChartDataSet.getNumberOfDataItems()) {
            int n3 = 0;
            while (n3 < iAxisChartDataSet.getNumberOfDataSets()) {
                graphics2D.setPaint(iAxisChartDataSet.getPaint(n3));
                axisValueRenderEvent.setDataSetIndex(n3);
                axisValueRenderEvent.setValueX(axisChart.getXAxis().getZeroLineCoordinate());
                axisValueRenderEvent.setValueY((float)float_.getCenterY());
                axisValueRenderEvent.setValueIndex(n2);
                clusteredBarChartProperties.firePreRender(axisValueRenderEvent);
                if (iAxisChartDataSet.getValue(n3, n2) != 0.0) {
                    if (iAxisChartDataSet.getValue(n3, n2) < 0.0) {
                        float_.x = axisChart.getXAxis().computeAxisCoordinate(axisChart.getXAxis().getOrigin(), iAxisChartDataSet.getValue(n3, n2), axisChart.getXAxis().getScaleCalculator().getMinValue());
                        float_.width = f - float_.x;
                        axisValueRenderEvent.setValueX(float_.x);
                    } else {
                        float_.x = f;
                        float_.width = BarChart.computeScaleHeightOfValue(iAxisChartDataSet.getValue(n3, n2), axisChart.getXAxis().getOneUnitPixelSize());
                        axisValueRenderEvent.setValueX(float_.x + float_.width);
                    }
                    if (float_.width != 0.0f) {
                        graphics2D.fill(float_);
                        if (clusteredBarChartProperties.getShowOutlinesFlag()) {
                            clusteredBarChartProperties.getBarOutlineStroke().draw(graphics2D, float_);
                        }
                        if (axisChart.getGenerateImageMapFlag()) {
                            String string = axisChart.getYAxis().getAxisLabelsGroup() != null ? axisChart.getYAxis().getAxisLabelsGroup().getTextTag(n).getText() : null;
                            axisChart.getImageMap().addImageMapArea(new RectMapArea(float_, iAxisChartDataSet.getValue(n3, n2), string, iAxisChartDataSet.getLegendLabel(n3)));
                        }
                    }
                }
                clusteredBarChartProperties.firePostRender(axisValueRenderEvent);
                float_.y += f3;
                ++n3;
            }
            --n;
            float_.y = f2 += axisChart.getYAxis().getScalePixelWidth();
            float_2.y += axisChart.getYAxis().getScalePixelWidth();
            ++n2;
        }
    }

    private static void verticalPlot(AxisChart axisChart, IAxisChartDataSet iAxisChartDataSet, BarChartProperties barChartProperties, DataAxisProperties dataAxisProperties, Graphics2D graphics2D, Rectangle2D.Float float_, float f, float f2, float f3) {
        Rectangle2D.Float float_2 = new Rectangle2D.Float();
        float_2.x = axisChart.getXAxis().getOrigin() + 1.0f;
        float_2.y = axisChart.getYAxis().getOrigin() - axisChart.getYAxis().getPixelLength() + 1.0f;
        float_2.width = axisChart.getXAxis().getScalePixelWidth() - 1.0f;
        float_2.height = axisChart.getYAxis().getPixelLength() - 1.0f;
        AxisValueRenderEvent axisValueRenderEvent = new AxisValueRenderEvent(axisChart, iAxisChartDataSet, graphics2D, float_2, axisChart.getYAxis().getZeroLineCoordinate());
        int n = 0;
        while (n < iAxisChartDataSet.getNumberOfDataItems()) {
            int n2 = 0;
            while (n2 < iAxisChartDataSet.getNumberOfDataSets()) {
                graphics2D.setPaint(iAxisChartDataSet.getPaint(n2));
                axisValueRenderEvent.setDataSetIndex(n2);
                if (iAxisChartDataSet.getValue(n2, n) != 0.0) {
                    axisValueRenderEvent.setValueX((float)float_.getCenterX());
                    axisValueRenderEvent.setValueY(axisChart.getYAxis().getZeroLineCoordinate());
                    axisValueRenderEvent.setValueIndex(n);
                    barChartProperties.firePreRender(axisValueRenderEvent);
                    if (iAxisChartDataSet.getValue(n2, n) < 0.0) {
                        float_.y = f2;
                        float_.height = BarChart.computeScaleHeightOfValue(iAxisChartDataSet.getValue(n2, n), axisChart.getYAxis().getOneUnitPixelSize());
                        axisValueRenderEvent.setValueY(float_.y + float_.height);
                    } else {
                        float_.y = axisChart.getYAxis().computeAxisCoordinate(axisChart.getYAxis().getOrigin(), iAxisChartDataSet.getValue(n2, n), axisChart.getYAxis().getScaleCalculator().getMinValue());
                        float_.height = f2 - float_.y;
                        axisValueRenderEvent.setValueY(float_.y);
                    }
                    if (float_.height != 0.0f) {
                        graphics2D.fill(float_);
                        if (barChartProperties.getShowOutlinesFlag()) {
                            barChartProperties.getBarOutlineStroke().draw(graphics2D, float_);
                        }
                        if (axisChart.getGenerateImageMapFlag()) {
                            String string = axisChart.getXAxis().getAxisLabelsGroup() != null ? axisChart.getXAxis().getAxisLabelsGroup().getTextTag(n).getText() : null;
                            axisChart.getImageMap().addImageMapArea(new RectMapArea(float_, iAxisChartDataSet.getValue(n2, n), string, iAxisChartDataSet.getLegendLabel(n2)));
                        }
                    }
                }
                barChartProperties.firePostRender(axisValueRenderEvent);
                float_.x += f3;
                ++n2;
            }
            float_2.x += axisChart.getXAxis().getScalePixelWidth();
            float_.x = f += axisChart.getXAxis().getScalePixelWidth();
            ++n;
        }
    }
}

