/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.viewer.binding;

import java.util.Arrays;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import javajs.util.AU;
import javajs.util.Lst;
import javajs.util.PT;
import javajs.util.SB;
import org.jmol.api.Interface;
import org.jmol.util.Escape;
import org.jmol.util.Logger;
import org.jmol.viewer.Viewer;

public abstract class Binding {
    public static final int LEFT = 16;
    public static final int MIDDLE = 8;
    public static final int RIGHT = 4;
    public static final int WHEEL = 32;
    public static final int ALT = 8;
    public static final int CTRL = 2;
    public static final int SHIFT = 1;
    public static final int CTRL_ALT = 10;
    public static final int CTRL_SHIFT = 3;
    public static final int MAC_COMMAND = 20;
    public static final int BUTTON_MASK = 28;
    public static final int BUTTON_MODIFIER_MASK = 63;
    public static final int SINGLE = 256;
    public static final int DOUBLE = 512;
    public static final int COUNT_MASK = 768;
    public static final int DOWN = 4096;
    public static final int DRAG = 8192;
    public static final int UP = 16384;
    public static final int CLICK = 32768;
    public static final int MODE_MASK = 61440;
    public String name;
    private Map<String, Object> bindings = new Hashtable<String, Object>();

    public static int getMouseAction(int clickCount, int modifiers, int mode) {
        if (clickCount > 2) {
            clickCount = 2;
        }
        switch (clickCount) {
            case 0: {
                break;
            }
            case 1: {
                clickCount = 256;
                break;
            }
            default: {
                clickCount = 512;
            }
        }
        switch (mode) {
            case 4: {
                mode = 4096;
                break;
            }
            case 1: {
                mode = 8192;
                break;
            }
            case 5: {
                mode = 16384;
                break;
            }
            case 2: {
                mode = 32768;
                break;
            }
            case 3: {
                mode = 32;
            }
        }
        return modifiers & 0x3F | clickCount | mode;
    }

    public static int getMouseActionStr(String desc) {
        if (desc == null) {
            return 0;
        }
        int mouseAction = 0;
        mouseAction = (desc = desc.toUpperCase()).indexOf("MIDDLE") >= 0 ? 8 : (desc.indexOf("RIGHT") >= 0 ? 4 : (desc.indexOf("WHEEL") >= 0 ? 32 : 16));
        if (desc.indexOf("DOWN") >= 0) {
            mouseAction |= 0x1000;
        } else if (desc.indexOf("DRAG") >= 0) {
            mouseAction |= 0x2000;
        } else if (desc.indexOf("UP") >= 0) {
            mouseAction |= 0x4000;
        } else if (mouseAction != 32) {
            mouseAction |= 0x8000;
        }
        if (mouseAction != 32 && desc.indexOf("DOUBLE") >= 0) {
            mouseAction |= 0x200;
        } else if (mouseAction > 0) {
            mouseAction |= 0x100;
        }
        if (mouseAction != 288 && desc.indexOf("ALT") >= 0) {
            mouseAction |= 8;
        }
        if (desc.indexOf("CTRL") >= 0) {
            mouseAction |= 2;
        }
        if (desc.indexOf("SHIFT") >= 0) {
            mouseAction |= 1;
        }
        return mouseAction;
    }

    public static int getButtonMods(int mouseAction) {
        return mouseAction & 0x3F;
    }

    public static int getClickCount(int mouseAction) {
        return (mouseAction & 0x300) >> 8;
    }

    public static String getMouseActionName(int mouseAction, boolean addSortCode) {
        SB sb = new SB();
        if (mouseAction == 0) {
            return "";
        }
        boolean isMiddle = Binding.includes(mouseAction, 8) && !Binding.includes(mouseAction, 16) && !Binding.includes(mouseAction, 4);
        char[] code = "      ".toCharArray();
        if (Binding.includes(mouseAction, 2)) {
            sb.append("CTRL+");
            code[5] = 67;
        }
        if (!isMiddle && Binding.includes(mouseAction, 8)) {
            sb.append("ALT+");
            code[4] = 65;
        }
        if (Binding.includes(mouseAction, 1)) {
            sb.append("SHIFT+");
            code[3] = 83;
        }
        if (Binding.includes(mouseAction, 16)) {
            code[2] = 76;
            sb.append("LEFT");
        } else if (Binding.includes(mouseAction, 4)) {
            code[2] = 82;
            sb.append("RIGHT");
        } else if (isMiddle) {
            code[2] = 77;
            sb.append("MIDDLE");
        } else if (Binding.includes(mouseAction, 32)) {
            code[2] = 87;
            sb.append("WHEEL");
        }
        if (Binding.includes(mouseAction, 512)) {
            sb.append("+double");
            code[1] = 50;
        }
        if (Binding.includes(mouseAction, 4096)) {
            sb.append("+down");
            code[0] = 49;
        } else if (Binding.includes(mouseAction, 8192)) {
            sb.append("+drag");
            code[0] = 50;
        } else if (Binding.includes(mouseAction, 16384)) {
            sb.append("+up");
            code[0] = 51;
        } else if (Binding.includes(mouseAction, 32768)) {
            sb.append("+click");
            code[0] = 52;
        }
        return addSortCode ? new String(code) + ":" + sb.toString() : sb.toString();
    }

    public Map<String, Object> getBindings() {
        return this.bindings;
    }

    public final void bindAction(int mouseAction, int jmolAction) {
        this.addBinding(mouseAction + "\t" + jmolAction, new int[]{mouseAction, jmolAction});
    }

    public void bindName(int mouseAction, String name) {
        this.addBinding(mouseAction + "\t", Boolean.TRUE);
        this.addBinding(mouseAction + "\t" + name, new String[]{Binding.getMouseActionName(mouseAction, false), name});
    }

    public final void unbindAction(int mouseAction, int jmolAction) {
        if (mouseAction == 0) {
            this.unbindJmolAction(jmolAction);
        } else {
            this.removeBinding(null, mouseAction + "\t" + jmolAction);
        }
    }

    public final void unbindName(int mouseAction, String name) {
        if (name == null) {
            this.unbindMouseAction(mouseAction);
        } else {
            this.removeBinding(null, mouseAction + "\t" + name);
        }
    }

    public final void unbindJmolAction(int jmolAction) {
        Iterator<String> e = this.bindings.keySet().iterator();
        String skey = "\t" + jmolAction;
        while (e.hasNext()) {
            String key = e.next();
            if (!key.endsWith(skey)) continue;
            this.removeBinding(e, key);
        }
    }

    private void addBinding(String key, Object value) {
        if (Logger.debugging) {
            Logger.debug("adding binding " + key + "\t==\t" + Escape.e(value));
        }
        this.bindings.put(key, value);
    }

    private void removeBinding(Iterator<String> e, String key) {
        if (Logger.debugging) {
            Logger.debug("removing binding " + key);
        }
        if (e == null) {
            this.bindings.remove(key);
        } else {
            e.remove();
        }
    }

    public final void unbindUserAction(String script) {
        Iterator<String> e = this.bindings.keySet().iterator();
        String skey = "\t" + script;
        while (e.hasNext()) {
            String key = e.next();
            if (!key.endsWith(skey)) continue;
            this.removeBinding(e, key);
        }
    }

    public final void unbindMouseAction(int mouseAction) {
        Iterator<String> e = this.bindings.keySet().iterator();
        String skey = mouseAction + "\t";
        while (e.hasNext()) {
            String key = e.next();
            if (!key.startsWith(skey)) continue;
            this.removeBinding(e, key);
        }
    }

    public final boolean isBound(int mouseAction, int jmolAction) {
        return this.bindings.containsKey(mouseAction + "\t" + jmolAction);
    }

    public final boolean isUserAction(int mouseAction) {
        return this.bindings.containsKey(mouseAction + "\t");
    }

    public String getBindingInfo(String[] actionInfo, String[] actionNames, String qualifiers) {
        int i;
        SB sb = new SB();
        String qlow = qualifiers == null || qualifiers.equalsIgnoreCase("all") ? null : qualifiers.toLowerCase();
        Lst[] names = new Lst[actionInfo.length];
        Lst<String[]> user = new Lst<String[]>();
        for (Object obj : this.bindings.values()) {
            if (obj instanceof Boolean) continue;
            if (AU.isAS(obj)) {
                String action = ((String[])obj)[0];
                String script = ((String[])obj)[1];
                if (qlow != null && qlow.indexOf("user") < 0 && action.indexOf(qlow) < 0 && script.indexOf(qlow) < 0) continue;
                user.addLast((String[])obj);
                continue;
            }
            int[] info = (int[])obj;
            int i2 = info[1];
            if (names[i2] == null) {
                names[i2] = new Lst();
            }
            String name = Binding.getMouseActionName(info[0], true);
            if (qlow != null && (actionNames[i2] + ";" + actionInfo[i2] + ";" + name).toLowerCase().indexOf(qlow) < 0) continue;
            names[i2].addLast(name);
        }
        for (i = 0; i < actionInfo.length; ++i) {
            int n;
            if (names[i] == null || (n = names[i].size()) == 0) continue;
            this.addInfo(sb, names[i].toArray(new String[n]), actionNames[i], actionInfo[i]);
        }
        for (i = 0; i < user.size(); ++i) {
            String[] info = (String[])user.get(i);
            this.addInfo(sb, new String[]{"USER:::" + info[0]}, "user-defined", info[1]);
        }
        return sb.toString();
    }

    private void addInfo(SB sb, String[] list, String name, String info) {
        Arrays.sort(list);
        PT.leftJustify(sb, "                      ", name);
        sb.append("\t");
        String sep = "";
        int len = sb.length();
        for (int j = 0; j < list.length; ++j) {
            sb.append(sep).append(list[j].substring(7));
            sep = ", ";
        }
        len = sb.length() - len;
        if (len < 20) {
            sb.append("                 ".substring(0, 20 - len));
        }
        sb.append("\t").append(info).appendC('\n');
    }

    private static boolean includes(int mouseAction, int mod) {
        return (mouseAction & mod) == mod;
    }

    public static Binding newBinding(Viewer vwr, String name) {
        return (Binding)Interface.getInterface("org.jmol.viewer.binding." + name + "Binding", vwr, "script");
    }
}

