/*
 * Decompiled with CFR 0.152.
 */
package org.kse;

import java.io.File;
import java.io.IOException;
import java.security.KeyStore;
import org.kse.crypto.CryptoException;
import org.kse.crypto.keystore.KeyStoreUtil;
import org.kse.crypto.keystore.MsCapiStoreType;

public class AuthorityCertificates {
    public static final String CACERTS_DEFAULT_PWD = "changeit";
    private static AuthorityCertificates authorityCertificates;
    private KeyStore caCertificates;
    private KeyStore windowsTrustedRootCertificates;

    private AuthorityCertificates() {
    }

    public static synchronized AuthorityCertificates getInstance() {
        if (authorityCertificates == null) {
            authorityCertificates = new AuthorityCertificates();
        }
        return authorityCertificates;
    }

    public KeyStore getCaCertificates() {
        return this.caCertificates;
    }

    public void setCaCertificates(KeyStore caCertificates) {
        this.caCertificates = caCertificates;
    }

    public static File getDefaultCaCertificatesLocation() {
        String javaInstallDir = System.getProperty("java.home");
        String fileSep = System.getProperty("file.separator");
        File cacertsFile = new File(javaInstallDir, "lib" + fileSep + "security" + fileSep + "cacerts");
        try {
            return cacertsFile.getCanonicalFile();
        }
        catch (IOException e) {
            return cacertsFile;
        }
    }

    public KeyStore getWindowsTrustedRootCertificates() throws CryptoException {
        if (this.windowsTrustedRootCertificates == null) {
            this.windowsTrustedRootCertificates = KeyStoreUtil.loadMsCapiStore(MsCapiStoreType.ROOT);
        }
        return this.windowsTrustedRootCertificates;
    }
}

