/*
 * Decompiled with CFR 0.152.
 */
package org.kse;

import com.sun.jna.Library;
import com.sun.jna.Native;
import com.sun.jna.NativeLong;
import com.sun.jna.WString;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.SplashScreen;
import java.awt.Toolkit;
import java.io.File;
import java.lang.reflect.Field;
import java.security.Provider;
import java.security.Security;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x500.X500NameStyle;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.kse.ApplicationSettings;
import org.kse.crypto.x509.KseX500NameStyle;
import org.kse.gui.CreateApplicationGui;
import org.kse.gui.CurrentDirectory;
import org.kse.gui.error.DError;
import org.kse.utilities.os.OperatingSystem;
import org.kse.version.JavaVersion;
import org.kse.version.Version;

public class KSE {
    private static ResourceBundle res = ResourceBundle.getBundle("org/kse/resources");
    private static ResourceBundle props = ResourceBundle.getBundle("org/kse/version");

    public static void main(String[] args) {
        try {
            if (OperatingSystem.isMacOs()) {
                KSE.setAppleSystemProperties();
            } else if (OperatingSystem.isWindows7() || OperatingSystem.isWindows8() || OperatingSystem.isWindows10()) {
                String appId = props.getString("KSE.AppUserModelId");
                Shell32 shell32 = (Shell32)Native.load((String)"shell32", Shell32.class);
                shell32.SetCurrentProcessExplicitAppUserModelID(new WString(appId)).longValue();
            } else if (OperatingSystem.isLinux()) {
                KSE.fixAppClassName();
            }
            KSE.setInstallDirProperty();
            SplashScreen splash = SplashScreen.getSplashScreen();
            KSE.updateSplashMessage(splash, res.getString("KSE.LoadingApplicationSettings.splash.message"));
            ApplicationSettings applicationSettings = ApplicationSettings.getInstance();
            KSE.setCurrentDirectory(applicationSettings);
            String languageCode = applicationSettings.getLanguage();
            if (!"system".equals(languageCode)) {
                Locale.setDefault(new Locale(languageCode));
            }
            KSE.updateSplashMessage(splash, res.getString("KSE.InitializingSecurity.splash.message"));
            KSE.initialiseSecurity();
            ArrayList<File> parameterFiles = new ArrayList<File>();
            for (String arg : args) {
                File parameterFile = new File(arg);
                if (!parameterFile.exists()) continue;
                parameterFiles.add(parameterFile);
            }
            KSE.updateSplashMessage(splash, res.getString("KSE.CreatingApplicationGui.splash.message"));
            SwingUtilities.invokeLater(new CreateApplicationGui(applicationSettings, splash, parameterFiles));
        }
        catch (Throwable t) {
            DError dError = new DError(new JFrame(), t);
            dError.setLocationRelativeTo(null);
            dError.setVisible(true);
            System.exit(1);
        }
    }

    private static void fixAppClassName() {
        if (JavaVersion.getJreVersion().isBelow(JavaVersion.JRE_VERSION_12)) {
            Toolkit xToolkit = Toolkit.getDefaultToolkit();
            try {
                Field awtAppClassNameField = xToolkit.getClass().getDeclaredField("awtAppClassName");
                awtAppClassNameField.setAccessible(true);
                awtAppClassNameField.set(xToolkit, KSE.getApplicationName());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private static void updateSplashMessage(SplashScreen splash, String message) {
        if (splash != null) {
            Font font = new Font("SansSerif", 0, 10);
            Graphics2D g = splash.createGraphics();
            g.setFont(font);
            g.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            g.setColor(new Color(238, 238, 238));
            g.setPaintMode();
            g.fillRect(12, 70, 250, 30);
            g.setColor(new Color(96, 96, 96));
            g.setPaintMode();
            g.drawString(message, 17, 86);
            splash.update();
        }
    }

    private static void setAppleSystemProperties() {
        try {
            System.setProperty("apple.laf.useScreenMenuBar", "true");
            System.setProperty("com.apple.mrj.application.apple.menu.about.name", KSE.getApplicationName());
        }
        catch (SecurityException ex) {
            ex.printStackTrace();
        }
    }

    private static void setInstallDirProperty() {
        System.setProperty("kse.install.dir", System.getProperty("user.dir"));
    }

    private static void setCurrentDirectory(ApplicationSettings applicationSettings) {
        File currentDirectory = applicationSettings.getCurrentDirectory();
        if (currentDirectory != null) {
            CurrentDirectory.update(currentDirectory);
        }
    }

    private static void initialiseSecurity() {
        Security.addProvider((Provider)new BouncyCastleProvider());
    }

    public static String getApplicationName() {
        return props.getString("KSE.Name");
    }

    public static Version getApplicationVersion() {
        return new Version(props.getString("KSE.Version"));
    }

    public static Version getUserManualVersion() {
        return new Version(props.getString("KSE.UserManual.Version"));
    }

    public static String getFullApplicationName() {
        return MessageFormat.format(props.getString("KSE.FullName"), KSE.getApplicationName(), KSE.getApplicationVersion());
    }

    static {
        X500Name.setDefaultStyle((X500NameStyle)KseX500NameStyle.INSTANCE);
        System.setProperty("java.net.useSystemProxies", "true");
        System.setProperty("org.bouncycastle.asn1.allow_unsafe_integer", "true");
    }

    public static interface Shell32
    extends Library {
        public NativeLong SetCurrentProcessExplicitAppUserModelID(WString var1);
    }
}

