/*
 * Decompiled with CFR 0.152.
 */
package org.kse.crypto.csr.pkcs10;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.OutputStream;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.util.ResourceBundle;
import javax.security.auth.x500.X500Principal;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1OutputStream;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DERUTF8String;
import org.bouncycastle.asn1.pkcs.Attribute;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.x509.Extensions;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.operator.ContentSigner;
import org.bouncycastle.operator.ContentVerifierProvider;
import org.bouncycastle.operator.OperatorCreationException;
import org.bouncycastle.operator.jcajce.JcaContentSignerBuilder;
import org.bouncycastle.operator.jcajce.JcaContentVerifierProviderBuilder;
import org.bouncycastle.pkcs.PKCS10CertificationRequest;
import org.bouncycastle.pkcs.PKCSException;
import org.bouncycastle.pkcs.jcajce.JcaPKCS10CertificationRequest;
import org.bouncycastle.pkcs.jcajce.JcaPKCS10CertificationRequestBuilder;
import org.bouncycastle.util.encoders.Base64;
import org.kse.crypto.CryptoException;
import org.kse.crypto.signing.SignatureType;
import org.kse.crypto.x509.X509ExtensionSet;

public class Pkcs10Util {
    private static ResourceBundle res = ResourceBundle.getBundle("org/kse/crypto/csr/pkcs10/resources");
    private static final String BEGIN_CSR_FORM_1 = "-----BEGIN CERTIFICATE REQUEST-----";
    private static final String END_CSR_FORM_1 = "-----END CERTIFICATE REQUEST-----";
    private static final String BEGIN_CSR_FORM_2 = "-----BEGIN NEW CERTIFICATE REQUEST-----";
    private static final String END_CSR_FORM_2 = "-----END NEW CERTIFICATE REQUEST-----";
    private static final int MAX_PRINTABLE_ENC_LINE_LENGTH = 76;

    private Pkcs10Util() {
    }

    public static PKCS10CertificationRequest generateCsr(X500Principal subjectDN, PublicKey publicKey, PrivateKey privateKey, SignatureType signatureType, String challenge, String unstructuredName, Extensions extensions, Provider provider) throws CryptoException {
        try {
            JcaPKCS10CertificationRequestBuilder csrBuilder = new JcaPKCS10CertificationRequestBuilder(subjectDN, publicKey);
            if (challenge != null) {
                csrBuilder.addAttribute(PKCSObjectIdentifiers.pkcs_9_at_challengePassword, (ASN1Encodable)new DERUTF8String(challenge));
            }
            if (unstructuredName != null) {
                csrBuilder.addAttribute(PKCSObjectIdentifiers.pkcs_9_at_unstructuredName, (ASN1Encodable)new DERUTF8String(unstructuredName));
            }
            if (extensions != null) {
                csrBuilder.addAttribute(PKCSObjectIdentifiers.pkcs_9_at_extensionRequest, (ASN1Encodable)extensions.toASN1Primitive());
            }
            if (provider != null && provider.getService("Signature", signatureType.jce()) == null) {
                provider = new BouncyCastleProvider();
            }
            ContentSigner contentSigner = null;
            contentSigner = provider == null ? new JcaContentSignerBuilder(signatureType.jce()).build(privateKey) : new JcaContentSignerBuilder(signatureType.jce()).setProvider(provider).build(privateKey);
            PKCS10CertificationRequest csr = csrBuilder.build(contentSigner);
            if (!Pkcs10Util.verifyCsr(csr)) {
                throw new CryptoException(res.getString("NoVerifyGenPkcs10Csr.exception.message"));
            }
            return csr;
        }
        catch (OperatorCreationException e) {
            throw new CryptoException(res.getString("NoGeneratePkcs10Csr.exception.message"), e);
        }
    }

    public static boolean verifyCsr(PKCS10CertificationRequest csr) throws CryptoException {
        try {
            PublicKey pubKey = new JcaPKCS10CertificationRequest(csr).getPublicKey();
            ContentVerifierProvider contentVerifierProvider = new JcaContentVerifierProviderBuilder().setProvider("BC").build(pubKey);
            return csr.isSignatureValid(contentVerifierProvider);
        }
        catch (InvalidKeyException | NoSuchAlgorithmException | OperatorCreationException | PKCSException e) {
            throw new CryptoException(res.getString("NoVerifyPkcs10Csr.exception.message"), e);
        }
    }

    public static byte[] getCsrEncodedDer(PKCS10CertificationRequest csr) throws CryptoException {
        try {
            return csr.getEncoded();
        }
        catch (IOException e) {
            throw new CryptoException(res.getString("NoEncodePkcs10Csr.exception.message"), e);
        }
    }

    public static String getCsrEncodedDerPem(PKCS10CertificationRequest csr) throws CryptoException {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ASN1OutputStream deros = ASN1OutputStream.create((OutputStream)baos, (String)"DER");
            deros.writeObject(csr.toASN1Structure().toASN1Primitive());
            String tmp = new String(Base64.encode((byte[])baos.toByteArray()));
            String csrStr = "-----BEGIN CERTIFICATE REQUEST-----\n";
            for (int i = 0; i < tmp.length(); i += 76) {
                int lineLength = i + 76 > tmp.length() ? tmp.length() - i : 76;
                csrStr = csrStr + tmp.substring(i, i + lineLength) + "\n";
            }
            csrStr = csrStr + "-----END CERTIFICATE REQUEST-----\n";
            return csrStr;
        }
        catch (IOException ex) {
            throw new CryptoException(res.getString("NoPemPkcs10Csr.exception.message"), ex);
        }
    }

    public static PKCS10CertificationRequest loadCsr(byte[] data) throws IOException {
        byte[] csrBytes;
        block39: {
            csrBytes = null;
            try (ByteArrayInputStream bais = new ByteArrayInputStream(data);
                 InputStreamReader inputStreamReader = new InputStreamReader(bais);
                 LineNumberReader lnr = new LineNumberReader(inputStreamReader);){
                String line = lnr.readLine();
                StringBuilder sbPem = new StringBuilder();
                if (line == null || !line.equals(BEGIN_CSR_FORM_1) && !line.equals(BEGIN_CSR_FORM_2)) break block39;
                while ((line = lnr.readLine()) != null) {
                    if (line.equals(END_CSR_FORM_1) || line.equals(END_CSR_FORM_2)) {
                        csrBytes = Base64.decode((String)sbPem.toString());
                        break;
                    }
                    sbPem.append(line);
                }
            }
        }
        if (csrBytes == null) {
            csrBytes = data;
        }
        return new PKCS10CertificationRequest(csrBytes);
    }

    public static X509ExtensionSet getExtensions(PKCS10CertificationRequest pkcs10Csr) {
        ASN1Encodable[] attributeValues;
        Attribute[] attributes = pkcs10Csr.getAttributes(PKCSObjectIdentifiers.pkcs_9_at_extensionRequest);
        X509ExtensionSet x509ExtensionSet = new X509ExtensionSet();
        if (attributes != null && attributes.length > 0 && (attributeValues = attributes[0].getAttributeValues()).length > 0) {
            ASN1Sequence asn1Sequence = ASN1Sequence.getInstance((Object)attributeValues[0]);
            x509ExtensionSet = new X509ExtensionSet(asn1Sequence);
        }
        return x509ExtensionSet;
    }
}

