/*
 * Decompiled with CFR 0.152.
 */
package org.kse.crypto.jcepolicy;

import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.security.NoSuchAlgorithmException;
import java.security.Security;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.ResourceBundle;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import javax.crypto.Cipher;
import org.kse.crypto.CryptoException;
import org.kse.crypto.jcepolicy.CryptoStrength;
import org.kse.crypto.jcepolicy.JcePolicy;
import org.kse.utilities.io.CopyUtil;
import org.kse.utilities.io.IOUtils;
import org.kse.version.JavaVersion;

public class JcePolicyUtil {
    private static ResourceBundle res = ResourceBundle.getBundle("org/kse/crypto/jcepolicy/resources");

    private JcePolicyUtil() {
    }

    public static boolean isLocalPolicyCrytoStrengthLimited() throws CryptoException {
        return JcePolicyUtil.unlimitedStrengthTest() == CryptoStrength.LIMITED;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static CryptoStrength getCryptoStrength(JcePolicy jcePolicy) throws CryptoException {
        JarFile jarFile = null;
        try {
            File file = JcePolicyUtil.getJarFile(jcePolicy);
            if (!file.exists()) {
                CryptoStrength cryptoStrength = CryptoStrength.UNLIMITED;
                return cryptoStrength;
            }
            jarFile = new JarFile(file);
            Manifest jarManifest = jarFile.getManifest();
            String strength = jarManifest.getMainAttributes().getValue("Crypto-Strength");
            if (strength == null) {
                CryptoStrength cryptoStrength = JcePolicyUtil.unlimitedStrengthTest();
                IOUtils.closeQuietly(jarFile);
                return cryptoStrength;
            }
            if (strength.equals(CryptoStrength.LIMITED.manifestValue())) {
                CryptoStrength cryptoStrength = CryptoStrength.LIMITED;
                IOUtils.closeQuietly(jarFile);
                return cryptoStrength;
            }
            CryptoStrength cryptoStrength = CryptoStrength.UNLIMITED;
            IOUtils.closeQuietly(jarFile);
            return cryptoStrength;
        }
        catch (IOException ex) {
            throw new CryptoException(MessageFormat.format(res.getString("NoGetCryptoStrength.exception.message"), new Object[]{jcePolicy}), ex);
        }
        finally {
            IOUtils.closeQuietly(jarFile);
        }
    }

    private static CryptoStrength unlimitedStrengthTest() {
        try {
            if (Cipher.getMaxAllowedKeyLength("AES") >= 256) {
                return CryptoStrength.UNLIMITED;
            }
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            // empty catch block
        }
        return CryptoStrength.LIMITED;
    }

    public static String getPolicyDetails(JcePolicy jcePolicy) throws CryptoException {
        JarFile jarFile = null;
        try {
            StringWriter sw = new StringWriter();
            File file = JcePolicyUtil.getJarFile(jcePolicy);
            if (!file.exists()) {
                String string = "";
                return string;
            }
            jarFile = new JarFile(file);
            Enumeration<JarEntry> jarEntries = jarFile.entries();
            while (jarEntries.hasMoreElements()) {
                JarEntry jarEntry = jarEntries.nextElement();
                String entryName = jarEntry.getName();
                if (jarEntry.isDirectory() || !entryName.endsWith(".policy")) continue;
                sw.write(entryName + ":\n\n");
                try (InputStreamReader isr = new InputStreamReader(jarFile.getInputStream(jarEntry));){
                    CopyUtil.copy(isr, sw);
                }
                sw.write(10);
            }
            String string = sw.toString();
            IOUtils.closeQuietly(jarFile);
            return string;
        }
        catch (IOException ex) {
            throw new CryptoException(MessageFormat.format(res.getString("NoGetPolicyDetails.exception.message"), new Object[]{jcePolicy}), ex);
        }
        finally {
            IOUtils.closeQuietly(jarFile);
        }
    }

    public static File getJarFile(JcePolicy jcePolicy) {
        String fileSeperator = System.getProperty("file.separator");
        String javaHome = System.getProperty("java.home");
        File libSecurityFile = new File(javaHome, "lib" + fileSeperator + "security");
        return new File(libSecurityFile, jcePolicy.jar());
    }

    public static String getJcePolicyDownloadUrl() {
        JavaVersion jreVersion = JavaVersion.getJreVersion();
        int major = jreVersion.getMajor();
        int middle = jreVersion.getMinor();
        int minor = jreVersion.getSecurity();
        String version = MessageFormat.format("{0}.{1}.{2}", major, middle, minor);
        String url = MessageFormat.format("https://keystore-explorer.org/jcePolicyDownload.html?jreversion={0}", version);
        return url;
    }

    public static void removeRestrictions() {
        Security.setProperty("crypto.policy", "unlimited");
    }
}

