/*
 * Decompiled with CFR 0.152.
 */
package org.kse.crypto.x509;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DERIA5String;
import org.bouncycastle.asn1.x509.DisplayText;
import org.bouncycastle.asn1.x509.NoticeReference;
import org.bouncycastle.asn1.x509.PolicyInformation;
import org.bouncycastle.asn1.x509.PolicyQualifierInfo;
import org.bouncycastle.asn1.x509.UserNotice;
import org.kse.crypto.x509.CertificatePolicyQualifierType;

public class PolicyInformationUtil {
    private static ResourceBundle res = ResourceBundle.getBundle("org/kse/crypto/x509/resources");

    private PolicyInformationUtil() {
    }

    public static String toString(PolicyInformation policyInformation) throws IOException {
        StringBuffer sbPolicyInformation = new StringBuffer();
        ASN1ObjectIdentifier policyIdentifier = policyInformation.getPolicyIdentifier();
        sbPolicyInformation.append(MessageFormat.format(res.getString("PolicyInformationUtil.PolicyIdentifier"), policyIdentifier.getId()));
        ASN1Sequence policyQualifiers = policyInformation.getPolicyQualifiers();
        if (policyQualifiers != null) {
            sbPolicyInformation.append(", ");
            StringBuffer sbPolicyQualifiers = new StringBuffer();
            for (int i = 0; i < policyQualifiers.size(); ++i) {
                PolicyQualifierInfo policyQualifierInfo = PolicyQualifierInfo.getInstance((Object)policyQualifiers.getObjectAt(i));
                sbPolicyQualifiers.append(PolicyInformationUtil.toString(policyQualifierInfo));
                if (i + 1 >= policyQualifiers.size()) continue;
                sbPolicyQualifiers.append(", ");
            }
            sbPolicyInformation.append(MessageFormat.format(res.getString("PolicyInformationUtil.PolicyQualifiers"), sbPolicyQualifiers));
        }
        return sbPolicyInformation.toString();
    }

    public static String toString(PolicyQualifierInfo policyQualifierInfo) throws IOException {
        StringBuffer sbPolicyQualifier = new StringBuffer();
        ASN1ObjectIdentifier policyQualifierId = policyQualifierInfo.getPolicyQualifierId();
        CertificatePolicyQualifierType certificatePolicyQualifierType = CertificatePolicyQualifierType.resolveOid(policyQualifierId.getId());
        if (certificatePolicyQualifierType == CertificatePolicyQualifierType.PKIX_CPS_POINTER_QUALIFIER) {
            DERIA5String cpsPointer = (DERIA5String)policyQualifierInfo.getQualifier();
            sbPolicyQualifier.append(MessageFormat.format(res.getString("PolicyInformationUtil.CpsPointer"), cpsPointer));
        } else if (certificatePolicyQualifierType == CertificatePolicyQualifierType.PKIX_USER_NOTICE_QUALIFIER) {
            ASN1Encodable userNoticeObj = policyQualifierInfo.getQualifier();
            UserNotice userNotice = UserNotice.getInstance((Object)userNoticeObj);
            sbPolicyQualifier.append(MessageFormat.format(res.getString("PolicyInformationUtil.UserNotice"), PolicyInformationUtil.toString(userNotice)));
        }
        return sbPolicyQualifier.toString();
    }

    public static String toString(UserNotice userNotice) {
        DisplayText explicitText;
        StringBuffer sbUserNotice = new StringBuffer();
        NoticeReference noticeReference = userNotice.getNoticeRef();
        if (noticeReference != null) {
            DisplayText organization = noticeReference.getOrganization();
            if (organization != null) {
                sbUserNotice.append(MessageFormat.format(res.getString("PolicyInformationUtil.Organization"), organization.getString()));
                if (noticeReference.getNoticeNumbers() != null || userNotice.getExplicitText() != null) {
                    sbUserNotice.append(", ");
                }
            }
            ASN1Integer[] noticeNumbers = noticeReference.getNoticeNumbers();
            StringBuffer sbNoticeNumbers = new StringBuffer();
            if (noticeNumbers != null) {
                for (int i = 0; i < noticeNumbers.length; ++i) {
                    ASN1Integer noticeNumber = noticeNumbers[i];
                    sbNoticeNumbers.append(noticeNumber.getValue().intValue());
                    if (i + 1 >= noticeNumbers.length) continue;
                    sbNoticeNumbers.append(" ");
                }
                sbUserNotice.append(MessageFormat.format(res.getString("PolicyInformationUtil.NoticeNumbers"), sbNoticeNumbers.toString()));
                if (userNotice.getExplicitText() != null) {
                    sbUserNotice.append(", ");
                }
            }
        }
        if ((explicitText = userNotice.getExplicitText()) != null) {
            sbUserNotice.append(MessageFormat.format(res.getString("PolicyInformationUtil.ExplicitText"), explicitText.getString()));
        }
        return sbUserNotice.toString();
    }
}

