/*
 * Decompiled with CFR 0.152.
 */
package org.kse.crypto.x509;

import java.util.ArrayList;
import java.util.List;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.x509.CertPolicyId;
import org.bouncycastle.asn1.x509.PolicyMappings;
import org.kse.crypto.x509.PolicyMapping;

public class PolicyMappingsUtil {
    private PolicyMappingsUtil() {
    }

    public static List<PolicyMapping> getListOfPolicyMappings(PolicyMappings policyMappings) {
        ASN1Sequence policyMappingsSeq = (ASN1Sequence)policyMappings.toASN1Primitive();
        ASN1Encodable[] policyMappingsArray = policyMappingsSeq.toArray();
        ArrayList<PolicyMapping> policyMappingsList = new ArrayList<PolicyMapping>();
        for (ASN1Encodable asn1Encodable : policyMappingsArray) {
            policyMappingsList.add(PolicyMapping.getInstance(asn1Encodable));
        }
        return policyMappingsList;
    }

    public static PolicyMappings createFromList(List<PolicyMapping> listOfPolicyMappings) {
        CertPolicyId[] issuerDomainPolicies = new CertPolicyId[listOfPolicyMappings.size()];
        CertPolicyId[] subjectDomainPolicies = new CertPolicyId[listOfPolicyMappings.size()];
        for (int i = 0; i < listOfPolicyMappings.size(); ++i) {
            PolicyMapping policyMapping = listOfPolicyMappings.get(i);
            issuerDomainPolicies[i] = CertPolicyId.getInstance((Object)policyMapping.getIssuerDomainPolicy());
            subjectDomainPolicies[i] = CertPolicyId.getInstance((Object)policyMapping.getSubjectDomainPolicy());
        }
        return new PolicyMappings(issuerDomainPolicies, subjectDomainPolicies);
    }

    public static PolicyMappings add(PolicyMapping policyMapping, PolicyMappings policyMappings) {
        List<PolicyMapping> policyMappingsList = PolicyMappingsUtil.getListOfPolicyMappings(policyMappings);
        policyMappingsList.add(policyMapping);
        policyMappings = PolicyMappingsUtil.createFromList(policyMappingsList);
        return policyMappings;
    }

    public static PolicyMappings remove(PolicyMapping policyMapping, PolicyMappings policyMappings) {
        List<PolicyMapping> policyMappingsList = PolicyMappingsUtil.getListOfPolicyMappings(policyMappings);
        policyMappingsList.remove((Object)policyMapping);
        policyMappings = PolicyMappingsUtil.createFromList(policyMappingsList);
        return policyMappings;
    }
}

