/*
 * Decompiled with CFR 0.152.
 */
package org.kse.crypto.x509;

import java.util.ResourceBundle;

public enum ValidityModelType {
    CHAIN_MODEL("1.3.6.1.4.1.8301.3.5.1", "ChainModel"),
    SHELL_MODEL("1.3.6.1.4.1.8301.3.5.2", "ShellModel");

    private static ResourceBundle res;
    private String oid;
    private String friendlyKey;

    private ValidityModelType(String oid, String friendlyKey) {
        this.oid = oid;
        this.friendlyKey = friendlyKey;
    }

    public String friendly() {
        return res.getString(this.friendlyKey);
    }

    public static ValidityModelType resolveOid(String oid) {
        for (ValidityModelType type : ValidityModelType.values()) {
            if (!oid.equals(type.oid())) continue;
            return type;
        }
        return null;
    }

    public String oid() {
        return this.oid;
    }

    static {
        res = ResourceBundle.getBundle("org/kse/crypto/x509/resources");
    }
}

