/*
 * Decompiled with CFR 0.152.
 */
package org.kse.crypto.x509;

import java.io.IOException;
import javax.security.auth.x500.X500Principal;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.x500.AttributeTypeAndValue;
import org.bouncycastle.asn1.x500.RDN;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x500.X500NameBuilder;
import org.bouncycastle.asn1.x500.X500NameStyle;
import org.bouncycastle.asn1.x500.style.BCStyle;
import org.kse.crypto.x509.KseX500NameStyle;

public class X500NameUtils {
    private X500NameUtils() {
    }

    public static X500Name x500PrincipalToX500Name(X500Principal principal) {
        return X500Name.getInstance((X500NameStyle)KseX500NameStyle.INSTANCE, (Object)principal.getEncoded());
    }

    public static X500Principal x500NameToX500Principal(X500Name name) throws IOException {
        return new X500Principal(name.getEncoded());
    }

    public static String getRdn(X500Name dn, ASN1ObjectIdentifier rdnOid) {
        if (dn == null || rdnOid == null) {
            return "";
        }
        RDN[] rdns = dn.getRDNs(rdnOid);
        String value = "";
        if (rdns.length > 0) {
            RDN rdn = rdns[0];
            value = rdn.getFirst().getValue().toString();
        }
        return value;
    }

    public static String extractCN(X500Name name) {
        for (RDN rdn : name.getRDNs()) {
            AttributeTypeAndValue atav = rdn.getFirst();
            if (!atav.getType().equals((ASN1Primitive)BCStyle.CN)) continue;
            return atav.getValue().toString();
        }
        return "";
    }

    public static String extractCN(X500Principal principal) {
        return X500NameUtils.extractCN(X500NameUtils.x500PrincipalToX500Name(principal));
    }

    public static X500Name buildX500Name(String commonName, String organisationUnit, String organisationName, String localityName, String stateName, String countryCode, String emailAddress) {
        X500NameBuilder x500NameBuilder = new X500NameBuilder((X500NameStyle)KseX500NameStyle.INSTANCE);
        if (emailAddress != null) {
            x500NameBuilder.addRDN(BCStyle.E, emailAddress);
        }
        if (countryCode != null) {
            x500NameBuilder.addRDN(BCStyle.C, countryCode);
        }
        if (stateName != null) {
            x500NameBuilder.addRDN(BCStyle.ST, stateName);
        }
        if (localityName != null) {
            x500NameBuilder.addRDN(BCStyle.L, localityName);
        }
        if (organisationName != null) {
            x500NameBuilder.addRDN(BCStyle.O, organisationName);
        }
        if (organisationUnit != null) {
            x500NameBuilder.addRDN(BCStyle.OU, organisationUnit);
        }
        if (commonName != null) {
            x500NameBuilder.addRDN(BCStyle.CN, commonName);
        }
        return x500NameBuilder.build();
    }
}

