/*
 * Decompiled with CFR 0.152.
 */
package org.kse.gui;

import java.awt.FlowLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ResourceBundle;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import org.kse.gui.KseFrame;
import org.kse.gui.actions.CloseAction;
import org.kse.utilities.history.KeyStoreHistory;

public class KeyStoreTab
extends JPanel {
    private static final long serialVersionUID = 1L;
    private static ResourceBundle res = ResourceBundle.getBundle("org/kse/gui/resources");
    private JLabel jlTitle;
    private JButton jbClose;
    private KseFrame kseFrame;
    private KeyStoreHistory history;

    public KeyStoreTab(String title, KseFrame kseFrame, KeyStoreHistory history) {
        this.kseFrame = kseFrame;
        this.history = history;
        this.initComponents(title);
    }

    private void initComponents(String title) {
        this.jlTitle = new JLabel(title);
        this.jlTitle.setBorder(new EmptyBorder(0, 0, 0, 5));
        this.jbClose = new JButton();
        this.jbClose.setToolTipText(res.getString("KeyStoreTab.jbClose.tooltip"));
        final ImageIcon icon = new ImageIcon(Toolkit.getDefaultToolkit().createImage(this.getClass().getResource("images/tab/close_tab.png")));
        final ImageIcon rollOverIcon = new ImageIcon(Toolkit.getDefaultToolkit().createImage(this.getClass().getResource("images/tab/close_tab_rollover.png")));
        this.jbClose.setSize(icon.getImage().getWidth(null), icon.getImage().getHeight(null));
        this.jbClose.setIcon(icon);
        this.jbClose.setRolloverEnabled(false);
        this.jbClose.setMargin(new Insets(0, 0, 0, 0));
        this.jbClose.setBorderPainted(false);
        this.jbClose.setBorder(null);
        this.jbClose.setText(null);
        this.jbClose.setContentAreaFilled(false);
        this.jbClose.setFocusPainted(false);
        this.jbClose.setFocusable(false);
        this.jbClose.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent evt) {
                KeyStoreTab.this.jbClose.setIcon(rollOverIcon);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                KeyStoreTab.this.jbClose.setIcon(icon);
            }
        });
        this.jbClose.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                KeyStoreTab.this.jbClose.setIcon(icon);
                CloseAction closeAction = new CloseAction(KeyStoreTab.this.kseFrame);
                closeAction.closeKeyStore(KeyStoreTab.this.history);
            }
        });
        this.setOpaque(false);
        this.setLayout(new FlowLayout(1, 0, 0));
        this.add(this.jlTitle);
        this.add(this.jbClose);
    }

    public void updateTitle(String title) {
        this.jlTitle.setText(title);
    }
}

