/*
 * Decompiled with CFR 0.152.
 */
package org.kse.gui.about;

import java.awt.Color;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.Dialog;
import java.awt.Image;
import java.awt.LayoutManager;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import net.miginfocom.swing.MigLayout;
import org.kse.KSE;
import org.kse.gui.JEscDialog;
import org.kse.gui.LnfUtil;
import org.kse.gui.PlatformUtil;
import org.kse.gui.actions.AboutAction;
import org.kse.gui.ticker.JTicker;
import org.kse.utilities.DialogViewer;

public class DAbout
extends JEscDialog {
    private static final long serialVersionUID = 1L;
    private static ResourceBundle res = ResourceBundle.getBundle("org/kse/gui/about/resources");
    private static final Color KSE_COLOR = LnfUtil.isDarkLnf() ? new Color(116, 131, 141) : new Color(0, 134, 201);
    private JPanel jpAbout = new JPanel();
    private JLabel jlKSE = new JLabel(KSE.getApplicationName());
    private JLabel jlIcon;
    private JLabel jlVersion;
    private JLabel jlLicense;
    private JTicker jtkDetails;
    private JButton jbOK;
    private JButton jbCredits;

    public DAbout(JFrame parent, String title, String licenseNotice, Image aboutImg, Object[] tickerItems) {
        super((Window)parent, title, Dialog.ModalityType.DOCUMENT_MODAL);
        this.initComponents(aboutImg, licenseNotice, tickerItems);
    }

    private void initComponents(Image aboutImg, String licenseNotice, Object[] tickerItems) {
        this.jtkDetails = new JTicker();
        this.jtkDetails.setIncrement(1);
        this.jtkDetails.setGap(40);
        this.jtkDetails.setInterval(20);
        for (int i = 0; i < tickerItems.length; ++i) {
            this.jtkDetails.addItem(tickerItems[i]);
        }
        this.jlKSE = new JLabel(KSE.getApplicationName());
        this.jlKSE.setFont(this.jlKSE.getFont().deriveFont(20.0f));
        this.jlKSE.setForeground(KSE_COLOR);
        this.jlIcon = new JLabel(new ImageIcon(aboutImg));
        this.jlVersion = new JLabel("Version " + KSE.getApplicationVersion());
        this.jlLicense = new JLabel(licenseNotice);
        this.jbOK = new JButton(res.getString("DAbout.jbOK.text"));
        this.jbOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DAbout.this.okPressed();
            }
        });
        this.jbCredits = new JButton(res.getString("DAbout.jbCredits.text"));
        PlatformUtil.setMnemonic((AbstractButton)this.jbCredits, res.getString("DAbout.jbCredits.mnemonic").charAt(0));
        this.jbCredits.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DAbout.this.openCreditsPageInBrowser();
            }
        });
        this.jpAbout.setLayout((LayoutManager)new MigLayout("insets dialog, fill"));
        this.jpAbout.add((Component)this.jlKSE, "top");
        this.jpAbout.add((Component)this.jlIcon, "top, right, spany 2, wrap unrel");
        this.jpAbout.add((Component)this.jlVersion, "top, wrap para");
        this.jpAbout.add((Component)this.jlLicense, "span, wrap unrel");
        this.jpAbout.add((Component)this.jtkDetails, "width 100%, span, wrap para:push");
        this.jpAbout.add((Component)this.jbCredits, "");
        this.jpAbout.add((Component)this.jbOK, "tag ok");
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                DAbout.this.closeDialog();
            }
        });
        this.getContentPane().add(this.jpAbout);
        this.getRootPane().setDefaultButton(this.jbOK);
        this.setResizable(false);
        this.pack();
        this.jtkDetails.start();
        this.jbOK.requestFocusInWindow();
    }

    protected void openCreditsPageInBrowser() {
        try {
            Desktop.getDesktop().browse(URI.create("https://keystore-explorer.org/contribute.html#contributions"));
        }
        catch (IOException ex) {
            JOptionPane.showMessageDialog(this, MessageFormat.format(res.getString("WebsiteAction.NoLaunchBrowser.message"), "https://keystore-explorer.org/contribute.html#contributions"), KSE.getApplicationName(), 1);
        }
    }

    private void okPressed() {
        this.closeDialog();
    }

    private void closeDialog() {
        this.setVisible(false);
        this.jtkDetails.stop();
        this.dispose();
    }

    public static void main(String[] args) throws Exception {
        Object[] tickerItems = new Object[]{"Copyright 2004 -2013 Wayne Grant, 2013 - 2020 Kai Kramer ..."};
        URL kseIconUrl = AboutAction.class.getResource("images/aboutdlg.png");
        DAbout dialog = new DAbout(new JFrame(), "About", "See help for details of the end user license agreement.", Toolkit.getDefaultToolkit().getImage(kseIconUrl), tickerItems);
        DialogViewer.run(dialog);
    }
}

