/*
 * Decompiled with CFR 0.152.
 */
package org.kse.gui.about;

import java.util.Comparator;
import java.util.Enumeration;
import java.util.Map;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.TreeMap;
import javax.swing.table.AbstractTableModel;

public class SystemPropertiesTableModel
extends AbstractTableModel {
    private static final long serialVersionUID = 1L;
    private static ResourceBundle res = ResourceBundle.getBundle("org/kse/gui/about/resources");
    private String[] columnNames = new String[2];
    private Object[][] data;

    public SystemPropertiesTableModel() {
        this.columnNames[0] = res.getString("SystemPropertiesTableModel.NameColumn");
        this.columnNames[1] = res.getString("SystemPropertiesTableModel.ValueColumn");
        this.data = new Object[0][0];
    }

    public void load() {
        Properties sysProps = System.getProperties();
        TreeMap<String, String> sortedSysProps = new TreeMap<String, String>(new SystemPropertyComparator());
        Enumeration<?> names = sysProps.propertyNames();
        while (names.hasMoreElements()) {
            String name = (String)names.nextElement();
            String value = sysProps.getProperty(name);
            if (name.equals("line.separator")) {
                value = this.convertLineSeperatorToBePrintable(value);
            }
            sortedSysProps.put(name, value);
        }
        this.data = new Object[sortedSysProps.size()][2];
        int i = 0;
        for (Map.Entry property : sortedSysProps.entrySet()) {
            this.data[i][0] = property.getKey();
            this.data[i][1] = property.getValue();
            ++i;
        }
        this.fireTableDataChanged();
    }

    private String convertLineSeperatorToBePrintable(String value) {
        StringBuilder sbValue = new StringBuilder();
        for (int i = 0; i < value.length(); ++i) {
            if (value.charAt(i) == '\r') {
                sbValue.append("\\r");
                continue;
            }
            if (value.charAt(i) == '\n') {
                sbValue.append("\\n");
                continue;
            }
            sbValue.append(value);
        }
        return sbValue.toString();
    }

    @Override
    public int getColumnCount() {
        return this.columnNames.length;
    }

    @Override
    public int getRowCount() {
        return this.data.length;
    }

    @Override
    public String getColumnName(int col) {
        return this.columnNames[col];
    }

    @Override
    public Object getValueAt(int row, int col) {
        return this.data[row][col];
    }

    @Override
    public Class<?> getColumnClass(int col) {
        return String.class;
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        return false;
    }

    private class SystemPropertyComparator
    implements Comparator<String> {
        private SystemPropertyComparator() {
        }

        @Override
        public int compare(String name1, String name2) {
            return name1.compareToIgnoreCase(name2);
        }
    }
}

