/*
 * Decompiled with CFR 0.152.
 */
package org.kse.gui.actions;

import java.io.File;
import java.io.FileNotFoundException;
import java.security.KeyStore;
import java.text.MessageFormat;
import javax.swing.JOptionPane;
import org.kse.AuthorityCertificates;
import org.kse.crypto.CryptoException;
import org.kse.crypto.Password;
import org.kse.crypto.keystore.KeyStoreLoadException;
import org.kse.crypto.keystore.KeyStoreUtil;
import org.kse.gui.KseFrame;
import org.kse.gui.actions.KeyStoreExplorerAction;
import org.kse.gui.error.DError;
import org.kse.gui.error.DProblem;
import org.kse.gui.error.Problem;
import org.kse.gui.password.DGetPassword;

public abstract class AuthorityCertificatesAction
extends KeyStoreExplorerAction {
    private static final long serialVersionUID = 1L;

    public AuthorityCertificatesAction(KseFrame kseFrame) {
        super(kseFrame);
    }

    protected KeyStore getCaCertificates() {
        AuthorityCertificates authorityCertificates = AuthorityCertificates.getInstance();
        KeyStore caCertificates = null;
        if (this.applicationSettings.getUseCaCertificates() && (caCertificates = authorityCertificates.getCaCertificates()) == null && (caCertificates = this.loadCaCertificatesKeyStore()) != null) {
            authorityCertificates.setCaCertificates(caCertificates);
        }
        return caCertificates;
    }

    protected KeyStore getWindowsTrustedRootCertificates() throws CryptoException {
        AuthorityCertificates authorityCertificates = AuthorityCertificates.getInstance();
        KeyStore windowsTrustedRootCertificates = null;
        if (this.applicationSettings.getUseWindowsTrustedRootCertificates()) {
            windowsTrustedRootCertificates = authorityCertificates.getWindowsTrustedRootCertificates();
        }
        return windowsTrustedRootCertificates;
    }

    private KeyStore loadCaCertificatesKeyStore() {
        File caCertificatesFile = this.applicationSettings.getCaCertificatesFile();
        KeyStore caCertificatesKeyStore = null;
        try {
            try {
                Password password = new Password("changeit".toCharArray());
                caCertificatesKeyStore = KeyStoreUtil.load(caCertificatesFile, password);
                if (caCertificatesKeyStore != null) {
                    return caCertificatesKeyStore;
                }
            }
            catch (KeyStoreLoadException password) {
                // empty catch block
            }
            DGetPassword dGetPassword = new DGetPassword(this.frame, res.getString("AuthorityCertificatesAction.CaCertificatesKeyStorePassword.Title"));
            dGetPassword.setLocationRelativeTo(this.frame);
            dGetPassword.setVisible(true);
            Password password = dGetPassword.getPassword();
            if (password == null) {
                return null;
            }
            try {
                caCertificatesKeyStore = KeyStoreUtil.load(caCertificatesFile, password);
            }
            catch (KeyStoreLoadException ex) {
                String problemStr = MessageFormat.format(res.getString("AuthorityCertificatesAction.NoOpenCaCertificatesKeyStore.Problem"), new Object[]{ex.getKeyStoreType(), caCertificatesFile.getName()});
                String[] causes = new String[]{res.getString("AuthorityCertificatesAction.PasswordIncorrectKeyStore.Cause"), res.getString("AuthorityCertificatesAction.CorruptedKeyStore.Cause")};
                Problem problem = new Problem(problemStr, causes, ex);
                DProblem dProblem = new DProblem(this.frame, res.getString("AuthorityCertificatesAction.ProblemOpeningCaCertificatesKeyStore.Title"), problem);
                dProblem.setLocationRelativeTo(this.frame);
                dProblem.setVisible(true);
                return null;
            }
            if (caCertificatesKeyStore == null) {
                JOptionPane.showMessageDialog(this.frame, MessageFormat.format(res.getString("AuthorityCertificatesAction.FileNotRecognisedType.message"), caCertificatesFile.getName()), res.getString("AuthorityCertificatesAction.OpenCaCertificatesKeyStore.Title"), 2);
                return null;
            }
            return caCertificatesKeyStore;
        }
        catch (FileNotFoundException ex) {
            JOptionPane.showMessageDialog(this.frame, MessageFormat.format(res.getString("AuthorityCertificatesAction.NoReadFile.message"), caCertificatesFile), res.getString("AuthorityCertificatesAction.OpenCaCertificatesKeyStore.Title"), 2);
            return null;
        }
        catch (Exception ex) {
            DError.displayError(this.frame, (Throwable)ex);
            return null;
        }
    }
}

