/*
 * Decompiled with CFR 0.152.
 */
package org.kse.gui.actions;

import java.awt.Toolkit;
import java.security.KeyStore;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;
import org.kse.gui.KseFrame;
import org.kse.gui.actions.KeyStoreExplorerAction;
import org.kse.gui.error.DError;
import org.kse.utilities.history.HistoryAction;
import org.kse.utilities.history.KeyStoreHistory;
import org.kse.utilities.history.KeyStoreState;

public class DeleteMultipleEntriesAction
extends KeyStoreExplorerAction
implements HistoryAction {
    private static final long serialVersionUID = 1L;

    public DeleteMultipleEntriesAction(KseFrame kseFrame) {
        super(kseFrame);
        this.putValue("LongDescription", res.getString("DeleteMultipleEntriesAction.statusbar"));
        this.putValue("Name", res.getString("DeleteMultipleEntriesAction.text"));
        this.putValue("ShortDescription", res.getString("DeleteMultipleEntriesAction.tooltip"));
        this.putValue("SmallIcon", new ImageIcon(Toolkit.getDefaultToolkit().createImage(this.getClass().getResource("images/delete.png"))));
    }

    @Override
    public String getHistoryDescription() {
        return (String)this.getValue("Name");
    }

    @Override
    protected void doAction() {
        this.deleteSelectedEntries();
    }

    public void deleteSelectedEntries() {
        String[] aliases = this.kseFrame.getSelectedEntryAliases();
        if (aliases.length == 0) {
            return;
        }
        try {
            KeyStoreHistory history = this.kseFrame.getActiveKeyStoreHistory();
            KeyStoreState currentState = history.getCurrentState();
            KeyStoreState newState = currentState.createBasisForNextState(this);
            KeyStore keyStore = newState.getKeyStore();
            int selected = JOptionPane.showConfirmDialog(this.frame, res.getString("DeleteMultipleEntriesAction.ConfirmDelete.message"), res.getString("DeleteMultipleEntriesAction.DeleteEntry.Title"), 0);
            if (selected != 0) {
                return;
            }
            for (String alias : aliases) {
                keyStore.deleteEntry(alias);
                newState.removeEntryPassword(alias);
            }
            currentState.append(newState);
            this.kseFrame.updateControls(true);
        }
        catch (Exception ex) {
            DError.displayError(this.frame, (Throwable)ex);
        }
    }
}

