/*
 * Decompiled with CFR 0.152.
 */
package org.kse.gui.actions;

import java.awt.Toolkit;
import java.security.KeyPair;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.text.MessageFormat;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;
import org.kse.crypto.Password;
import org.kse.crypto.keypair.KeyPairType;
import org.kse.crypto.keystore.KeyStoreType;
import org.kse.crypto.x509.X509CertUtil;
import org.kse.gui.KseFrame;
import org.kse.gui.actions.KeyStoreExplorerAction;
import org.kse.gui.dialogs.DGenerateKeyPair;
import org.kse.gui.dialogs.DGenerateKeyPairCert;
import org.kse.gui.dialogs.DGeneratingKeyPair;
import org.kse.gui.dialogs.DGetAlias;
import org.kse.gui.error.DError;
import org.kse.gui.password.DGetNewPassword;
import org.kse.utilities.history.HistoryAction;
import org.kse.utilities.history.KeyStoreHistory;
import org.kse.utilities.history.KeyStoreState;

public class GenerateKeyPairAction
extends KeyStoreExplorerAction
implements HistoryAction {
    private static final long serialVersionUID = 1L;

    public GenerateKeyPairAction(KseFrame kseFrame) {
        super(kseFrame);
        this.putValue("AcceleratorKey", KeyStroke.getKeyStroke((int)res.getString("GenerateKeyPairAction.accelerator").charAt(0), Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        this.putValue("LongDescription", res.getString("GenerateKeyPairAction.statusbar"));
        this.putValue("Name", res.getString("GenerateKeyPairAction.text"));
        this.putValue("ShortDescription", res.getString("GenerateKeyPairAction.tooltip"));
        this.putValue("SmallIcon", new ImageIcon(Toolkit.getDefaultToolkit().createImage(this.getClass().getResource("images/genkeypair.png"))));
    }

    @Override
    public String getHistoryDescription() {
        return (String)this.getValue("Name");
    }

    @Override
    protected void doAction() {
        this.generateKeyPair();
    }

    public void generateKeyPair() {
        this.generateKeyPair(null, null, null);
    }

    public String generateKeyPair(X509Certificate issuerCert, X509Certificate[] issuerCertChain, PrivateKey issuerPrivateKey) {
        String alias = "";
        try {
            String message;
            int selected;
            DGeneratingKeyPair dGeneratingKeyPair;
            int keyPairSize = this.applicationSettings.getGenerateKeyPairSize();
            KeyPairType keyPairType = this.applicationSettings.getGenerateKeyPairType();
            KeyStore activeKeyStore = this.kseFrame.getActiveKeyStore();
            KeyStoreType activeKeyStoreType = KeyStoreType.resolveJce(activeKeyStore.getType());
            KeyStoreHistory history = this.kseFrame.getActiveKeyStoreHistory();
            Provider provider = history.getExplicitProvider();
            DGenerateKeyPair dGenerateKeyPair = new DGenerateKeyPair(this.frame, activeKeyStoreType, keyPairType, keyPairSize);
            dGenerateKeyPair.setLocationRelativeTo(this.frame);
            dGenerateKeyPair.setVisible(true);
            if (!dGenerateKeyPair.isSuccessful()) {
                return "";
            }
            keyPairType = dGenerateKeyPair.getKeyPairType();
            if (keyPairType != KeyPairType.EC) {
                keyPairSize = dGenerateKeyPair.getKeyPairSize();
                dGeneratingKeyPair = new DGeneratingKeyPair(this.frame, keyPairType, keyPairSize, provider);
                this.applicationSettings.setGenerateKeyPairSize(keyPairSize);
                this.applicationSettings.setGenerateKeyPairType(keyPairType);
            } else {
                String curveName = dGenerateKeyPair.getCurveName();
                dGeneratingKeyPair = new DGeneratingKeyPair(this.frame, keyPairType, curveName, provider);
            }
            dGeneratingKeyPair.setLocationRelativeTo(this.frame);
            dGeneratingKeyPair.startKeyPairGeneration();
            dGeneratingKeyPair.setVisible(true);
            KeyPair keyPair = dGeneratingKeyPair.getKeyPair();
            if (keyPair == null) {
                return "";
            }
            DGenerateKeyPairCert dGenerateKeyPairCert = new DGenerateKeyPairCert(this.frame, res.getString("GenerateKeyPairAction.GenerateKeyPairCert.Title"), keyPair, keyPairType, issuerCert, issuerPrivateKey, provider);
            dGenerateKeyPairCert.setLocationRelativeTo(this.frame);
            dGenerateKeyPairCert.setVisible(true);
            X509Certificate certificate = dGenerateKeyPairCert.getCertificate();
            if (certificate == null) {
                return "";
            }
            KeyStoreState currentState = history.getCurrentState();
            KeyStoreState newState = currentState.createBasisForNextState(this);
            KeyStore keyStore = newState.getKeyStore();
            DGetAlias dGetAlias = new DGetAlias(this.frame, res.getString("GenerateKeyPairAction.NewKeyPairEntryAlias.Title"), X509CertUtil.getCertificateAlias(certificate));
            dGetAlias.setLocationRelativeTo(this.frame);
            dGetAlias.setVisible(true);
            alias = dGetAlias.getAlias();
            if (alias == null) {
                return "";
            }
            if (keyStore.containsAlias(alias) && (selected = JOptionPane.showConfirmDialog(this.frame, message = MessageFormat.format(res.getString("GenerateKeyPairAction.OverWriteEntry.message"), alias), res.getString("GenerateKeyPairAction.NewKeyPairEntryAlias.Title"), 0)) != 0) {
                return "";
            }
            Password password = new Password((char[])null);
            KeyStoreType keyStoreType = KeyStoreType.resolveJce(activeKeyStore.getType());
            if (keyStoreType.hasEntryPasswords()) {
                DGetNewPassword dGetNewPassword = new DGetNewPassword(this.frame, res.getString("GenerateKeyPairAction.NewKeyPairEntryPassword.Title"), this.applicationSettings.getPasswordQualityConfig());
                dGetNewPassword.setLocationRelativeTo(this.frame);
                dGetNewPassword.setVisible(true);
                password = dGetNewPassword.getPassword();
                if (password == null) {
                    return "";
                }
            }
            if (keyStore.containsAlias(alias)) {
                keyStore.deleteEntry(alias);
                newState.removeEntryPassword(alias);
            }
            Certificate[] newCertChain = null;
            if (issuerCertChain != null) {
                newCertChain = new X509Certificate[issuerCertChain.length + 1];
                System.arraycopy(issuerCertChain, 0, newCertChain, 1, issuerCertChain.length);
                newCertChain[0] = certificate;
            } else {
                newCertChain = new X509Certificate[]{certificate};
            }
            keyStore.setKeyEntry(alias, keyPair.getPrivate(), password.toCharArray(), newCertChain);
            newState.setEntryPassword(alias, password);
            currentState.append(newState);
            this.kseFrame.updateControls(true);
            JOptionPane.showMessageDialog(this.frame, res.getString("GenerateKeyPairAction.KeyPairGenerationSuccessful.message"), res.getString("GenerateKeyPairAction.GenerateKeyPair.Title"), 1);
        }
        catch (Exception ex) {
            DError.displayError(this.frame, (Throwable)ex);
        }
        return alias;
    }
}

