/*
 * Decompiled with CFR 0.152.
 */
package org.kse.gui.actions;

import java.awt.Toolkit;
import java.security.Key;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.text.MessageFormat;
import javax.crypto.SecretKey;
import javax.swing.ImageIcon;
import org.kse.crypto.CryptoException;
import org.kse.crypto.Password;
import org.kse.gui.KseFrame;
import org.kse.gui.actions.GenerateSecretKeyAction;
import org.kse.gui.actions.KeyStoreExplorerAction;
import org.kse.gui.dialogs.DViewPrivateKey;
import org.kse.gui.dialogs.DViewPublicKey;
import org.kse.gui.dialogs.DViewSecretKey;
import org.kse.gui.error.DError;
import org.kse.utilities.history.KeyStoreHistory;
import org.kse.utilities.history.KeyStoreState;

public class KeyDetailsAction
extends KeyStoreExplorerAction {
    private static final long serialVersionUID = 1L;

    public KeyDetailsAction(KseFrame kseFrame) {
        super(kseFrame);
        this.putValue("LongDescription", res.getString("KeyDetailsAction.statusbar"));
        this.putValue("Name", res.getString("KeyDetailsAction.text"));
        this.putValue("ShortDescription", res.getString("KeyDetailsAction.tooltip"));
        this.putValue("SmallIcon", new ImageIcon(Toolkit.getDefaultToolkit().createImage(this.getClass().getResource("images/keydetails.png"))));
    }

    @Override
    protected void doAction() {
        this.showKeySelectedEntry();
    }

    public void showKeySelectedEntry() {
        try {
            KeyStoreHistory history = this.kseFrame.getActiveKeyStoreHistory();
            KeyStoreState currentState = history.getCurrentState();
            String alias = this.kseFrame.getSelectedEntryAlias();
            Password password = this.getEntryPassword(alias, currentState);
            if (password == null) {
                return;
            }
            KeyStore keyStore = currentState.getKeyStore();
            Key key = keyStore.getKey(alias, password.toCharArray());
            if (key instanceof SecretKey) {
                SecretKey secretKey = (SecretKey)key;
                DViewSecretKey dViewSecretKey = new DViewSecretKey(this.frame, MessageFormat.format(res.getString("KeyDetailsAction.SecretKeyDetailsEntry.Title"), alias), secretKey, true);
                dViewSecretKey.setLocationRelativeTo(this.frame);
                dViewSecretKey.setVisible(true);
                if (dViewSecretKey.keyHasChanged()) {
                    this.updateSecretKey(currentState, alias, password, dViewSecretKey);
                }
            } else if (key instanceof PrivateKey) {
                PrivateKey privateKey = (PrivateKey)key;
                DViewPrivateKey dViewPrivateKey = new DViewPrivateKey(this.frame, MessageFormat.format(res.getString("KeyDetailsAction.PrivateKeyDetailsEntry.Title"), alias), privateKey);
                dViewPrivateKey.setLocationRelativeTo(this.frame);
                dViewPrivateKey.setVisible(true);
            } else if (key instanceof PublicKey) {
                PublicKey publicKey = (PublicKey)key;
                DViewPublicKey dViewPublicKey = new DViewPublicKey(this.frame, MessageFormat.format(res.getString("KeyDetailsAction.PublicKeyDetailsEntry.Title"), alias), publicKey);
                dViewPublicKey.setLocationRelativeTo(this.frame);
                dViewPublicKey.setVisible(true);
            }
        }
        catch (Exception ex) {
            DError.displayError(this.frame, (Throwable)ex);
        }
    }

    private void updateSecretKey(KeyStoreState currentState, String alias, Password password, DViewSecretKey dViewSecretKey) throws CryptoException, KeyStoreException {
        KeyStoreState newState = currentState.createBasisForNextState(new GenerateSecretKeyAction(this.kseFrame));
        KeyStore keyStore = newState.getKeyStore();
        SecretKey newSecretKey = dViewSecretKey.getSecretKey();
        keyStore.deleteEntry(alias);
        newState.removeEntryPassword(alias);
        keyStore.setKeyEntry(alias, newSecretKey, password.toCharArray(), null);
        newState.setEntryPassword(alias, password);
        currentState.append(newState);
        this.kseFrame.updateControls(true);
    }
}

